#ifndef lint
static char SCCSid[] = "@(#) ./blog/blog.c 07/23/93";
#endif

#include <stdio.h>
#if !defined(solaris)
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include "comm/comm.h"
#include "blog/blog.h"
#include "system/system.h"

/* 
   This is a reduced overhead (both time and space, particularly calls to
   malloc) version of alog.  It can write alog-formatted files, so all
   alog-based tools can work with them.  In addition, the times are
   corrected in parallel.  A routine to perform a parallel merging of the 
   log files will be added.
 */   
#ifdef OLD_VERSION
int xx_BLOG_status = 0x3;	/* Logging turned ON  (default) */
#else
int xx_BLOG_status = 0x2;	/* Logging turned OFF and not initialized 
				   (default) */
#endif
char xx_BLOG_outdir[MAX_DIRNAME_LEN] = "";

typedef struct _blog { struct _blog *next; int size; } BLOG_BLOCK;
static BLOG_BLOCK *bblock = 0, *btail = 0;
/* 
   Current bug: when the buffer is exhausted, it just gets overwritten.
   Alog handles this better.  What we should do here is keep a chain
   of filled buffers, with xx_BLOG<etc> being the current buffer.
 */
int *xx_BLOG     = 0;
int xx_BLOG_i    = 501;
int xx_BLOG_size = 500;

/* Here are routines to add the records for an event with no extra data */
void xx_BLOG_LOG( type )
int type;
{
BLOG_HEADER *b;

if (xx_BLOG_status >= 3) {
    fprintf(stderr, "BLOG: Error: event logging requested by PID %d before doing BLOG setup\n", MYPROCID);
    return;
    }
if (xx_BLOG_status & 0x1) {
    if (xx_BLOG_i + BLOGHEADERSIZE > xx_BLOG_size)
	if (xx_BLOG_flush()) return;
    BLOGADDHEADER(b,type);
    }
}

void xx_BLOG_LOGI( type, d1 )
int type, d1;
{
BLOG_HEADER *b;
BLOG_VFIELD *v;
if (xx_BLOG_status >= 3) {
    fprintf(stderr, "BLOG: Error: event logging requested by PID %d before doing BLOG setup\n", MYPROCID);
    return;
    }
if (xx_BLOG_status & 0x1) {
    if (xx_BLOG_i + BLOGHEADERSIZE + BLOGVFIELDSIZE(1) > xx_BLOG_size)
	if (xx_BLOG_flush()) return;
    BLOGADDHEADER(b,type);
    BLOGADDINTS(b,v,1,&d1);
    }
}

void xx_BLOG_LOG4(n1,n2,n3,n4)
int n1, n2, n3, n4;
{
BLOG_HEADER *b;
BLOG_VFIELD *v;
int         i[3];
if (xx_BLOG_status >= 3) {
    fprintf(stderr, "BLOG: Error: event logging requested by PID %d before doing BLOG setup\n", MYPROCID);
    return;
    }
if (xx_BLOG_status & 0x1) {
    if (xx_BLOG_i + BLOGHEADERSIZE + BLOGVFIELDSIZE(3) > xx_BLOG_size)
	if (xx_BLOG_flush()) return;
    BLOGADDHEADER(b,n1);
    i[0] = n2;
    i[1] = n3;
    i[2] = n4;
    BLOGADDINTS(b,v,3,i);
    }
}

/* This is a stub that may write out the current log buffer, or allocated
   a new one and setup pointers to it */
int xx_BLOG_flush()
{
/* allocate a new block */
return xx_BLOG_getbuf();
}

/* add string containing an event def to the logfile */
void xx_BLOG_def(event,str)
int  event;
char *str;
{
BLOG_HEADER *b;
BLOG_VFIELD *v;
int ln, ln4;

if (xx_BLOG_status >= 3) {
    fprintf(stderr, "BLOG: Error: event logging requested by PID %d before doing BLOG setup\n", MYPROCID );
    return;
    }

ln = strlen(str) + 1;
ln4 = (ln + sizeof(int) - 1) / sizeof(int);
if (xx_BLOG_status & 0x1) {
    if (xx_BLOG_i + 2 * BLOGHEADERSIZE + 2*BLOGVFIELDSIZE(1) + 
	BLOGVFIELDSIZE(ln4) > xx_BLOG_size)
	if (xx_BLOG_flush()) return;
    BLOGADDHEADER(b,-9);
    BLOGZEROTIME(b);
    BLOGADDINTS(b,v,1,&event);
    BLOGADDSTRING(b,v,str);
    BLOGADDHEADER(b,-10);
    BLOGZEROTIME(b);
    BLOGADDINTS(b,v,1,&event);
    }
}

/* add string containing a state def to the logfile.  The format of the
   def is (-13) 0 sevent eevent "color name". */
void xx_BLOG_def_state(sevent,eevent,color,name)
int  sevent, eevent;
char *color, *name;
{
int  lnc, lnn, ln4;
char buf[150];
BLOG_HEADER *b;
BLOG_VFIELD *v;
int         i[2];

if (xx_BLOG_status >= 3) {
    fprintf(stderr, "BLOG: Error: event logging requested by PID %d before doing BLOG setup\n", MYPROCID );
    return;
    }

strncpy( buf, color, 150 );
strncat( buf, " ", 150 );
strncat( buf, name, 150 );
if (xx_BLOG_status & 0x1) {
    if (xx_BLOG_i + BLOGHEADERSIZE + BLOGVFIELDSIZE(2) + 
	BLOGVFIELDSIZE((strlen(buf)+sizeof(int)-1)/sizeof(int))> xx_BLOG_size)
	if (xx_BLOG_flush()) return;
    
    BLOGADDHEADER(b,-13);
    i[0] = sevent;
    i[1] = eevent;
    BLOGADDINTS(b,v,2,i);
    BLOGADDSTRING(b,v,buf);
    }
}

/*
   This routine dumps a logfile in alog format
 */
void xx_BLOG_dump( fp )
FILE *fp;
{
int         xx_i, procid, *bp, n;
BLOG_BLOCK  *bl;
BLOG_HEADER *ap;
void        (*headershort)(), (*header)(), (*body)();

BLOGGetOutputRoutines( &header, &headershort, &body );

procid = MYPROCID;
/* printf( "[%d] entering dump\n", procid ); fflush(stdout); */
if (fp == 0) {
    /* Generate blog file name */
    char name[1024], fname[1024], dirpath[1024];
    sprintf( name, "blog.%d", procid );
    strcpy( dirpath, "./" );
    /* printf( "[%d] about to form filename %s\n", procid, name ); */
    /* printf( "[%d] trying to open %s\n", procid, name ); */
    fp = SYOpenWritableFile( dirpath, name, name, fname, 0 );
    if (!fp) {
	fprintf(stderr, "BLOG: **** trace logfile %s creation failure ****\n", 
		         fname );
	return;
	}
    /* printf( "[%d] done opening file %s(%s)\n", procid, name, fname ); */
    }
fflush(stdout);
(*headershort)( fp, procid );

/* printf( "[%d] about to write logfile out\n", procid ); */
/* Alog wants all negative events, then all positive ones */
/* printf( "[%d] staring system (negative) events\n", procid ); */
if (btail) btail->size = xx_BLOG_i;
bl          = bblock;
while (bl) {
    n    = bl->size;
    bp   = (int *)(bl + 1);
    xx_i = 0;
    while (xx_i < n) {
	ap = (BLOG_HEADER *)bp;
	if (ap->event < 0 && ap->event > -100) {
	    (*body)( fp, procid, bp );
	    }
	xx_i += ap->len;
	bp   += ap->len;
 	}
    bl = bl->next;
    }
/* printf( "[%d] starting user (positive) events\n", procid );
fflush(stdout); */

bl = bblock;
while (bl) {
    n      = bl->size;
    bp     = (int *)(bl + 1);
    xx_i   = 0;
    while (xx_i < n) {
	ap = (BLOG_HEADER *)bp;
	if (ap->event >= 0) {
	    (*body)( fp, procid, bp );
	    }
	xx_i += ap->len;
	bp   += ap->len;
	}
    bl = bl->next;
    }
fclose(fp);
}


int xx_BLOG_getbuf()
{
BLOG_BLOCK *bl;

bl        = (BLOG_BLOCK *)MALLOC( xx_BLOG_size * sizeof(int) + 
				  sizeof(BLOG_BLOCK) );
bl->next  = 0;
CHKPTRV(bl,1);
/* add to chain of blocks */
if (bblock) {
    btail->next = bl;
    btail->size = xx_BLOG_i;
    }
else 
    bblock      = bl;
btail = bl;

xx_BLOG   = (int *)(bl + 1);
xx_BLOG_i = 0;
return 0;
}

void xx_BLOG_setup(flag)
int flag;
{

/* Initialize the timers */
SYusc_init(); 
xx_BLOG_init_clock();

#ifndef OLD_VERSION
xx_BLOG_status |= 0x1;    /* Set ON */
#endif
xx_BLOG_status &= 0x1;    /* set initialized flag */

if (xx_BLOG_getbuf())
    fprintf(stderr, "BLOG: **** trace buffer creation failure ****\n");
}

void xx_BLOG_FixClocks()
{
/* Add info to correct the clock offsets (but without any events) */
if (NUMNODES > 1) {
    LOGPUSHATOMIC;
    /* Add the event at the beginning of the run */
    BLOGAddClockEvents();
    LOGPOPATOMIC;
    }
}

BLOG_BLOCK *xx_BLOG_get_blog_ptr()
{
/* Update the size of the tail */
if (btail) btail->size = xx_BLOG_i;

return bblock;
}

/* This is used to save the format type */
static int BlogFmatType = 0;
int BLOGIsPicl()
{
return BlogFmatType == 1;
}
/*@C
  BLOGOutputFormat - Gives command line control over the output format 
                     produced by the event log generator

  Input Parmeters:
. argc - pointer to argument count
. argv - argument vector

  Description:
  This routine looks for arguments of the form -blogfmat [alog | picl].

  This routine is called by PIinitlog, which is in turn called by PICall.
  Users normally need not use this routine.
@*/
void BLOGOutputFormat( argc, argv )
int  *argc;
char **argv;
{
extern void BLOG2AlogHeader(), BLOG2AlogHeaderFull(), BLOG2AlogOutput();
extern void BLOG2PICLHeader(), BLOG2PICLHeaderFull(), BLOG2PICLOutput();
int idx;
char *p;
while ((idx = SYArgFindName( *argc, argv, "-blogfmat" )) >= 0) {
    if (idx >= *argc) return;
    p = argv[idx+1];
    if (strcmp(p, "picl") == 0) {
	BLOGSetOutputRoutines( BLOG2PICLHeaderFull, BLOG2PICLHeader, 
			       BLOG2PICLOutput );
	BlogFmatType 
= 1;
	}
    else if (strcmp(p, "alog") == 0) {
	BLOGSetOutputRoutines( BLOG2AlogHeaderFull, BLOG2AlogHeader, 
			       BLOG2AlogOutput );
	}
    /* Eventually, could REGISTER these the same way that solvers etc
       are registered */
    else {
	SETERRC(1,"Unknown argument to blogfmat" );
	SETERRC(1,p);
	}
    argv[idx] = 0;
    argv[idx+1] = 0;
    SYArgSqueeze( argc, argv );
    }
}
