#ifndef lint
static char SCCSid[] = "@(#) ./blog/b2picl.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "blog/blog.h"
#include "comm/logging.h"

/* 
  This file will contain routines to output picl format trace files.
  There are several things to do here:

  Format the file:
  (variable number of fields):
  send: 4 (time-sec) (time-usec) (node) (to) (type) (length)
  recv: 6 (time-sec) (time-usec) (node) (from) (type) (length)
  recv blocking: 7 (time-sec) (time-usec) (node)
  recv waking:   8 (time-sec) (time-usec) (node) (from) (type) (length)
  endofop: 11 (time-sec) (time-usec) (node) (idle-sec) (idle-usec)
   
  Convert event types:
  paragraph and picl have fixed ideas of the events, so we need to translate
  them.
 */

void BLOG2PICLHeader( fp, procid )
FILE *fp;
int  procid;
{
}

void BLOG2PICLHeaderFull( fp, procid, nevents, nevent_types, nnodes, 
			  starttime, endtime )
FILE *fp;
int  procid, nevents, nevent_types, nnodes;
unsigned long starttime[2], endtime[2];
{
}

/* 
   This assumes that any a character string may be encoded in the log file.
   We will need to change this to allow the log file to contain additional
   integers, needed for the more elaborate communication tracing
 */
void BLOG2PICLOutput( fp, procid, ap )
FILE *fp;
int  procid, *ap;
{
BLOG_HEADER *b;
BLOG_VFIELD *v;
int         lnleft;
int         *ip,      /* pointer to integer data record in event */
            ilen;     /* Size of that event */

b      = (BLOG_HEADER *)ap;
/* -1 is the "mark" event */
lnleft = b->len;
ap += (sizeof(BLOG_HEADER) / sizeof(int));
lnleft -= (sizeof(BLOG_HEADER) / sizeof(int));
if (lnleft > 0) {
    while (lnleft) {
	/* There may be a string or integer data.  */
	v      = (BLOG_VFIELD *)ap;
	ap     += v->len;
	lnleft -= v->len;
	if (v->dtype == BLOG_INT) {
	    ip = v->other;
	    ilen = v->len;
	    }
	}
    
    switch (b->event) {
	case LOG_SENDS:
	    fprintf( fp, "4 %u %u %d %d %d %d\n",
		     b->time.s1[0], b->time.s1[1], procid, 
		     ip[2], ip[1], ip[0] );
	    break;
	case LOG_SENDE:
	    fprintf( fp, "11 %u %u %d %u %u\n",
		     b->time.s1[0], b->time.s1[1], procid, 
		     0, 0 );
	    break;
	case LOG_RECVS:
	    fprintf( fp, "7 %u %u %d\n",
		     b->time.s1[0], b->time.s1[1], procid );
	    break;
	case LOG_RECVE:
	    fprintf( fp, "8 %u %u %d %d %d %d\n",
		     b->time.s1[0], b->time.s1[1], procid, 
		     ip[2], ip[1], ip[0] );
	    break;
	case LOG_RECVWS:
	    /* 
	    fprintf( fp, "4 %u %u %d %d %d %d\n",
		     b->time.s1[0], b->time.s1[1], procid, 
		     ip[2], ip[1], ip[0] );
		      */
	    break;
	case LOG_RECVWE:
	    /* 
	    fprintf( fp, "4 %u %u %d %d %d %d\n",
		     b->time.s1[0], b->time.s1[1], procid, 
		     ip[2], ip[1], ip[0] );
		      */
	    break;
	/* User defined events and other events are ignored */
        default:
	    break;
	}
    }
/* else
    fprintf( fp, "0\n" ); */
}

