/*
       Contains the data structure for plotting several line
    graphs in a window with an axis. This is intended for line 
    graphs that change dynamically by adding more points onto 
    the end of the X axis.
*/

#ifndef _XLG
#define _XLG

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xtools/basex11.h"
#include "xtools/baseclr.h"
#include "xtools/base3d.h"
#include "xtools/lines/lines.h"
#include "xtools/axis/axis.h"

typedef struct {
  XBWindow   *win;
  int        winw, winh;
  XBAxisData *axis;
  Lines      **lines;
  double     xmin, xmax, ymin, ymax;
  int        nopts, dim;
} XBLineGraph;

XBLineGraph *XBLineGraphCreate();
void        XBLineGraphDestroy();
void        XBLineGraphReset();
void        XBLineGraphDraw();
void        XBLineGraphAddPoint();

XBLineGraph *ITLineGraphMonitorCreate();
void        ITLineGraphMonitor();
void        ITLineGraphMonitorDestroy();
void        ITLineGraphMonitorReset();
 
#endif
