
#include "tools.h"
#include "iter/itctx.h"
#include "xtools/basex11.h"             /*I "xtools/basex11.h"  I*/
#include "xtools/xlg/xlg.h"
#include <math.h>


XBLineGraph *ITLineGraphMonitorCreate(label,host,x,y,m,n)
char *label,*host;
int  x, y, m, n;
{
  XBWindow    *win;
  XBLineGraph *lg;
  win = XBWinCreate();
  XBQuickWindow(win,host,label,x,y,m,n); CHKERRN(1);
  return XBLineGraphCreate(win,1);
}

void ITLineGraphMonitor(itP,usrP,n,rnorm)
ITCntx *itP;
void   *usrP;
int    n;
double rnorm;
{
  XBLineGraph *lg = (XBLineGraph *) itP->monP;
  double      x, y;

  x = (double) n;
  if (rnorm > 0.0) y = log10(rnorm); else y = -15.0;
  XBLineGraphAddPoint(lg,&x,&y);
  if (n < 20 || (n % 5)) {
    XBLineGraphDraw(lg);
  }
} 

void ITLineGraphMonitorDestroy(lg)
XBLineGraph *lg;
{
  XBWinDestroy(lg->win);
  XBLineGraphDestroy(lg);
}
 
void ITLineGraphMonitorReset(lg)
XBLineGraph *lg;
{
  XBLineGraphReset(lg);
}
