#ifndef LINT
static char SCCSid[]    = "@(#) ./xtools/pointer/dodrag.c 07/23/93";
#endif

/*
    This file contains routines to handle a rubber-band box.
    For now, pressing DOWN the indicated button sets the
    start location; releasing that button completes the
    region definition
 */

/* #define DBUG  */
#ifdef DBUG
#include <stdio.h>
#endif

#include "tools.h"
#include "xtools/basex11.h"

/*
   For these routines to work, the input masks on the window must include
    ButtonPressMask | ButtonReleaseMask;
 */

/*------------------------------------------------------------------------------
u *      XBdo_drag( XBWin, drag_butn, px, py, state )
 *              Looks for the the dragging of the specified mouse button,
 *              and returns (in (px, py)) a location which represents the
 *              current mouse position (collapsed from several locations).
 *              The dragging operation is considered complete when the
 *              drag_butn is released.
 *      input:
 *              XBWin        window structure drag is in
 *              drag_butn       mouse button to be dragged:
 *                              one of Button1, Button2, Button3
 *              cancel          mouse button representing cancel operation:
 *                              one of Button1, Button2, Button3
 *              state           used to remember state of drag.  Should have
 *                              value 0 when starting drag; should be unchanged
 *                              during subsequent calls
 *      output:
 *              (px, py)        location of the key press event, device coords
 *      return:
 *              TRUE            if operation was completed
 *                              (drag_butn was released or user cancelled)
 *              FALSE           if still waiting for release of drag_butn
 *----------------------------------------------------------------------------*/
/* values for state */
#define INIT_STATE 0
#define DRAG_STATE  1
#define WAIT_B1_STATE 2

/* this is used to save the mask used while tracking the pointer */
static unsigned long imask;

XBstart_drag( XBwin )
XBWindow  *XBwin;
{
/* starting the drag operation */
/* note if drag_button != Button1, need to change mask */
imask   = ButtonReleaseMask | Button1MotionMask |
          PointerMotionHintMask | ButtonPressMask;
XChangeActivePointerGrab( XBwin->disp, imask,
                          None, CurrentTime );
}

int XBdo_drag( XBWin, drag_butn, px, py )
XBWindow    *XBWin;
int         drag_butn;
int         *px, *py;
{
XEvent  report;

/* process until dragged button is released */
while (1) {
    XMaskEvent( XBWin->disp, imask, &report );
    switch (report.type) {
        case ButtonRelease:
#ifdef DBUG
            fprintf( stderr, "Got button release of drag\n\r" );
            fflush( stderr );
#endif
            if (report.xbutton.button == drag_butn) {
                *px     = report.xbutton.x;
                *py     = report.xbutton.y;
                return 1;
                }
            /* else should not have happened, and ignore */
            break;
        case MotionNotify:
#ifdef DBUG
            fprintf( stderr, "In MotionNotify\n\r" );
            fflush( stderr );
#endif
            /* eat up the motion reports; report will hold the
               last valid position */
            while (XCheckMaskEvent( XBWin->disp, ButtonMotionMask,
                   &report )) ;
            {
            Window       root, child;
            int          root_x, root_y;
            unsigned int keys_button;
            if (!XQueryPointer( XBWin->disp, report.xmotion.window,
                &root, &child, &root_x, &root_y, px, py, &keys_button))
                break;
            }
            return 0;
        case ButtonPress:
#ifdef DBUG
            fprintf( stderr, "In ButtonPress\n\r" );
            fflush( stderr );
#endif
            if (report.xbutton.button == drag_butn) {
		/* This is the case that the button was NOT PRESSED when
		   we started */
		XBstart_drag( XBWin );
		break;
		}
	    /* else, not drag_butn, so wait for the release */
            XBWaitButton( XBWin, report.xbutton.button );
            /* ignore otherwise */
            break;
#ifdef DBUG
        default:
	    fprintf( stderr, "Unknown event in do_drag\n" );
	    fflush( stderr );
	    break;
#endif
        } /* end switch */
    } /* end while */
}


/*
    Save the window input mask
 */
static unsigned long savemask;

XBSaveWindowMask( XBWin )
XBWindow    *XBWin;
{
XWindowAttributes   wattr;
XGetWindowAttributes( XBWin->disp, XBWin->win, &wattr );
savemask    = wattr.your_event_mask;
}

XBRestoreWindowMask( XBWin )
XBWindow    *XBWin;
{
XSelectInput( XBWin->disp, XBWin->win, savemask );
}


/* change the cursor */

#include <X11/cursorfont.h>
static Cursor TmpCursor    = (Cursor) 0;

XBdrag_cursor( XBWin )
XBWindow    *XBWin;
{
TmpCursor   = XCreateFontCursor( XBWin->disp, XC_fleur );
XDefineCursor( XBWin->disp, XBWin->win, TmpCursor );
}

XBrestore_cursor( XBWin )
XBWindow *XBWin;
{
/* This restores the "parent" cursor. */
if (TmpCursor) {
    XUndefineCursor( XBWin->disp, XBWin->win );
    XFreeCursor( XBWin->disp, TmpCursor );
    TmpCursor  = (Cursor)0;
    }
}

/*
    Wait until key is released
 */
XBWaitButton( XBWin, key )
XBWindow        *XBWin;
unsigned int    key;
{
XEvent  report;
while (1) {
    while (XCheckTypedEvent( XBWin->disp, ButtonPress, &report ));
    XMaskEvent( XBWin->disp, ButtonReleaseMask, &report );
    if (report.xbutton.button == key) break;
    }
}

XBEnableButtons( XBWin )
XBWindow *XBWin;
{
XSelectInput( XBWin->disp, XBWin->win, ButtonPressMask | ButtonReleaseMask );
}

/* Wait for a mouse button to be pressed; return the button */
int XBWaitForMouseButton( XBWin )
XBWindow *XBWin;
{
XEvent  report;

while (XCheckTypedEvent( XBWin->disp, ButtonPress, &report ));
XMaskEvent( XBWin->disp, ButtonReleaseMask, &report );
return report.xbutton.button;
}
