#ifndef lint
static char SCCSid[] = "@(#) ./xtools/lines/lines.c 07/23/93";
#endif
/*
    This file creates a "lines" tool that contains a dynamic number of
    lines and their positions within the window.  These lines
    are NOT scaled; they are in user (double) coords.
 */

#include "tools.h"
#include "xtools/basex11.h"
#include "xtools/lines/lines.h"

#define MAX_PTS   128
struct _LineBlock {
    struct _LineBlock  *next;
    int             npts;
    PixVal          pixel;
    XPoint          pts[MAX_PTS];
    double          x[MAX_PTS], y[MAX_PTS];
    };
typedef struct _LineBlock LineBlock;


/*@
      XBLinesInit - Generate a "lines" structure
     
      Note: 
      a lines structure is used to display a (possibly increasing)
      number of lines.  Use the routine XBLinesAddLines to place lines into
      the structure
@*/
Lines *XBLinesInit( )
{
Lines *lines;

lines              = NEW(Lines);
lines->lines       = NEW(LineBlock);
lines->lines->next = 0;
lines->lines->npts = 0;
lines->last        = lines->lines;
lines->xmin  = lines->ymin = lines->ymax = lines->ymin = 0.0;

return lines;
}

/*@
    XBLinesAddLines - Add lines with a specified pixel value 
    
    Input Parameters:
.   lines - lines structure
.   x,y   - arrays of x and y coordinates
.   n     - number of values in x and in y
.   pixel - pixel value for drawing lines
@*/
void XBLinesAddLines( lines, x, y, n, pixel )
Lines  *lines;
double *x, *y;
int    n;
PixVal pixel;
{
LineBlock   *pb;
int         i, m, k;

pb          = lines->last;
/* Finish off the current block */
if (pb->npts < MAX_PTS && (pixel == pb->pixel || pb->npts == 0)) {
    pb->pixel = pixel;
    m = (n > (MAX_PTS - pb->npts)) ? (MAX_PTS - pb->npts) : n;
    k = pb->npts;
    for (i=0; i<m; i++) {
	pb->x[i+k] = x[i];
	pb->y[i+k] = y[i];
	}
    n        -= m;
    x        += m;
    y        += m;
    pb->npts += m;
    }

/* Add new blocks */
while (n > 0) {
    m        = pb->npts;
    pb->next = NEW(LineBlock);             CHKPTR(pb->next);
        /* Copy the last point in the previous block to the first point
	   in the new one */
    pb->next->x[0] = pb->x[m-1];
    pb->next->y[0] = pb->y[m-1];
    pb       = pb->next;
    pb->next = 0;
    pb->npts = 1;
    pb->pixel= pixel;

    k        = pb->npts;
    m        = (n > (MAX_PTS - k)) ? (MAX_PTS - k) : n;
    for (i=0; i<m; i++) {
	pb->x[i+k] = x[i];
	pb->y[i+k] = y[i];
	}
    n        -= m;
    x        += m;
    y        += m;
    pb->npts += m;
    }
lines->last = pb;
}

/*@
    XBLinesSetScale - Set the scale manually

    Input Parameters:
.   lines - lines structure
.   xmin,xmax - limits in x
.   ymin,ymax - limits in y
@*/
void XBLinesSetScale( lines, xmin, xmax, ymin, ymax )
Lines       *lines;
double      xmin, xmax, ymin, ymax;
{
lines->xmin = xmin;
lines->xmax = xmax;
lines->ymin = ymin;
lines->ymax = ymax;
}

/*@
    XBLinesAutoScale - Scale by the data in lines
    
    Input Parameter:
.   lines - lines structure

    Note:
    Compute the limits of the data from the data.
@*/
void XBLinesAutoScale( lines )
Lines *lines;
{
LineBlock   *pb;
double      xmin, ymin, xmax, ymax;
int         i, n;

pb          = lines->lines;
xmin        = pb->x[0];
ymin        = pb->y[0];
xmax        = xmin;
ymax        = ymin;
while (pb) {
    n = pb->npts;
    for (i=0; i<n; i++) {
	if (pb->x[i] > xmax) xmax = pb->x[i];
	else if (pb->x[i] < xmin) xmin = pb->x[i];
	if (pb->y[i] > ymax) ymax = pb->y[i];
	else if (pb->y[i] < ymin) ymin = pb->y[i];
	}
    pb  = pb->next;
    }
lines->xmin = xmin;
lines->xmax = xmax;
lines->ymin = ymin;
lines->ymax = ymax;
}

/* Compute the locations of the points, given that the ranges have
   been set */
/*@
  XBLinesRescale - Compute the location of the given lines in the window

  Note:
  This routine must be called before XBLinesDraw is used.
@*/
void XBLinesRescale( XBWin, lines )
XBWindow *XBWin;
Lines       *lines;
{
LineBlock   *pb;
double      xmin, ymin, xscale, yscale;
int         n, i;

pb          = lines->lines;
xmin        = lines->xmin;
ymin        = lines->ymin;
xscale      = XBWin->w / (lines->xmax - lines->xmin);
yscale      = XBWin->h / (lines->ymax - lines->ymin);
while (pb) {
    n = pb->npts;
    for (i=0; i<n; i++) {
	pb->pts[i].x = XBWin->x + (pb->x[i] - xmin) * xscale;
	pb->pts[i].y = XBWin->y + XBWin->h - (pb->y[i] - ymin) * yscale;
	}
    pb  = pb->next;
    }
}

/*@
    XBLinesDraw - Actually draw the lines
    
    Input Parameters:
.   XBWin - window to draw on
.   lines - lines structure
@*/
void XBLinesDraw( XBWin, lines )
XBWindow *XBWin;
Lines       *lines;
{
LineBlock   *pb;

pb          = lines->lines;
while (pb) {
    XSetForeground( XBWin->disp, XBWin->gc.set, pb->pixel );
    XDrawLines( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
		pb->pts, pb->npts, CoordModeOrigin );
    pb  = pb->next;
    }
}

/*@
    XBLinesFree - Destroy a lines structure and its storage

    Input Parameters:
.   lines - lines structure
@*/
void XBLinesFree( lines )
Lines *lines;
{
LineBlock   *pb, *pbn;

pb          = lines->lines;
while (pb) {
    pbn = pb->next;
    FREE( pb );
    pb  = pbn;
    }
FREE( lines );
}

/*@
    XBLinesDrawDisjoint - Actually draw the lines; assumes
                          each line is disjoint from the next.

    Input Parameters:
.   XBWin - window to draw on
.   lines - lines structure
@*/
void XBLinesDrawDisjoint( XBWin, lines )
XBWindow *XBWin;
Lines       *lines;
{
LineBlock   *pb;
int         n, i;

pb          = lines->lines;
while (pb) {
    XSetForeground( XBWin->disp, XBWin->gc.set, pb->pixel );
    n = pb->npts;
    for ( i=0; i<n; i+=2 ) {
      XDrawLines( XBWin->disp, XBDrawable(XBWin), XBWin->gc.set,
        &pb->pts[i], 2, CoordModeOrigin );
    }
    pb  = pb->next;
    }
}
