#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#include <math.h>

#define X_SIZE 11
#define Y_SIZE 13

main( argc, argv )
int argc;
char **argv;
{
XBWindow *XBWin;
double   mesh[X_SIZE*Y_SIZE], x[X_SIZE], y[Y_SIZE], r;
unsigned char *map;
double   imap[16];
int      i, j;
int      px = -1, py = -1, pw = 200, ph = 200;

XBWin = XBWinCreate();
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s Contour example\n", argv[0] );
    exit(0);
    }
XBGetArgs( &argc, argv, 1, &px, &py, &pw, &ph );
if (XBQuickWindow( XBWin, "", "Contour", px, py, pw, ph )) {
    fprintf( stderr, "Check your DISPLAY variable\n" );
    exit(0);
    }
map = (unsigned char *)MALLOC( XBWin->w * XBWin->h ); CHKPTR(map);
XBUniformHues( XBWin, 16 );

/* Setup the data */
for (i=0; i<X_SIZE; i++) x[i] = i*(1.0/(X_SIZE-1));
for (j=0; j<Y_SIZE; j++) y[j] = j*(1.0/(Y_SIZE-1));
for (i=0; i<X_SIZE; i++)
    for(j=0; j<Y_SIZE; j++) {
        r = sqrt( (x[i] - 0.5) * (x[i] - 0.5) + (y[j] - 0.5) * (y[j] - 0.5));
        mesh[i + j * X_SIZE] = (r == 0) ? 1.0 : sin(4.0*r) / (4.0 * r);
        }
for (i=0; i<16; i++) 
    imap[i] = (double)(i + 1) /  16.0;

XBContourDrawWithMap( XBWin, mesh, X_SIZE, Y_SIZE, x, y, imap, 16, map, 
                      XBWin->w, XBWin->h, 0, 0, 0 );
sleep(5);
}
