#ifndef lint
static char SCCSid[] = "@(#) ./vectors/vector.c 07/23/93";
#endif

#include "tools.h"
#include "vectors/vector.h"        /*I "vectors/vector.h" I*/

/*@
   VECreate - Creates an empty vector context.

  Notes:
  Normally a user will create a vector context, VECtnx, then fill
  it with either DVSetDefaultFunctions() for serial code or
  DVPSetDefaultFunctions() for parallel code. If the user 
  is providing her or his own vector functions then they should 
  provide a routine which sets them in the VECtnx using 
  DVSetDefaultFunctions() as a template.
 @*/
VECntx *VECreate()
{
VECntx *v;

v = NEW(VECntx);
v->obtain_vectors  = 0;
v->release_vectors = 0;
v->dot = 0;
v->norm = 0;
v->tdot = 0;
v->scal = 0;
v->copy = 0;
v->set = 0;
v->axpy = 0;
v->aypx = 0;  
v->swap = 0;  
v->Private = 0;

return v;
}
/*@
   VEDestroy - Destroys a vector context.

   Input Parameter:
.  v  - vector context to free
 @*/
void VEDestroy( v )
VECntx *v;
{
FREE(v);
}

/*@
   VECreateDefaultUsrCntx - Creates a default user context for 
   serial vectors.

   Input Parameters:
     n  -  vector length
 @*/
VEDefaultUsrCntx *VECreateDefaultUsrCntx(n)
int n;
{
VEDefaultUsrCntx *v;

v = NEW(VEDefaultUsrCntx);
v->n = n;

return v;
}

/*@
   VEDestroyDefaultUsrCntx - Destroys a default user context for 
   serial vectors.

   Input Parameter:
.  v - vector context to free
 @*/
void VEDestroyDefaultUsrCntx( v )
VEDefaultUsrCntx *v;
{

FREE(v);
}
