/*
*	Initial a data area to NaN
*
*/
#include <signal.h>
#include <stdio.h>

#if defined(sun4)
static long nanval[2] = { 0x40d00000, 0x0 };
#elif defined(fx2800)
static long nanval[2] = {0xffffffff,0x7fffffff }; /* Quiet NaN */
#elif defined(IRIX)
static long nanval[2] = {0x7ff7ffff,0xffffffff }; /* Quiet nan */
#elif defined(tc2000)
static long nanval[2] = {0xc8001883,0xc0000000}; /* Quiet nan */
#elif defined(intelnx)
static long nanval[2] = {0x0,0xfff80000}; /* Quiet nan */
#else
static long nanval[2] = {-1,-1}; /* Probably a bad floating point value */
#endif

typedef union { long l[2]; double d; } MakeDouble;
/*@
  SYsetuninit - Set a data area to NaN

  Input parameters:
. p   - pointer to data
. n   - length of data (in doubles)
@*/
void SYsetuninit( p, n )
double   *p;
register int n;
{
register double *pp, nval;
MakeDouble nd;

nd.l[0] = nanval[0];
nd.l[1] = nanval[1];
nval    = nd.d;
pp   = (double *)p;
while (n--)
    *pp++   = nval;
}

