#ifndef lint
static char SCCSid[] = "@(#) ./system/rdfloat.c 07/23/93";
#endif

#include "tools.h"
#include <stdio.h>
#include <ctype.h>
#include <math.h>

/*@
    SYRdFloat - Read a float/double from general input.

    Input Parameters:
.   getch - routine to act as getch.
.   ungetch - routine to act as ungetch
.   IOcontext - IO context for getch and ungetch.

    Output Parameter:
.   p  - pointer to hold double

    Returns:
    -1 on failure, 0 if no value found, and 1 on success.

    Notes:
    This routine implements a version of fscanf that handles
    %lg and %le formats.  This is needed for two reasons
    (1) C doesn't understand all Fortran exponent specifiers and
    (2) Convex version (sometimes) reads a %lg item as an integer

    The routines getch and ungetch are defined as the usual stream
    routines.  In this case, the IOcontext should be the FILE pointer.
    However, different routines can be used.  For example, a pair of 
    routines that worked with a in-memory buffer can be providing.  In
    this case, the "IOcontext" is a pointer to a structure that contains
    the in-memory buffer and the position of input within that buffer.

    Algorithm:
    [-+][0-9]*[.][0-9]*[eEdD][+-][0-9]*
    There must be a leading value before the exponent is encountered.
@*/
int SYRdFloat( p, getch, ungetch, IOcontext )
double *p;
int (*getch)(), (*ungetch)();
void *IOcontext;
{
int     ch, exponent, expsign, sign, itemread;
double  val, scale, onetenth;

itemread = 0;
while ((ch = (*getch)(IOcontext)) != EOF && isspace(ch)) ;
/* optional sign */
val = 0.0;
sign= 1;
if (ch == '+') {
    sign = 1;
    ch   = (*getch)( IOcontext );
    }
else if (ch == '-') {
    sign = -1;
    ch   = (*getch)( IOcontext );
    }

/* Left of decimal point */
while (ch != EOF && isdigit(ch)) {
    itemread = 1;
    val = val * 10.0 + (ch - '0');
    ch  = (*getch)( IOcontext );
    }
if (ch == '.') {
    ch          = (*getch)( IOcontext );
    onetenth    = 1.0 / 10.0;
    scale       = onetenth;
    while (ch != EOF && isdigit(ch)) {
        itemread = 1;
        val   += scale * (ch - '0');
        scale *= onetenth;
        ch    = (*getch)( IOcontext );
        }
    }
/* Must have SOME value by this point */
if (!itemread) {
    (*ungetch)( ch, IOcontext );
    return (ch == EOF) ? EOF : 0;
    }
if (ch == 'E' || ch == 'e' || ch == 'D' || ch == 'd') {
    exponent = 0;
    expsign  = 1;
    ch = (*getch)( IOcontext );
    if (ch == '+') {
        ch = (*getch)( IOcontext );
        }
    else if (ch == '-') {
        expsign = -1;
        ch      = (*getch)( IOcontext );
        }
    /* This should probably stop after 2 or 3 characters */
    while (ch != EOF && isdigit(ch)) {
        exponent = exponent * 10 + (ch - '0');
        ch       = (*getch)( IOcontext );
        }
    if (exponent != 0)
        val = val * pow( 10.0, (double)(expsign*exponent) );
    }
/* This algorithm has always read one too many characters.  Unread it */
(*ungetch)( ch, IOcontext );
*p = sign * val;
return (ch == EOF) ? EOF : itemread;
}
