*****************************************************************
*      GET THE K LARGEST NONZEROES IN AKEYS INDIRECTLY ADDRESSED 
*      BY INDVEC; UPON EXIT THE FIRST K ELEMENTS IN INDVEC WILL
*      CONTAIN THE INDICES OF THE K LARGEST ELEMENTS IN AKEYS
*****************************************************************
       SUBROUTINE SIBSORT(N,K,AKEYS,INDVEC)

*      THE LENGTH OF THE INTEGER VECTOR
       INTEGER N
*      THE NUMBER WANTED
       INTEGER K
*      THE REAL             VECTOR TO BE SORTED
       REAL             AKEYS(*)
*      THE INTEGER VECTOR ASSOCIATED WITH AKEYS
*      INDVEC(I) GIVES THE POSITION IN AKEYS OF THE ITH ELEMENT
       INTEGER INDVEC(*)
 
*      THE REST ARE INTERNAL VARIABLES
       INTEGER I,J
       INTEGER ITEMP, CURPTR, RIGHT, LEFT
       REAL             CURMIN, NEWVAL, CURVAL, LVAL

       EXTERNAL SIHSORT
 
*****************************************
*      START OF EXECUTABLE STATEMENTS
*****************************************

*      IF THE LIST IS SMALL OR THE NUMBER REQUIRED IS 0 THEN 
*      RETURN
       IF ((N.LE.1).OR.(K.LE.0)) RETURN

*      HEAP SORT THE FIRST K ELEMENTS OF THE VECTOR
       CALL SIHSORT(K,INDVEC,AKEYS)

*      LOOP THROUGH THE REST OF THE VECTOR AND FIND ANY ELEMENTS
*      THAT ARE LARGER THAN ANY OF THE FIRST K ELEMENTS
       CURMIN = ABS(AKEYS(INDVEC(K)))
       DO 10 I = K+1, N
          ITEMP = INDVEC(I)
          NEWVAL = ABS(AKEYS(ITEMP))
          IF (NEWVAL.GT.CURMIN) THEN
*           FIND POSITION FOR NEW VALUE
            LEFT = 1
            LVAL = ABS(AKEYS(INDVEC(1)))
            IF (NEWVAL.GT.LVAL) THEN
              CURPTR = 1
              GOTO 150
            ENDIF
            RIGHT = K
            CURPTR = (K+1)/2
100         CONTINUE            
            IF (RIGHT.GT.LEFT+1) THEN
              CURVAL = ABS(AKEYS(INDVEC(CURPTR)))
              IF (CURVAL.LT.NEWVAL) THEN
                RIGHT = CURPTR
              ELSE
                LEFT = CURPTR
                LVAL = CURVAL
              ENDIF
              CURPTR = (RIGHT+LEFT)/2
              GOTO 100
            ENDIF
            CURPTR = RIGHT

*           SHIFT SORTED VALUES AND INSERT NEW VALUE
150         CONTINUE
            INDVEC(I) = INDVEC(K)
            DO 200 J = K, CURPTR+1, -1
              INDVEC(J) = INDVEC(J-1)
200         CONTINUE
            INDVEC(CURPTR) = ITEMP
            CURMIN = ABS(AKEYS(INDVEC(K)))
          ENDIF
10     CONTINUE
 
       RETURN
       END
*****************************************************************
*     END OF SIBSORT
*****************************************************************

*****************************************************************
*      SORTS AN INTEGER VECTOR (USES BUBBLE SORT)
*      ASCENDING ORDER
*****************************************************************
       SUBROUTINE SDBSORT(N,KEYVEC)

*      THE LENGTH OF THE VECTOR
       INTEGER N
*      THE INTEGER VECTOR TO BE SORTED
       INTEGER KEYVEC(*)
 
*      THE REST ARE INTERNAL VARIABLES
       INTEGER I,J
       INTEGER TEMP
 
*****************************************
*      START OF EXECUTABLE STATEMENTS
*****************************************
       DO 10 I = 1, N-1
          DO 20 J = I+1, N
             IF (KEYVEC(I).GT.KEYVEC(J)) THEN
                TEMP = KEYVEC(I)
                KEYVEC(I) = KEYVEC(J)
                KEYVEC(J) = TEMP
             ENDIF
20        CONTINUE
10     CONTINUE
 
       RETURN
       END
*****************************************************************
*      END OF DBSORT
*****************************************************************

*****************************************************************
*      SORTS AN INTEGER VECTOR (USES HEAP SORT)
*      ASCENDING ORDER
*****************************************************************
       SUBROUTINE SDHSORT(LEN,KEYS)
*      THE LENGTH OF THE ARRAY
       INTEGER LEN
*      THE ARRAY TO BE SORTED
       INTEGER KEYS(*)

*      THE REST ARE INTERNAL VARIABLES
       INTEGER K, M, LHEAP, RHEAP, MID
       INTEGER X

*****************************************
*      START OF EXECUTABLE STATEMENTS
*****************************************
       IF (LEN.LE.1) RETURN

*      BUILD THE HEAP
       MID = LEN/2
       DO 100 K = MID, 1, -1
          X = KEYS(K)
          LHEAP = K
          RHEAP = LEN
          M = LHEAP*2
200       CONTINUE
             IF (M.GT.RHEAP) THEN
                KEYS(LHEAP) = X
                GOTO 300
             ENDIF
             IF (M.LT.RHEAP) THEN
                IF (KEYS(M) .LT. KEYS(M+1)) M = M+1
             ENDIF
             IF (X.GE.KEYS(M)) THEN
                M = RHEAP + 1
             ELSE
                KEYS(LHEAP) = KEYS(M)
                LHEAP = M
                M = 2*LHEAP
             ENDIF
             GOTO 200
300       CONTINUE
100    CONTINUE

*      SORT THE HEAP
       DO 400 K = LEN, 2, -1
          X = KEYS(K)
          KEYS(K) = KEYS(1)
          LHEAP = 1
          RHEAP = K-1
          M = 2
500       CONTINUE
             IF (M.GT.RHEAP) THEN
                KEYS(LHEAP) = X
                GOTO 600
             ENDIF
             IF (M.LT.RHEAP) THEN
                IF (KEYS(M) .LT. KEYS(M+1)) M = M+1
             ENDIF
             IF (X.GE.KEYS(M)) THEN
                M = RHEAP + 1
             ELSE
                KEYS(LHEAP) = KEYS(M)
                LHEAP = M
                M = 2*LHEAP
             ENDIF
             GOTO 500
600       CONTINUE
400    CONTINUE

       RETURN
       END
*****************************************************************
*      END OF SDHSORT
*****************************************************************

*****************************************************************
*      SORTS A REAL             VECTOR INDIRECTLY ADDRESSED BY
*      AN INTEGER VECTOR(USES HEAP SORT)
*      THE INDVEC IS REARRANGED SUCH THAT INDVEC(1) ADDRESSING
*      THE LARGEST ELEMENT IN AKEYS, INDVEC(2) ADDRESSES THE
*      NEXT LARGEST ....
*****************************************************************
       SUBROUTINE SIHSORT(LEN,INDVEC,AKEYS)
*      THE LENGTH OF THE INTEGER ARRAY
       INTEGER LEN
*      THE INTEGER ARRAY THAT INDIRECTLY ADDRESSES THE D.P. ARRAY
       INTEGER INDVEC(*)
*      THE ARRAY TO BE SORTED
       REAL             AKEYS(*)

*      THE REST ARE INTERNAL VARIABLES
       INTEGER K, M, LHEAP, RHEAP, MID
       INTEGER X

*****************************************
*      START OF EXECUTABLE STATEMENTS
*****************************************
       IF (LEN.LE.1) RETURN

*      BUILD THE HEAP
       MID = LEN/2
       DO 100 K = MID, 1, -1
          X = INDVEC(K)
          LHEAP = K
          RHEAP = LEN
          M = LHEAP*2
200       CONTINUE
             IF (M.GT.RHEAP) THEN
                INDVEC(LHEAP) = X
                GOTO 300
             ENDIF
             IF (M.LT.RHEAP) THEN
                IF (ABS(AKEYS(INDVEC(M))).GT.ABS(AKEYS(INDVEC(M+1))))
     C              M = M + 1
             ENDIF
             IF (ABS(AKEYS(X)).LE.ABS(AKEYS(INDVEC(M)))) THEN
                M = RHEAP + 1
             ELSE
                INDVEC(LHEAP) = INDVEC(M)
                LHEAP = M
                M = 2*LHEAP
             ENDIF
             GOTO 200
300       CONTINUE
100    CONTINUE

*      SORT THE HEAP
       DO 400 K = LEN, 2, -1
          X = INDVEC(K)
          INDVEC(K) = INDVEC(1)
          LHEAP = 1
          RHEAP = K-1
          M = 2
500       CONTINUE
             IF (M.GT.RHEAP) THEN
                INDVEC(LHEAP) = X
                GOTO 600
             ENDIF
             IF (M.LT.RHEAP) THEN
                IF (ABS(AKEYS(INDVEC(M))).GT.ABS(AKEYS(INDVEC(M+1))))
     C              M = M + 1
             ENDIF
             IF (ABS(AKEYS(X)).LE.ABS(AKEYS(INDVEC(M)))) THEN
                M = RHEAP + 1
             ELSE
                INDVEC(LHEAP) = INDVEC(M)
                LHEAP = M
                M = 2*LHEAP
             ENDIF
             GOTO 500
600       CONTINUE
400    CONTINUE

       RETURN
       END
*****************************************************************
*      END OF SIHSORT
*****************************************************************

