#ifndef lint
static char SCCSid[] = "@(#) ./sparse/util/spsplit.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

/*+
   SpiDiagPtrs - Given a sparse matrix, creates a integer array 
   containing the pointers to the diagonal eleemnts of the matrix 
 
   Input Parameters:
.   mat - matrix

   Returns:
   Pointers to diagonal elements

 +*/
int *SpiDiagPtrs(mat)
SpMat *mat;
{
  int        *nzl;
  int        i,n = mat->rows,nz, *xi, j ;
  SpRowMat   *R;
  SpVec      **rs, *row;

  nzl    = (int *) MALLOC(n*sizeof(int)); CHKPTRV(nzl,0);

  R      = GETROWMAT(mat);
  rs     = R->rs;
  for ( i=0; i<n; i++ ) {
    row  = *rs++;
    xi   = row->i;
    nz   = row->nz;
    for ( j=0; j<nz; j++ ) {
      if ( *xi++ >= i ) {
        nzl[i] = j;
        break;
      }
    }
  }
  return nzl;
}
