c
c       Fortran code to do incomplete factorization
c   Use the C driver in ic.c
c
*****************************************************************
*     PERFORM STANDARD INCOMPLETE CHOLESKI: COLUMN ORIENTED
*****************************************************************
      INTEGER FUNCTION ISTDIC(N,DIAG,A,IA,JA,TA,IFIRST,LIST)

*     IF THE FACTORIZATION WAS P.D. THEN 0 IS RETURNED
*     OTHERWISE A NEGATIVE VALUE IS RETURNED THAT INDICATES
*     THE COLUMN NUMBER WHERE A NEGATIVE DIAGONAL WAS ENCOUNTERED

*     THE ORDER OF THE MATRIX
*     INPUT ONLY
      INTEGER N
*     THE DIAGONALS OF A
*     INPUT/OUTPUT
      DOUBLE PRECISION DIAG(*)
*     THE OFF-DIAGONALS OF A
*     INPUT/OUTPUT
      DOUBLE PRECISION A(*)
*     POINTERS TO THE COLUMNS OF A
*     IA(K) IS THE INDEX IN A() AND JA() WHERE COLUMN K STARTS
*     ONLY THE STRICTLY LOWER TRIANGLE OF A IS STORED
*     IA IS LENGTH N+1 (POSITION N+1 INDICATES WHERE COLUMN N+1
*     WOULD START IF IT EXISTED)
*     INPUT
      INTEGER IA(*)
*     THE ROW NUMBERS OF THE OFF-DIAGONALS OF A
*     INPUT
      INTEGER JA(*)
*     A TEMPORARY WORK VECTOR OF LENGTH N TO KEEP THE CURRENT COLUMN
*     CONTENTS DESTROYED
      DOUBLE PRECISION TA(*)
*     IFIRST(J) POINTS TO THE NEXT VALUE IN COLUMN J TO USE (LENGTH N)
*     IFIRST ALSO HAS A DUAL USE.  AT STEP K, ONLY THE FIRST K-1 
*     ELEMENTS ARE USED FOR THE ABOVE PURPOSE.  FOR THE LAST N-K 
*     ELEMENTS, IFIRST(J) INDICATES IF IF A NONZERO VALUE EXISTS IN 
*     POSITION J OF COLUMN K.
*     CONTENTS DESTROYED
      INTEGER IFIRST(*)
*     LIST(J) POINTS TO A LINKED LIST OF COLUMNS THAT WILL UPDATE
*     COLUMN J (LENGTH N)
*     CONTENTS DESTROYED
      INTEGER LIST(*)

*     VARIABLES USED
      INTEGER ISK, IEK, ISJ, IEJ
      INTEGER I, J, K
      INTEGER ROW
      DOUBLE PRECISION LVAL, T
      INTEGER IPTR
 
*****************************************
*      START OF EXECUTABLE STATEMENTS
*****************************************

      DO 20 J = 1, N
        IFIRST(J) = 0
        LIST(J) = 0
20    CONTINUE

*     LOOP OVER ALL COLUMNS
      DO 10 K = 1,N
*        LOAD COLUMN K INTO TA
         ISK = IA(K)
         IEK = IA(K+1)-1
         DO 30 J = ISK, IEK
           ROW = JA(J)
           TA(ROW) = A(J)
           IFIRST(ROW) = 1
30       CONTINUE

*        MAKE SURE THE DIAGONAL OF K IS OKAY AND THEN TAKE THE SQRT
         IF (DIAG(K).LE.0.0D0) THEN
           DIAG(K) = -1.0D0
           GOTO 50
         ENDIF
         DIAG(K) = SQRT(DIAG(K))

*        UPDATE COLUMN K USING THE PREVIOUS COLUMNS
         J = LIST(K)
100      CONTINUE
         IF (J.EQ.0) GOTO 110
           ISJ = IFIRST(J)
           IEJ = IA(J+1)-1
           LVAL = A(ISJ)
           ISJ = ISJ + 1
           IF (ISJ.LT.IEJ) THEN
             IFIRST(J) = ISJ
             IPTR = J
             J = LIST(J)
             LIST(IPTR) = LIST(JA(ISJ))
             LIST(JA(ISJ)) = IPTR
           ELSE
             J = LIST(J)
           ENDIF
           DO 45 I = ISJ, IEJ
             ROW = JA(I)
             IF (IFIRST(ROW).NE.0) THEN
               TA(ROW) = TA(ROW) - LVAL*A(I)
             ENDIF
45         CONTINUE
         GOTO 100
110      CONTINUE

*        IFIRST AND LIST KEEP TRACK OF WHERE IN COLUMN K WE ARE
         IF (ISK.LT.IEK) THEN
           IPTR = JA(ISK)
           LIST(K) = LIST(IPTR)
           LIST(IPTR) = K
           IFIRST(K) = ISK
         ENDIF

*        UPDATE REMAINING DIAGONALS USING COLUMN K
         LVAL = DIAG(K)
         DO 42 J = ISK, IEK
           ROW = JA(J)
           T = TA(ROW)
           IFIRST(ROW) = 0
           T = T/LVAL
           DIAG(ROW) = DIAG(ROW) - T*T
           A(J) = T
42       CONTINUE

10    CONTINUE

*     RETURN A NON-NEGATIVE VALUE
      ISTDIC = 0
      RETURN

*     IF AN ERROR OCCURED, RETURN A NEGATIVE VALUE
50    CONTINUE
      ISTDIC = -K
      RETURN
      END
*****************************************************************
*     END OF ISTDIC
*****************************************************************

