#ifndef lint
static char SCCSid[] = "@(#) ./sparse/solve/cinv.c 07/23/93";
#endif

/*
    Routines to compute the inverse of a matrix.
    These are designed to allow the computation of selected rows of the
    inverse; this is advantageous for parallel computation where only
    a few rows of the inverse are needed.

    NOTE: It is usually a bad idea to compute the inverse; it is both
    more expensive and less accurate than other techniques.  However,
    there are some times where it is needed or efficient.  The use that
    created these routines was for a preconditioner that needs a
    low-resolution global solve; using the inverse in this case is both
    sufficiently accurate, and, when enough processors are used, faster.

    Finally, this is arranged so that it can use level 2 BLAS to apply the
    computed inverse.  This means that Fortran storage order must be used;
    thus the ROWS are NOT stored in contiguous elements.  
 */    

#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "sparse/spmat.h"
#include "inline/blas2.h"

/*@
    SpRowsOfInverse - Compute selected rows of the inverse matrix

    Input Parameters:
.   A          - Matrix to find inverse of
.   nrows      - number of rows to find inverse of
.   IndexOfRows- Integer array containing row numbers of rows to find
                 inverse of.  If null, find inverse of all rows (nrows
                 must be the number of rows in A then)
.   inv        - Holds the inverse.  Must be nrows * A->ncols * sizeof(double)
                 in size
.   order      - Ordering routine to use in finding the inverse elements.
                 If null, use no ordering.
@*/                 
void SpRowsOfInverse( A, nrows, IndexOfRows, inv, order )
SpMat  *A;
int    nrows, *IndexOfRows;
double *inv;
void   (*order)();
{
SpMatSplit *factor;
int        i, j, err, nrowsa = A->rows, ncols = A->cols;

factor = SpCreateSplit( A, 0 );
/* No ordering yet.  Note that the SpSolveTransM does not know about
   orderings */
SpComputeFill( A, factor );         CHKERR(0);
SpComputeFactor( A, factor );       CHKERR(0);
/* Fill inv with the inverse of the given rows.  We do this by finding
   the columns of the inverse of the transpose of A. */
/* We compute inverses by computing the COLUMNS of the inverse.
   For the transpose case, this gives us the ROWS of the inverse */

/* Set inv to zero */
for (i=0; i<nrows*ncols; i++) inv[j] = 0.0;
/* Set a few key 1's */
if (IndexOfRows) 
    for (i=0; i<nrows; i++)  
	inv[IndexOfRows[i]*nrows+i] = 1.0;
else 
    for (i=0; i<nrows; i++)  
	inv[i*nrows+i] = 1.0;

SpSolveTransM( factor, nrows, inv, inv );

/* Recover space */
SpDestroySplit( factor );
}

/* @
    SpMultRowsOfInverse - Compute the product of some inverse rows and 
                          a vector.

    Input Parameters:
.   nrows      - number of rows of inverse
.   nv         - length of vectors (= number of columns in inverse)
.   inv        - Holds the inverse.  Must be nrows * A->ncols * sizeof(double)
                 in size
.   vin,vout  - In and out vectors.
@ */                 
void SpMultRowsOfInverse( nrows, nv, inv, vin, vout )
int    nrows, nv;
double *inv;
double *vin, vout;
{
/* This isn't quite right either; this is a non-square matrix-vector
   product */	
/* DMVMULT( inv, nrows, nv, vin, vout ); */
}	
