#ifndef lint
static char SCCSid[] = "@(#) ./sparse/row/findruns.c 07/23/93";
#endif

/*
   This file contains routines to find runs of indices that may
   be compressed into a skyline-like format, consisting of a number
   of ranges of consequetively numbered entries
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"

typedef struct {
    int   sc, nc;
    } RunInfo;
typedef struct {
    int     nruns;
    RunInfo *runs;
    } RunData;

#define MAX_RUNS 100
/*@
     SpFindRuns - Optimize the sparse format for semi-dense rows

     Input parameter:
.    mat - matrix
 @*/
void SpFindRuns( mat )
SpMat *mat;
{
int      n;
SpRowMat *R;
SpVec    *x;
int      nzx;
register int a, *ix, i, j, off;
int      runcount;
RunInfo  Runs[MAX_RUNS];

R   = GETROWMAT(mat);
n   = mat->rows;

for (i=0; i<n; i++) {
    x   = R->rs[i];
    nzx = x->nz;
    ix  = x->i;
    
    a   = ix[0];
    j   = 1;
    off = 1;
    runcount = 0;
    while (j<nzx) {
	if (ix[j] != a + off) {
	    /* End of a run */
	    if (runcount >= MAX_RUNS) { runcount++; break; }
	    Runs[runcount].sc = a;
	    Runs[runcount].nc = off;
	    runcount++;
	    a   = ix[j];
	    off = 1;
	    }
	else 
	    off++;
	j++;
	}
    /* Put the last element in a run */
    if (runcount < MAX_RUNS) {
	Runs[runcount].sc = a;
	Runs[runcount].nc = off;
	runcount++;
	}
    else 
	runcount++;
    if (runcount < MAX_RUNS) {
	/* Add this to the matrix */
	printf( "[%d] has %d runs:\n", i, runcount );
	for (j=0; j<runcount; j++) 
	    printf( "    [%d] for %d entries\n", Runs[j].sc, Runs[j].nc );
	}
    /* We'd really like to separate the data into:
       (a) individual (or small size) elements
       (b) runs of moderate size
       */
    }
}

