#ifndef lint
static char SCCSid[] = "@(#) ./sparse/psubmat.c 07/23/93";
#endif

#include <stdio.h>             /*I <stdio.h> I*/
#include "tools.h"
#include "sparse/spmat.h"

/*@
   SpPrintSubmat - Prints a submatrix of a sparse matrix to a given FILE.

   Input parameters:
.  fp    - FILE pointer. Use stdout for standard output.
.  B     - matrix to print
.  nr    - number of rows
.  rrange - list of rows.  If null, all are used.
.  nc    - number of columns
.  crange - list of columns.  If null, all are used.
.  fmat  - format to use for a member of a row.  If null, use
	   "[%d] = %e\n" (column, value)
.  rfmat - format to use to indicate each row.  If null, use
    	   "<row %d>".  If rfmat[0] == 0, don't print row out

   Notes:
   This code assumes that the rows and columns are sorted.    	   
 @*/
void SpPrintSubmat( fp, B, nr, rrange, nc, crange, fmat, rfmat )
FILE  *fp;
SpMat *B;
int   nr, *rrange, nc, *crange;
char  *fmat, *rfmat;
{
int    i, j, *c, cv, curr, curc;
double *p, pv;

if (fp == 0) fp   = stdout;
if (!fmat)  fmat  = "[%d] = %e\n";
if (!rfmat) rfmat = "<row %d>\n";
SPLITTOMAT(B);
curr = 0;
for (i=0; i<B->rows; i++) {
    if (rrange && curr < nr) {
	if (rrange[curr] > i) continue;
	if (rrange[curr] == i) curr++;
        }
    if (!*rfmat) 	
        fprintf( fp, rfmat, i );
    SpScatterFromRow( B, i, &j, &c, &p );
    curc = 0;
    while (j--) {
    	cv = *c++;
    	pv = *p++;
    	if (crange && curc < nc) {
    	    if (crange[curc] > cv) continue;
    	    if (crange[curc] == cv) curc++;
    	    }
	fprintf( fp, fmat, cv, pv );
	}
    }
}
 
