#ifndef lint
static char SCCSid[] = "@(#) ./sparse/pack.c 07/23/93";
#endif

#include "tools.h"
#include "spmat.h"
#include "sppriv.h"

/*
   Buffer format is (currently; it WILL change):

   nrows ncols type nz a ia ja
   (Note that the location of a allows the values to be aligned on
   a double-word boundary)
 */
 
/*@
  SpPack - Pack a sparse matrix into a buffer. The buffer must
           already exist and MUST be double-word aligned. To determine
           the size of the buffer needed call SpPackSize().

  Input Parameters:
. A - matrix to pack
. bsize - size of buffer

  Output Parameters:
. buf - contains the matrix in packed format
  
  Returns:
  the size of the buffer used (in bytes).
@*/
int SpPack( A, buf, bsize )
SpMat *A;
int   *buf, bsize;
{
int nz, nrow;
int *ia, *ja;

buf[0] = nrow = A->rows;
buf[1] = A->cols;
buf[2] = A->type;
buf[3] = nz = SpNz( A );
/* ia(nrow+1), ja(nz), a(nz) */
if (bsize < 3*nz + nrow + 4) {
    /* Error; buffer too short */
    }
ia = buf + 4 + nz*2;
ja = ia + nrow + 1;
SpToAIJ( A, ia, ja, (double *)(buf+4), bsize-4 );
return (4 + nz*3 + nrow + 1) * sizeof(int);
}

/*@
  SpPackSize - Return the size of buffer that SpPack() will need (in bytes).

  Input Parameters:
. A - matrix to give the buffer size for
@*/
int SpPackSize( A )
SpMat *A;
{
int nz, nrow;

nrow = A->rows;
nz   = SpNz( A );
return (4 + nz*3 + nrow + 1) * sizeof(int);
}

/*@ 
   SpUnPack - Unpack a sparse matrix using the format from SpPack(). 

  Input Parameters:
. buf - contains the matrix in packed format

  Returns:
  The unpacked matrix

@*/
SpMat *SpUnPack( buf )
int *buf;
{
SpMat *A;
int   nz, nrow, *ia, *ja;

nrow = buf[0];
nz   = buf[3];
ia   = buf + 4 + nz*2;
ja   = ia + nrow + 1;
A    = SpFromAIJ( ia, ja, (double *)(buf + 4), nrow ); 
return A;
}
