#ifndef lint
static char SCCSid[] = "@(#) ./sparse/order/sp1wd.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"

#if defined(FORTRANCAPS)
#define gen1wd_ GEN1WD
#elif !defined (FORTRANUNDERSCORE)
#define gen1wd_ gen1wd
#endif

/*@
    SpOrder1WD - Find the 1-way dissection ordering of a given matrix.

    Input Paramter:
.    Matrix - matrix to find ordering for

    Output Parameters:
.    perm   - permutation vector (0-origin)
.    iperm  - inverse permutation vector.  If NULL, ignored.
@*/    
void SpOrder1WD( Matrix, perm, iperm )
SpMat *Matrix;
int   *perm, *iperm;
{
int i, nrow, *ia, *ja, *mask, *xls, nblks, *xblk, *ls;

nrow= Matrix->rows;
SpToSymmetricIJ( Matrix, &ia, &ja ); CHKERR(0);

mask = (int *)MALLOC( nrow * sizeof(int) );     CHKPTR(mask);
xls  = (int *)MALLOC( (nrow+1) * sizeof(int) ); CHKPTR(xls);
ls   = (int *)MALLOC( nrow * sizeof(int) );     CHKPTR(ls);
xblk = (int *)MALLOC( nrow * sizeof(int) );     CHKPTR(xblk);
gen1wd_( &nrow, ia, ja, mask, &nblks, xblk, perm, xls, ls );
FREE( mask ); FREE( xls ); FREE( ls ); FREE( xblk );
FREE( ia );  FREE( ja );

for (i=0; i<nrow; i++) perm[i]--;
if (iperm) SpInverse( nrow, perm, iperm );
}

