C----- SUBROUTINE FNROOT
C***************************************************************           1.
C***************************************************************           2.
C*******     FNROOT ..... FIND PSEUDO-PERIPHERAL NODE    *******           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C    PURPOSE - FNROOT IMPLEMENTS A MODIFIED VERSION OF THE                 7.
C       SCHEME BY GIBBS, POOLE, AND STOCKMEYER TO FIND PSEUDO-             8.
C       PERIPHERAL NODES.  IT DETERMINES SUCH A NODE FOR THE               9.
C       SECTION SUBGRAPH SPECIFIED BY MASK AND ROOT.                      10.
C                                                                         11.
C    INPUT PARAMETERS -                                                   12.
C       (XADJ, ADJNCY) - ADJACENCY STRUCTURE PAIR FOR THE GRAPH.          13.
C       MASK - SPECIFIES A SECTION SUBGRAPH. NODES FOR WHICH              14.
C              MASK IS ZERO ARE IGNORED BY FNROOT.                        15.
C                                                                         16.
C    UPDATED PARAMETER -                                                  17.
C       ROOT - ON INPUT, IT (ALONG WITH MASK) DEFINES THE                 18.
C              COMPONENT FOR WHICH A PSEUDO-PERIPHERAL NODE IS            19.
C              TO BE FOUND. ON OUTPUT, IT IS THE NODE OBTAINED.           20.
C                                                                         21.
C    OUTPUT PARAMETERS -                                                  22.
C       NLVL - IS THE NUMBER OF LEVELS IN THE LEVEL STRUCTURE             23.
C              ROOTED AT THE NODE ROOT.                                   24.
C       (XLS,LS) - THE LEVEL STRUCTURE ARRAY PAIR CONTAINING              25.
C                  THE LEVEL STRUCTURE FOUND.                             26.
C                                                                         27.
C    PROGRAM SUBROUTINES -                                                28.
C       ROOTLS.                                                           29.
C                                                                         30.
C***************************************************************          31.
C                                                                         32.
      SUBROUTINE  FNROOT ( ROOT, XADJ, ADJNCY, MASK, NLVL, XLS, LS )      33.
C                                                                         34.
C***************************************************************          35.
C                                                                         36.
         INTEGER ADJNCY(1), LS(1), MASK(1), XLS(1)                        37.
         INTEGER XADJ(1), CCSIZE, J, JSTRT, K, KSTOP, KSTRT,              38.
     1           MINDEG, NABOR, NDEG, NLVL, NODE, NUNLVL,                 39.
     1           ROOT                                                     40.
C                                                                         41.
C***************************************************************          42.
C                                                                         43.
C        ---------------------------------------------                    44.
C        DETERMINE THE LEVEL STRUCTURE ROOTED AT ROOT.                    45.
C        ---------------------------------------------                    46.
         CALL  ROOTLS ( ROOT, XADJ, ADJNCY, MASK, NLVL, XLS, LS )         47.
         CCSIZE = XLS(NLVL+1) - 1                                         48.
         IF ( NLVL .EQ. 1 .OR. NLVL .EQ. CCSIZE ) RETURN                  49.
C        ----------------------------------------------------             50.
C        PICK A NODE WITH MINIMUM DEGREE FROM THE LAST LEVEL.             51.
C        ----------------------------------------------------             52.
  100    JSTRT = XLS(NLVL)                                                53.
         MINDEG = CCSIZE                                                  54.
         ROOT = LS(JSTRT)                                                 55.
         IF ( CCSIZE .EQ. JSTRT )  GO TO 400                              56.
            DO 300 J = JSTRT, CCSIZE                                      57.
               NODE = LS(J)                                               58.
               NDEG = 0                                                   59.
               KSTRT = XADJ(NODE)                                         60.
               KSTOP = XADJ(NODE+1) - 1                                   61.
               DO 200 K = KSTRT, KSTOP                                    62.
                  NABOR = ADJNCY(K)                                       63.
                  IF ( MASK(NABOR) .GT. 0 )  NDEG = NDEG + 1              64.
  200          CONTINUE                                                   65.
               IF ( NDEG .GE. MINDEG ) GO TO 300                          66.
                  ROOT = NODE                                             67.
                  MINDEG = NDEG                                           68.
  300       CONTINUE                                                      69.
C        ----------------------------------------                         70.
C        AND GENERATE ITS ROOTED LEVEL STRUCTURE.                         71.
C        ----------------------------------------                         72.
  400    CALL  ROOTLS ( ROOT, XADJ, ADJNCY, MASK, NUNLVL, XLS, LS )       73.
         IF (NUNLVL .LE. NLVL)  RETURN                                    74.
            NLVL = NUNLVL                                                 75.
            IF ( NLVL .LT. CCSIZE )  GO TO 100                            76.
            RETURN                                                        77.
      END                                                                 78.
