C----- SUBROUTINE FN1WD
C***************************************************************           1.
C***************************************************************           2.
C*******     FN1WD ..... FIND ONE-WAY DISSECTORS        ********           3.
C***************************************************************           4.
C***************************************************************           5.
C                                                                          6.
C     PURPOSE - THIS SUBROUTINE FINDS ONE-WAY DISSECTORS OF                7.
C        A CONNECTED COMPONENT SPECIFIED BY MASK AND ROOT.                 8.
C                                                                          9.
C     INPUT PARAMETERS -                                                  10.
C        ROOT - A NODE THAT DEFINES (ALONG WITH MASK) THE                 11.
C               COMPONENT TO BE PROCESSED.                                12.
C        (XADJ, ADJNCY) - THE ADJACENCY STRUCTURE.                        13.
C                                                                         14.
C     OUTPUT PARAMETERS -                                                 15.
C        NSEP - NUMBER OF NODES IN THE ONE-WAY DISSECTORS.                16.
C        SEP - VECTOR CONTAINING THE DISSECTOR NODES.                     17.
C                                                                         18.
C     UPDATED PARAMETER -                                                 19.
C        MASK - NODES IN THE DISSECTOR HAVE THEIR MASK VALUES             20.
C               SET TO ZERO.                                              21.
C                                                                         22.
C     WORKING PARAMETERS-                                                 23.
C        (XLS, LS) - LEVEL STRUCTURE USED BY THE ROUTINE FNROOT.          24.
C                                                                         25.
C     PROGRAM SUBROUTINE -                                                26.
C        FNROOT.                                                          27.
C                                                                         28.
C***************************************************************          29.
C                                                                         30.
      SUBROUTINE  FN1WD ( ROOT, XADJ, ADJNCY, MASK,                       31.
     1                    NSEP, SEP, NLVL, XLS, LS )                      32.
C                                                                         33.
C***************************************************************          34.
C                       
         INTEGER ADJNCY(1), LS(1), MASK(1), SEP(1), XLS(1)                36.
         INTEGER XADJ(1), I, J, K, KSTOP, KSTRT, LP1BEG, LP1END,          37.
     1           LVL, LVLBEG, LVLEND, NBR, NLVL, NODE,                    38.
     1           NSEP, ROOT                                               39.
         REAL DELTP1, FNLVL, WIDTH                                        40.
C                                                                         41.
C***************************************************************          42.
C                                                                         43.
         CALL  FNROOT ( ROOT, XADJ, ADJNCY, MASK,                         44.
     1                  NLVL, XLS, LS )                                   45.
         FNLVL = FLOAT(NLVL)                                              46.
         NSEP  = XLS(NLVL + 1) - 1                                        47.
         WIDTH = FLOAT(NSEP) / FNLVL                                      48.
         DELTP1 = 1.0 + SQRT((3.0*WIDTH+13.0)/2.0)                        49.
         IF  (NSEP .GE. 50 .AND. DELTP1 .LE. 0.5*FNLVL) GO TO 300         50.
C        ----------------------------------------------------             51.
C        THE COMPONENT IS TOO SMALL, OR THE LEVEL STRUCTURE               52.
C        IS VERY LONG AND NARROW. RETURN THE WHOLE COMPONENT.             53.
C        ----------------------------------------------------             54.
            DO 200 I = 1, NSEP                                            55.
               NODE = LS(I)                                               56.
               SEP(I) = NODE                                              57.
               MASK(NODE) = 0                                             58.
  200       CONTINUE                                                      59.
            RETURN                                                        60.
C        -----------------------------                                    61.
C        FIND THE PARALLEL DISSECTORS.                                    62.
C        -----------------------------                                    63.
  300    NSEP = 0                                                         64.
         I = 0                                                            65.
  400    I = I + 1                                                        66.
            LVL = IFIX (FLOAT(I)*DELTP1 + 0.5)                            67.
            IF ( LVL .GE. NLVL )  RETURN                                  68.
            LVLBEG = XLS(LVL)                                             69.
            LP1BEG = XLS(LVL + 1)                                         70.
            LVLEND = LP1BEG - 1                                           71.
            LP1END = XLS(LVL + 2) - 1                                     72.
            DO 500 J = LP1BEG, LP1END                                     73.
               NODE = LS(J)                                               74.
               XADJ(NODE) =  - XADJ(NODE)                                 75.
  500       CONTINUE                                                      76.
C           -------------------------------------------------             77.
C           NODES IN LEVEL LVL ARE CHOSEN TO FORM DISSECTOR.              78.
C           INCLUDE ONLY THOSE WITH NEIGHBORS IN LVL+1 LEVEL.             79.
C           XADJ IS USED TEMPORARILY TO MARK NODES IN LVL+1.              80.
C           -------------------------------------------------             81.
            DO 700 J = LVLBEG, LVLEND                                     82.
               NODE = LS(J)                                               83.
               KSTRT = XADJ(NODE)                                         84.
               KSTOP = IABS(XADJ(NODE+1)) - 1                             85.
               DO 600 K = KSTRT, KSTOP                                    86.
                  NBR = ADJNCY(K)                                         87.
                  IF ( XADJ(NBR) .GT. 0 )  GO TO 600                      88.
                     NSEP = NSEP + 1                                      89.
                     SEP(NSEP) = NODE                                     90.
                     MASK(NODE) = 0                                       91.
                     GO TO 700                                            92.
  600          CONTINUE                                                   93.
  700       CONTINUE                                                      94.
            DO 800 J = LP1BEG, LP1END                                     95.
               NODE = LS(J)                                               96.
               XADJ(NODE) = - XADJ(NODE)                                  97.
  800       CONTINUE                                                      98.
          GO TO 400                                                       99.
       END                                                               100.
