#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/examples/ftrtest.c 07/23/93";
#endif

/*          This program reads in a matrix from disk with 
     SpRead and tries to factor it. It is intended to assist
     in debugging the factor routines.
*/

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include <stdio.h>
#include <fcntl.h>

SpMat *SpRead(  );

main()
{
  SpMat      *mat;
  SpMatSplit *f1,*f2;
  int        i,n,*rperm,*iperm,*cperm;
  int       fd;

  fd = open("badmatrix",O_RDONLY);

  /* read in the matrix */
  mat = SpRead(fd); n = mat->rows;


  /* printf("Matrix size %d  \n",n); */

  
  /* factor it one way */
  f1 = SpCreateSplit( mat, 0 ); 
  rperm = (int *) MALLOC(n*sizeof(int)); 
  cperm = (int *) MALLOC(n*sizeof(int)); 
  iperm = (int *) MALLOC(n*sizeof(int));
  SpOrder(mat,ORDER_ND,rperm,iperm);
  MEMCPY(cperm,rperm,n*sizeof(int)); 

  /* SpPrintSparseMatlabPermuted(0,mat,"badmatrix",rperm,cperm); */

  SpiSetMappingPtrs(f1->factor,rperm,cperm,iperm); 
  SpComputeFill( mat, f1 ); 
  SpComputeFactor( mat, f1 );

  printf("finished first factor \n"); 

  /* factor it a second way */
  f2 = SpCreateSplit( mat, 0 ); 
  rperm = (int *) MALLOC(n*sizeof(int)); 
  cperm = (int *) MALLOC(n*sizeof(int)); 
  iperm = (int *) MALLOC(n*sizeof(int)); 
  SpOrder(mat,ORDER_ND,rperm,iperm);
  MEMCPY(cperm,rperm,n*sizeof(int)); 
  SpiSetMappingPtrs(f2->factor,rperm,cperm,iperm); 
  SpComputeFill( mat, f2 ); 
  SpFindBlocks( f2->factor, 4 );
  SpComputeFactorPermBlock( mat, f2 );

  printf("finished second factor \n");

  SpEqual(f1->factor,f2->factor);
}
