/*
   This program tests the formation of a matrix from dense sub-parts.
   The dense matrices are in Fortran ordering.
 */

#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "system/system.h"
#include "sparse/spmat.h"

#define max(a,b) ( ((a)>(b))?a:b )
#define min(a,b) ( ((a)<(b))?a:b )

main( argc, argv )
int  argc;
char **argv;
{
int        i, j, k, n, dn, nb, *icol, *irow, dn2;
int        threen, threej, dnj;
SpMat      *mat;
SpMat      *mat2;
double     *dp;
double     t1;
double     trow, telm;

n     = 1024;
dn    = 16;
nb    = 64;
SYArgGetInt( &argc, argv, 1, "-n",  &n );
SYArgGetInt( &argc, argv, 1, "-dn", &dn );
SYArgGetInt( &argc, argv, 1, "-nb", &nb );
dn2  = dn * dn;
icol = (int *)MALLOC( 2 * dn * sizeof(int) );
irow = icol + dn;
dp   = (double *)MALLOC( dn2 * sizeof(double) );

mat  = SpCreate( n, n, 0 );
mat2 = SpCreate( n, n, 0 );
if (SYArgHasName( &argc, argv, 1, "-prealloc" ))
    SpChunckPrealloc( 2*nb*dn*dn );
trow = telm = 0.0;
SpAddElmCacheEnable();
threen = 3 * n;
for (i=0; i<nb; i++) {
    /* For each block */
    /* Generate local matrix */
    threej = 0;
    for (j=0; j<dn; j++) {
	irow[j] = (threej+i) % n;
	icol[j] = (threen - threej+2*i) % n;
	threej  += 3;
	}
    for (j=0; j<dn*dn; j++) 
	dp[j] = dn2*i + j;
    /* Add as block */
    t1 = SYGetCPUTime();
    SpAddDenseSubmatrix( mat2, dp, dn, dn, dn, irow, icol );
    trow += SYGetCPUTime() - t1;

    /* Add as individual members */
    t1 = SYGetCPUTime();
    dnj = 0;
    for (j=0; j<dn; j++) {
	for (k=0; k<dn; k++) 
	    SpAddValue( mat, dp[dnj+k], irow[k], icol[j] );
	dnj += dn;
	}
    telm += SYGetCPUTime() - t1;
    }
SpAddElmCacheDisable();
/* Compare the matrices */
if (!SpEqual( mat, mat2 )) {
    printf( "Matrices are not the same.  Matrix by AddValue is:\n" );
    SpPrint( stdout, mat );
    printf( "Matrix by AddDenseSubmatrix is:\n" );
    SpPrint( stdout, mat2 );
    return 1;
    }

printf( "Time by submatrix %5.2f, by element %5.2f\n", trow, telm );
return 0;
}



