/*
   A program to test sparse matrix reordering for zero diagonals
 */

#include <stdio.h>
#include <math.h>
#include "tools.h"
#include "sparse/spmat.h"

/* Forward references */
void CompareSolution();

#define max(a,b) ( ((a)>(b))?a:b )
#define min(a,b) ( ((a)<(b))?a:b )

main( argc, argv )
int  argc;
char **argv;
{
int        i,n, *perm, *iperm, *rperm, *irperm, err = 0;
SpMat      *mat;
SpMatSplit *factor;
double     *v, *vsol;

n     = 4;
v   = (double *)MALLOC( (n * sizeof(double)) );
vsol= (double *)MALLOC( (n * sizeof(double)) );
for (i=0; i<n; i++) vsol[i] = 1.0;

/* Form a permutation */
perm   = (int *)MALLOC( 4*n*sizeof(int) );
iperm  = perm + n;
rperm  = iperm + n;
irperm = rperm + n;
for ( i=0; i<n; i++ ) {rperm[i] = iperm[i] = perm[i] = i;}

/* Create a matrix with 0 diagonal entries */
mat = SpCreate( 4, 4, 2 );
SpAddValue( mat, 1.0, 0, 1 );
SpAddValue( mat, 1.0, 1, 0 );
SpAddValue( mat, 1.0, 0, 2 );
SpAddValue( mat, 1.0, 2, 0 );
SpAddValue( mat, -1.0, 1, 3 );
SpAddValue( mat, -1.0, 3, 1 );
SpAddValue( mat, 2.0, 2, 2 );
SpAddValue( mat, 2.0, 3, 3 );
SpMult( mat, vsol, v );

/* Reorder symmetrically */
SpSetMappingPtrs( mat, rperm, perm, iperm );
SpSymmetricReorderForZeroDiagonal( mat, 1.0e-10, rperm, perm );
if (GETERR) {
    fprintf( stderr, "Could not reorder matrix for zero diagonals\n" );
    exit(1);
    }
SpInverse( n, perm, iperm );
SpInverse( n, rperm, irperm );

factor = SpCreateSplit( mat, 0 );
SpSetMappingPtrs( factor, irperm, iperm, perm );
SpComputeFill( mat, factor );
SpComputeFactor( mat, factor );
SpSolve( factor, v, vsol );
CompareSolution( vsol, n );
SpDestroySplit( factor );

/* Reorder unsymmetrically */
for ( i=0; i<n; i++ ) {iperm[i] = perm[i] = i;}
SpUnSymmetricReorderForZeroDiagonal( mat, 1.0e-10, rperm, perm );
SpInverse( n, perm, iperm );
SpInverse( n, rperm, irperm );

factor = SpCreateSplit( mat, 0 );
SpSetMappingPtrs( factor, irperm, iperm, perm );
SpComputeFill( mat, factor );
SpComputeFactor( mat, factor );
SpSolve( factor, v, vsol );
CompareSolution( vsol, n );
SpDestroySplit( factor );

SpDestroy( mat );

/* At this point, mat2 and mat3 share storage for the matrix entries 
   but NOT for the mappings */
FREE(v);
FREE(vsol);
FREE(perm);
/* These are necessary ONLY to recover the rest of the allocated space */
ITRegisterDestroy();
SpOrderRegisterDestroy();


/* Here is some code to print the memory usage */
{int s, f;
TRSPACE(&s,&f);
printf( "Memory allocated = %d in %d blocks\n", s, f );
printf( "List of blocks is\n" );
TRDUMP(stdout);
 }
return 0;
}

void CompareSolution( v, n )
register double *v;
register n;
{
register double sum = 0.0;
while (n--) {
    sum += (*v - 1.0) * (*v - 1.0);
    v++;
    }
printf( "Difference in 2-norm is %f\n", sum );
}

