#include <stdio.h>
#include "tools.h"
#include "sparse/spmat.h"

/* This is a example program that exercises all of the sparse routines.
   The return code is the number of FAILURES.

   One possibility for testing this is to arrange a simple, postfix
   notation language for this so that a test sequence may be specified
   by a file.  Then all that the code looks like is a switch with a
   common format for calls for all routines.
 */

main( argc, argv )
int  argc;
char **argv;
{
SpMat *A, *B;
SpMat *MakeExample();
int   rrange[2], crange[3];
static double values[2] = { 1.0, 2.0 },
              rhs[2]    = { 3.0, 4.0 };

/* Build a simple example and subset it */
A = MakeExample( 3, 3 );
rrange[0] = 1; rrange[1] = 2;
crange[0] = 0; crange[1] = 2; crange[2] = 1;
B = SpSubset( A, 2, 3, rrange, crange );

/* Do a Condense */
SpCondenseWithVec( A, rrange, values, rhs, 2 );
exit(0);
}

SpMat *MakeExample(n1,n2)
int n1, n2;
{
SpMat *new;
static int    cols[3] = { 0, 2, 3 };
static double vals[3] = { 1.0, 2.0, 3.0 };
int    i;

new = SpCreate( n1, n2, 0 );
SpSetInRow( new, 0, 1, vals+1, cols );
SpAddInRow( new, 1, 2, vals+1, cols );
for (i=2; i<n1; i++) 
    SpSetInRow( new, i, 2, vals, cols );
return new;
}


/*
   This is a simple interpreter for all of the user ops
 */
static SpMat *stack;
static int   sp = 0;

int DoInstruction( instr, stk, sp, istk, sip )
int instr;
SpMat *stk;
int   sp, *istk, sip;
{

#define SP_SOLVE 0
#define SP_ADDINROW 1

switch (instr) {
    case SP_SOLVE:
    break;

    case SP_ADDINROW:
/*     SpAddInRow( stk[sp], row, n, v, c ); */
    break;

    default:
    printf( "Unknown operation %d\n", instr );
    }
}
