/*
       These are some routines needed for the LU factorization
   approach to solving a linear system using the SV package.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"

/*ARGSUSED*/
void SViCreateLU(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
  SVLUctx *lctx;

  lctx = NEW(SVLUctx); CHKPTR(lctx);
  lctx->ordering = ORDER_ND;
  lctx->threshold = 4;
  lctx->split = 0;
  lctx->pivoting = PIVOT_NONE;
  ctx->private = (void *) lctx;

  ctx->setup   = SViSetupLU;
  ctx->solve   = SViSolveLU;
  ctx->destroy = SViDestroyLU;
}
/*------------------------------------------------------------------*/
void SViSetupLU(ctx)
SVctx *ctx;
{
  SVLUctx *lctx = (SVLUctx *) ctx->private;
  double   t1;

  t1          = SYGetCPUTime();
  lctx->split = SpQuickFactor(ctx->mat,-1,lctx->ordering,lctx->threshold,
			      lctx->pivoting);
  if (!lctx->split) {
      SETERRC(1,"Could not allocate factored matrix in LU"); return;}
  ctx->flops  = SpCostFactor(lctx->split);
  ctx->memory = SpGetSpaceUsed(lctx->split);
  ctx->nz     = SpNz(lctx->split->factor);
  ctx->setupcalled = 1;
  ctx->t_setup += SYGetCPUTime() - t1;
}
/*------------------------------------------------------------------*/
int SViSolveLU(ctx,b,x)
SVctx   *ctx;
double  *b,*x;
{
  SVLUctx *lctx = (SVLUctx *) ctx->private;
  double  t1;
  
  t1          = SYGetCPUTime();
  ctx->flops  += 2*ctx->nz;
  SpSolve(lctx->split,b,x);
  ctx->t_solve += SYGetCPUTime() - t1;
  return 0;
}
/*------------------------------------------------------------------*/
void SViDestroyLU(ctx)
SVctx *ctx;
{
  SVLUctx *lctx = (SVLUctx *) ctx->private;

  if (lctx->split) SpDestroySplit(lctx->split); CHKERR(1);
  FREE(ctx->private); FREE(ctx);
}
