/* Local stuff for Block-diagonal method */

#ifndef SVSetBDDDomainsNumber

typedef struct {
    SpMat      *block;
    SVctx      *svc;
    int        nv, *idx, iscontig;
    SVMETHOD   lmeth;
    } SVBDDBlock;

typedef struct {
  int          nd;            /* Number of blocks */
  SVBDDBlock   *bb;
  SVMETHOD     defMeth;       /* Method to use on each block */
  ITMETHOD     defIt;
  int          itmax;
  double       *w1, *w2;      /* Work vectors */
  int          bflops;        /* Cost of preconditioner */
} SVBDDctx;

extern void SViSetupBDD();
extern int  SViSolveBDD();
extern void SViDestroyBDD();
extern void SViApplyBDD();
extern void SViCreateBDD();
extern void SViSetBDDDecomp();
extern void SViSetBDDMethodDecomp();
extern void SViSetBDDSolverDecomp();
extern void SViAllocBDDDomains();

/* Some likely options to provide */

/*M
     SVSetBDDDomainsNumber - Sets the number of blocks

     Input Parameters:
.    ctx - solver context
.    n   - number of blocks

     Synopsis:
     void SVSetBDDDomainsNumber( ctx, n )
     SVctx *ctx;
     int   n;
M*/
#define SVSetBDDDomainsNumber(C,v) \
{if ((C)->type == SVBDD) {((SVBDDctx *)(C)->private)->nd = v;}}

/*M
     SVSetBDDDefaultMethod - Sets the default method for block diagonal solves

     Input Parameters:
.    ctx - solver context
.    meth - solver method (i.e., SVILU)

     Synopsis:
     void SVSetBDDDefaultMethod( ctx, meth )
     SVctx *ctx;
     SVMETHOD meth;
M*/
#define SVSetBDDDefaultMethod(C,v) \
{if ((C)->type == SVBDD) {if (((SVBDDctx *)((C)->private))->bb) {\
SETERRC(1,"Must set default method before subdomains are defined");\
}else((SVBDDctx *)(C)->private)->defMeth = v;}}

#define SVSetBDDDefaultAccelerator(C,v) \
{if ((C)->type == SVBDD) {((SVBDDctx *)(C)->private)->defIt = v;}}

#define SVSetBDDDefaultMaxIt(C,v) \
{if ((C)->type == SVBDD) {((SVBDDctx *)(C)->private)->itmax = v;}}

/* define the indices to use for a particular subdomain (ie., define an
   alternate decomposition) */
#define SVSetBDDDecomp(C,i,idx,nv) \
SViSetBDDDecomp( C, i, idx, nv );

/* These two are not yet supported */
/* Method for a particular subdomain */
#define SVSetBDDMethodDecomp(C,i,v) \
SViSetBDDMethodDecomp(C,i,v);

/* Solver context for a particular subdomain (with optional matrix) */
#define SVSetBDDSolverDecomp(C,i,v,mat) \
SViSetBDDSolverDecomp(C,i,v,mat);

/* Get the solver context for a domain */
#define SVGetBDDSolver(C,i,ctx) \
{if ((C)->type == SVBDD) {ctx=((SVBDDctx *)(C)->private)->bb[i].svc;}}

#endif
