/*
    Context for Newton-trust region solver.
    This version provides multiple ways to specify the problem and
    determine the search direction 
 */
#ifndef __NEWTONTR2
#define __NEWTONTR2
typedef struct {
    void (*StepSetup)();
    void (*StepSolve)();
    void (*StepDestroy)();
    void *StepCtx;
    } NTSearchCtx;

typedef struct {
    void *Jcntx;
    void (*Jv)();      /* Routine to multiply by the jacobian */
    double actred, prered, delta;
    } NT2Cntx;

NLCntx *NLNewtonTR2Create();
void NLNewtonTR2SetUp( /* nlP, usrP */ );
int  NLNewtonTR2Solve( /* nlP, usrP */ );
void NLNewtonTR2Destroy( /* nlP, usrP */ );
#endif




