%TRANSPOSE FREE QMR (tfqmr).
%function [u,v,r,x]=tfqmr(A,x0,b);
%Authors: Lisette de Pillis, Tony Chan
%Date:	  September 16, 1991.
%
%Performs unspecified number of  steps of unsymmetric Lanczos on
%A, to solve Ax=b using the QMR method of Freund,
%starting with the vector v0 = (b-A*x0)/norm(b-A*x0) (of norm 1).
%This version is transpose free--ie, the Lanczos vectors are "squared".
%
%For QMR updating scheme, see Freund&Nachtigal, "QMR: A Quasi-Minimal
%Residual Method for Non-Hermitian Linear Systems", RIACS 90.51, Dec 1990.
%For TFQMR, see Chan, dePillis, and Van der Vorst, "A Transpose-Free
%Squared Lanczos Algorithm and Application to Solving Nonsymmetric
%Linear Systems", UCLA CAM Report 91-17, September 1991.
%

itmax = 40;
I = eye(A);
x = x0(:);
b = b(:); 
R = b - A*x;
r(1) = norm(R);
um1 = zeros(b);
u = R/r(1); 
vm1 = um1; 
v = u; 
v0  = u;
pvec1 = um1;
pvec2 = um1; 
p=um1; 
theta = 0;
ep = 0; 
cl1 = 0; 
sl1 = 0; 
cl = 0; 
sl = 0;
sprod = 1; 
tau_n1 = r(1); 
f=1; 
gamma=1; 
rhom1 = 1;

%TEST ONLY
% rtrue(1) = norm(b-A*x);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%CALCULATE SQUARED LANCZOS  vectors 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
i=1;
while (r(i)/r(1)>tol)
  y 	= A*u; 
  alpha = (v0'*y)/(v0'*u); 
  deltmp = alpha;
  z	= y - alpha*u; 
  rho=(v0'*u); 
  AA = A-alpha*I;
  beta  = rho / (f*rhom1); 
  rhom1 = rho;
  up1   = AA*(z-2*beta*p) + f*beta*beta*um1;
  f     = 1/norm(up1); 
  up1   = f*up1;
  p     = f*(z - beta*p);
  um1   = u;  u = up1;  				%update the u's
  beta = beta/gamma; 
  eptmp = beta;
  vp1   = AA*v - beta*vm1;
  gamma = norm(vp1); 
  vp1 = vp1/gamma;
  vm1   = v; 
  v = vp1;  				%update the v's

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%SOLVE  Ax = b 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Apply the last two Given's (Gl-1 and Gl) rotations to (beta,alpha,gamma)
  if (i > 2) 
    theta =  sl1*beta; 
    eptmp = -cl1*beta; 
  end;
  if (i > 1) 
    ep =-cl*eptmp + sl*alpha; 
    deltmp=-sl*eptmp - cl*alpha; 
  end;

  if (abs(gamma) > abs(deltmp)) 	%Find new Givens rotations
    ta = -deltmp/gamma; 
    s = 1/sqrt(1 + ta*ta); 
    c = s*ta;
  else  
    ta = -gamma/deltmp; 
    c = 1/sqrt(1 + ta*ta); 
    s = c*ta; 
  end

  delta = -c*deltmp + s*gamma;
  tau_n  = -c*tau_n1; 
  tau_n1 = -s*tau_n1; 		%update "t"
  pvec   = (vm1 - theta*pvec2 - ep*pvec1)/delta; 	%update "p"
  x = x + tau_n*pvec; 					%Update x
  cl1 = cl;  sl1 = sl; cl = c; sl = s; 		%Update rotations
  pvec2 = pvec1;
  pvec1 = pvec;    			%Update pvec

%Compute the upper bound on the residual norm r (See QMR paper p. 13)
  sprod = sprod*abs(s); 
  r(i+1) = r(1)*sqrt(i+1)*sprod; 
%TEST ONLY
% rtrue(i+1) = norm(b-A*x);
  
  i = i+1;
  fprintf('\n Lanczos_Square with QMR residual at step %1.0f: %e', i-1, r(i))
  if (i > itmax),
    fprintf('\n Lanczos squared with QMR iteration limit reached.')
    break
  end;
end; %while
fprintf('\n');
