#ifndef lint
static char SCCSid[] = "@(#) ./iter/itsimp.c 07/23/93";
#endif

#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/itpriv.h"
#include <stdio.h>

/*@
  ITSimpleCreate - Builds ITCntx for a particular solver; simple interface.

  Input Parameters:
.  itmethod   - One of the known methods.  See "iter/itctx.h" for
    available methods. For instance ITCG or ITGMRES.
.  amult      - routine to perform matrix-vector product
.  binv       - routine to perform preconditioning.  May be null.
.  x          - pointer to solution vector
.  b          - pointer to rhs vector
.  n          - size of vectors

   Returns:
   Pointer to iterative context.

   Usage:
   This routine is intended simplify the use of the iterative routines
   when simple, dense vectors are being used.  An even simpler interface
   is provided by solvers; more control may be exercised by using ITCreate
   directly.

   A sample use is:
$  itP = ITSimpleCreate( ITCG, amult, binv, x, b, n );
$  ITSetUp(itP,&n);
$  its = ITSolve(itP,&n);
$  ITDestroy(itP,&n);
 @*/
ITCntx *ITSimpleCreate(itmethod, amult, binv, x, b, n )
ITMETHOD itmethod;
void     (*amult)(), (*binv)();
double   *x, *b;
int      n;
{
ITCntx *itP;

itP = ITCreate(itmethod); CHKERRV(1,0);

/* set default vector functions */
DVSetDefaultFunctions( itP->vc );

ITSetAmult(itP,amult);
if (binv)
    ITSetBinv(itP,binv);
else
    ITSetBinv(itP,itP->vc->copy);  

/* set locations of rhs and solution vectors */
ITSetSolution(itP,(void *)x);
ITSetRhs(itP,(void *)b);

return itP;
}
