#ifndef lint
static char SCCSid[] = "@(#) ./iter/itres.c 07/23/93";
#endif

#include "tools.h"

#define IT -1
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/itpriv.h"
#include <stdio.h>
/*@
    ITResidual - Compute the initial residual without making any assumptions
    about the solution.  Uses the general iterative structure.

    Input parameters:
.    vsoln - solution to use in computing residual
.    vt1,2 - temps that are needed
.    vres  - calculated residual
.    vbinvf- the result of binv^{-1} b.  If null, don't do it
.    vb    - right-hand-side to use

    Notes:
    This routine assumes that an iterative method, designed for
$            A x = b
    will be used with a preconditioner, C, such that the actual problem is
$            M u = f    
    where M = AC (right preonditioning) or CA (left preconditioning).
 @*/
int ITResidual(usrP,itP,vsoln,vt1,vt2,vres, vbinvf,vb)
void   *usrP;
ITCntx *itP;
void   *vsoln, *vt1, *vt2, *vres, *vbinvf, *vb;
{
if (itP->right_inv) {
    if (vbinvf) COPY(vb,vbinvf);
    vbinvf = vb;
    }
else {
    PRE(vb,vbinvf);
    itP->nbinv++;
    }
if (!itP->guess_zero) {
    /* compute initial residual: f - M*x */
    /* (inv(b)*a)*x or (a*inv(b)*b)*x into dest */
    if (itP->right_inv) {
        /* we want a * binv * b * x, or just a * x for the first step */
        /* a*x into temp */
        MM( vsoln, vt1 );
	itP->namult++;
        }
    else {
        /* else we do binv * a * x */
        MATOP( vsoln, vt1, vt2 );
	itP->nmatop++;
        }
    /* This is an extra copy for the right-inverse case */
    COPY( vbinvf, vres ); 
    DAXPY( -1.0, vt1, vres );
          /* inv(b)(f - a*x) into dest */
    itP->nvectors++;
    }
else {
    COPY( vbinvf, vres );
    }
return 0;
}

/*@
  ITUnwindPre - Unwind the preconditioning in the solution

  Input Parameters:
. usrP - user pointer
. itP  - iterative context
. vsoln - solution vector 
. vt1   - temporary vector

  Output Parameter:
. vsoln - contains solution on output  
@*/
int ITUnwindPre( usrP, itP, vsoln, vt1 )
void   *usrP;
ITCntx *itP;
void   *vsoln, *vt1;
{

/* If we preconditioned on the right, we need to solve for the correction to
   the unpreconditioned problem.  Nothing needs to be done on the left. */
if (itP->right_inv) {
    PRE( vsoln, vt1 );
    COPY( vt1, vsoln );
    itP->nbinv++;
    }
return 0;
}

