#ifndef lint
static char SCCSid[] = "@(#) ./iter/itregis.c 07/23/93";
#endif

#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/itpriv.h"
#include <stdio.h>

/*@
   ITRegisterAll - Registers all the iterative methods
  in the IT package. 

  Notes:
  To prevent all the methods from being
  registered and thus save memory, copy this routine and
  register only those methods desired.
@*/
void ITRegisterAll()
{
  ITRegister((int)ITRICHARDSON , "richardson", ITRichardsonCreate);
  ITRegister((int)ITCHEBYCHEV  , "chebychev",  ITChebychevCreate);
  ITRegister((int)ITCG         , "cg",         ITCGCreate);
  ITRegister((int)ITGMRES      , "gmres",      ITGMRESCreate);
  ITRegister((int)ITTCQMR      , "tcqmr",      ITTCQMRCreate);
  ITRegister((int)ITBCGS       , "bcgs",       ITBCGSCreate);
  ITRegister((int)ITCGS        , "cgs",        ITCGSCreate);
  ITRegister((int)ITTFQMR      , "tfqmr",      ITTFQMRCreate);
  ITRegister((int)ITLSQR       , "lsqr",       ITLSQRCreate);
  ITRegister((int)ITPREONLY    , "preonly",    ITPREONLYCreate);
}
