#ifndef lint
static char SCCSid[] = "@(#) ./iter/itcreate.c 07/23/93";
#endif

#include "tools.h"
#include "iter/itctx.h"
#include "iter/itfunc.h"
#include "iter/itpriv.h"
#include "system/nreg.h"
#include <stdio.h>

static NRList *__ITList = 0;

/* -------------------------------------------------------------*/
/*@
  ITCreate - Builds ITCntx for a particular solver. Itmethod is
  for instance ITCG or ITGMRES.  

  Input Parameter:
.  itmethod   - One of the known methods.  See "iter/itctx.h" for
    available methods (for instance ITCG or ITGMRES).
 @*/
ITCntx *ITCreate(itmethod)
ITMETHOD itmethod;
{
   ITCntx    *itP;
   ITCntx    *(*r)();

  /* Get the function pointers for the iterative method requested */
  if (!__ITList) {ITRegisterAll();}
  if (!__ITList) {
    SETERRC(1,"Could not acquire list of iterative methods"); return 0;}
  r =  (ITCntx *(*)())NRFindRoutine( __ITList, (int)itmethod, (char *)0 );
  if (!r) {SETERRC(1,"Unknown IT method"); return 0;}

  itP = (*r)();
  return(itP);        
}
/*----------------------------------------------------------------*/
/*@
   ITRegister - Adds the iterative method to the iter package,  given
   an iterative name (ITMETHOD) and a function pointer.

   Input Parameters:
.      name - for instance ITGMRES, ...
.      sname -  corresponding string for name
.      create - routine to create method context

@*/
void ITRegister(name, sname, create)
int     name;
char    *sname;
ITCntx  *(*create)();
{
if (!__ITList) __ITList = NRCreate();
NRRegister( __ITList, name, sname, (void (*)())create );
}
/*----------------------------------------------------------------*/
/*@
   ITRegisterDestroy - Frees the list of iterative solvers
   registered by ITRegister().
@*/
void ITRegisterDestroy()
{
if (__ITList) {
    NRDestroy( __ITList );
    __ITList = 0;
    }
}

/*@
  ITGetMethod - Returns the selected method, given the argument list.

  Input parameters:
. Argc - pointer to arg count
. argv - argument vector
. sname - name used to indicate solver.  If null, -itmethod is used

  Output parameter:
. itmethod -  Iterative method type
@*/
void ITGetMethod( Argc, argv, sname, itmethod )
int      *Argc;
char     **argv, *sname;
ITMETHOD *itmethod;
{
char sbuf[50];

if (!sname) sname = "-itmethod";
if (SYArgGetString( Argc, argv, 1, sname, sbuf, 50 )) {
    if (!__ITList)
	ITRegisterAll();
    *itmethod = (ITMETHOD)NRFindID( __ITList, sbuf );
    }
}

/* @
   ITGetMethodName - Get the name (as a string) from the method type

   Input Parameter:
.  itctx - Iterative context
@ */
char *ITGetMethodName( itmeth )
ITMETHOD itmeth;
{
return NRFindName( __ITList, itmeth );
}
