#ifndef LINT
static char SCCSidI[] = "@(#) ./comm/save/initp4.c 07/23/93";
#endif

/* p4 specific routines */

static int P4ARGC, (*P4ROUTINE)();
static char **P4ARGV;
static int   p4argc;
static char  **p4argv;

#include "comm/htable/bhost.h"
#include "system/system.h"
#include "comm/hosts.h"

/* Hold the globals for p4 here */
int __P4FROM, __P4LEN, __P4TYPE;

void PIWriteP4PG();
char *getenv();

/*
    p4exitall - terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface.
 */
static void p4exitall(msg,rc)
char *msg;
int  rc;
{
p4_error( msg ? msg : "ExitAll", 0 );
}

/*
   PIcall - Call a routine in a parellel execution mode.
   See init.c for a complete description of the interface.
 */
PIcall( np, procgroup, pfname, routine, argc, argv )
int  np, argc;
char **procgroup, *pfname;
char **argv;
int  (*routine)();
{
int   i, amslave = 0, haspgfile = 0;
char tmplate[1024];
int  wrotepgfile = 0;
FILE *fp;
int  fsec;

P4ROUTINE = routine;

/* Set default resource limits */
SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );
gettimeofday( &maxtime, 0 );
maxtime.tv_sec += fsec;
/* Get the resource limits and remove them from the argument list 
   (note that the master will over-write these when the the slaves start) */
SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 0 );

/* Copy the arguments */
p4argv    = (char **) MALLOC( (argc + 5) * sizeof(char *) );
if (!p4argv) {
    fprintf( stderr, "Can not create argument list for p4_initenv\n" );
    return;
    }
for (i=0; i<argc; i++) {
    p4argv[i] = argv[i];
    if (strcmp( "-amp4slave", argv[i] ) == 0) amslave   = 1;
    if (strcmp( "-pg",        argv[i] ) == 0) haspgfile = 1;
    }
p4argc    = argc;
/* For backend processors, we can automagically add the -amp4slave option */
#ifdef intelnx
if (!amslave && mynode() != 0) {
    p4argv[p4argc++] = "-amp4slave";
    amslave          = 1;
    }
#endif

if (!amslave && !haspgfile) {
    p4argv[p4argc++] = "-pg";
    p4argc++;          /* leave room for the procgroup name */
    if (pfname) 
	p4argv[p4argc-1] = pfname;
    else if (procgroup) {
	strcpy( tmplate, "/tmp/PIXXXXXX" );
	pfname = (char *)mktemp( tmplate );
	fp     = fopen( pfname, "w" );
	if (!fp) return;
	for (i=0; i<np; i++) 
	    fprintf( fp, "%s\n", procgroup[i] );
	fclose( fp );
	wrotepgfile = 1;
	p4argv[p4argc-1] = pfname;
	}
    else {
	/* See the notes at the end of this file about an alternate
	   approach for this */
	wrotepgfile = PIiFormP4PGFile( &argc, argv, tmplate, 
				       np, mem, cpu, pf );
	if (!wrotepgfile) {
	    fprintf( stderr, "Could not create p4 procgroup file\n" );
	    return;
	    }
	pfname           = tmplate;
	p4argv[p4argc-1] = pfname;
	if (SYArgHasName( &argc, argv, 1, "-list" )) {
	    /* List the pgfile */
	    }
	}
    }
/* printf( "About to call p4_initenv; amslave = %d\n", amslave ); */
p4_initenv( &p4argc, p4argv );

/* Set up usage controls and default signal handlers.  p4 catches SIGINT;
   we look here for other exceptions. 
   Users may override these by resetting them in the slave process */
SYSetExitAll(p4exitall);
SYDefaultSignals( (void *)0 );

/* Pass only remaining args to other routines */
P4ARGC    = argc;
P4ARGV    = argv;

if (p4_get_my_id() == 0) {
    /* p4_dprintf( "Creating procgroup\n" ); */
    p4_create_procgroup();
    }
slave();
/* Delete the procgroup file */
if (wrotepgfile) 
    unlink( pfname );
p4_wait_for_end();
FREE(p4argv);
}

/* p4 requires a slave program named slave.  Here it is */
slave( )
{
/* p4_dprintf( "id = %d, nprocs = %d\n", MYPROCID, NUMNODES ); */
/* Distribute the arguments from the main program */
LOGpush(); LOGDISABLE;
PIBroadcastArgs( &P4ARGC, &P4ARGV, MYPROCID == 0, (ProcSet *)0 );
PIGetDebugArgs( &P4AARGC, P4ARGV );

#ifdef DUMP_ARGS
{ int i;
printf( "On node %d\n", MYPROCID );
for (i=0; i<P4ARGC; i++) {
    printf( "[%d] %s\n", i, P4ARGV[i] );
    }
}
#endif

/* Distribute the usage limits */
PIBroadcastLimits( &cpu, &mem, &pf, &maxtime, &niceval, MYPROCID == 0, 
		   (ProcSet *)0 );
SYSetLimits( mem, cpu, pf, &maxtime );
if (niceval > 0) SYNice( niceval );
LOGpop();

PIinitlog();
(*P4ROUTINE)( P4ARGC, P4ARGV );
PIendlog();
}

/* 
   Write a procgroup file given a host list.
   utable contains the hosts to use.
 */
void PIWriteP4PG( utable, fout )
FILE      *fout;
HostTable *utable;
{
  int i,j, np, maxarches = MAXARCHES;
  char *machine,*program;

  fprintf( fout, "local 0\n" );
  for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
      for ( j=0; j<utable->archtable[i].ne; j++ ) {
        machine = utable->archtable[i].hosts[j]->name;
        np = utable->archtable[i].hosts[j]->np;
        program = utable->archtable[i].fname;
        fprintf(fout, "%s %d %s \n",machine, np,program);
      }   
    }   
  } 
}

/*
  Form the p4 procgroup file.  Return the file name
  where it was stashed.  Returns 0 if it failed to write the file.
 */
int PIiFormP4PGFile( argc, argv, pfname, np, mem, cpu, pf )
int  *argc;
char **argv, *pfname;
int  np, mem, cpu, pf;
{
int       dbg, tim;
char      arch[20], pname[1024], pgm[1024], bname[31], *path, *archpath;
char      hostfname[1024], cwd[1024];
FILE      *fin, *fout;
HOSTEntry *plist;
int       nl, i, nnp;
HostTable *table,*utable;
Arch      narch;

/* determine base name of our, to be created, process group */
PIBaseName( argv[0],0,bname, 31 );

/* Set defaults; get special parameters */
SYArchType( arch, 20 );narch = PIStringToArch(arch);
dbg  = 0;
if (argv[0][0] != '/') {
    SYGetwd( pname, 1024 );
    strcat( pname, "/" );
    strcat( pname, argv[0] );
    }
else
    strcpy( pname, argv[0] );
SYArgsToResources( argc, argv, &np, &dbg, arch, pname );
PIBuildPgmName( pname, arch, pgm );

/* Find the host file to use */
SYGetFileFromEnvironment( "TOOLSHOST", 
			  DEFAULTTOOLSHOST, 
			  "hosts", hostfname, 'r' );

fin = fopen( hostfname, "r" );
if (!fin) return 0;

/* Find a location for the procgroup file */
fout = SYOpenWritableFile( "./:~/", "/tmp/PIXXXXXX", "PIXXXXXX", pfname, 1 );
if (!fout) return 0;

/* get environmental variables needed  */
SYGetwd( cwd, MAXPATHLEN );
archpath = getenv("TOOLSARCHES");if (!archpath) archpath = arch;
path = getenv("PATH"); if (!path) path = cwd;

table = PIReadInHostTable(fin, mem, cpu, pf, 0); fclose(fin);
if (!table) {
    fprintf( stderr, "Could not read in host table\n" );
    return 0;
    }

/* We need a version that allows multiple uses of the "local" processor */
utable =
    PIBuildHostTable(bname,np-1,table,&argc,&argv,path,archpath,0,narch,cwd,0);
if (!utable) {
    fprintf( stderr, "Could not find enough entries in host table\n" );
    return 0;
    }

/* Write out the actual file */
PIWriteP4PG( utable, fout );
fclose( fout );
PIDestroyHostTable(utable);
PIDestroyHostTable(table);
return 1;
}

/*
  In the newest versions of p4, it is possible to dispense with the 
  procgroup files entirely.  Do this with
  p4_startup( pg )
  struct p4_procgroup *pg;
  
  This should replace p4_initenv() (?).

  This contains entries of the form
  struct p4_procgroup_entry; 
  see /usr/local/p4t1/include/p4.h for the definitions.

  Note that the structure still has some problems, as the "fullpathname"
  of the slave may exceed 100 characters.  

  We must convice the p4 group to use either MAXPATHLEN or dynamic allocation.

  Also, there is STILL no clean include file that I can use.  Note that
  many of the p4 include files will break if they are included more than
  once.
 */

#define PI_HAS_INIT
#define PI_HAS_EXIT

