#ifndef lint
static char SCCSid[] = "@(#) ./comm/mcomm/cpack.c 07/23/93";
#endif

/* 
   This file contains routines for packing and unpacking a buffer.
 */
#include "tools.h"

void PIpackvec( src, elmlen, stride, elmcount, buf, datatype )
char *src, *buf;
int  elmlen, stride, elmcount, datatype;
{
long   *lv, *slv;
int    i, j;

/* The idea here is to try to use at least 4-byte moves (sizeof(long)) 
   if at all possible */
if ((elmlen & 0x3) == 0 && (stride & 0x3) == 0 && sizeof(long) == 4) {
    lv  = (long *)buf;
    slv = (long *)src;
    elmlen >>= 2;
    stride >>= 2;
    for (i=0; i<elmcount; i++) {
	for (j=0; j<elmlen; j++) 
	    *lv++ = slv[j];
	slv += stride;
	}
    }
else {
    for (i=0; i<elmcount; i++) {
	for (j=0; j<elmlen; j++) 
	    *buf++ = src[j];
	src += stride;
	}
    }
}

void PIunpackvec( src, elmlen, stride, elmcount, buf, datatype )
char *src, *buf;
int  elmlen, stride, elmcount, datatype;
{
long   *lv, *slv;
int    i, j;

/* The idea here is to try to use at least 4-byte moves (sizeof(long)) 
   if at all possible */
if ((elmlen & 0x3) == 0 && (stride & 0x3) == 0 && sizeof(long) == 4) {
    lv  = (long *)buf;
    slv = (long *)src;
    elmlen >>= 2;
    stride >>= 2;
    for (i=0; i<elmcount; i++) {
	for (j=0; j<elmlen; j++) 
	    slv[j] = *lv++;
	slv += stride;
	}
    }
else {
    for (i=0; i<elmcount; i++) {
	for (j=0; j<elmlen; j++) 
	    src[j] = *buf++;
	src += stride;
	}
    }
}

/* These are the indexed pack routines */
PIpackI( buf, elmlen, ibuf, elmcount, lbuf, datatype )
char *buf, *lbuf;
int elmlen, *ibuf, elmcount, datatype;
{
int i, j, offset;

for (i=0; i<elmcount; i++) {
    offset = ibuf[i] * elmlen;
    for (j=0; j<elmlen; j++) 
	lbuf[j] = buf[offset+j];
    lbuf += elmlen;
    }
}

PIunpackI( buf, elmlen, ibuf, elmcount, lbuf, datatype )
char *buf, *lbuf;
int elmlen, *ibuf, elmcount, datatype;
{
int i, j, offset;

for (i=0; i<elmcount; i++) {
    offset = ibuf[i] * elmlen;
    for (j=0; j<elmlen; j++) 
	buf[offset+j] = lbuf[j];
    lbuf += elmlen;
    }
}

