#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"
#ifndef NULL
#include <stdio.h>
#endif

/* This code was written by Nick Galbreath
   There are still some bugs, but Nick thinks that it is basically correct
 */

typedef struct {
  int slice_start, /* first element in dimension to be written */
      slice_end,   /* last element in dimension to be written */
      ghost_start, /* local proc's first ghost point (very first entry) */
      ghost_end,   /* local proc's last ghost point (very last entry) */
      live_start,  /* local proc's first working (live) index */
      live_end,    /* local proc's last working (live) index */
      offset;  /* origin for dimension (0 for C, 1 for Fortran ) */
    } PIPart;

/*
@ PIWritePart: write parts of a distributed array such that reguardless of the number of processors used, the exact same file will be written

Input Parameters:
. fp  - paralle file pointer (given by PIOpen)
. fmat - form to format data in.
. zz   - Array that determines what gets written
. nd   - number of dimensions in array
. v    - pointer to array to be written
. datatype - data type of v (MSG_INT, etc...)

.  fmat - If NULL then data is copied straight from memory to the file
(unformatted).  Otherwise the format is similar to the the C 'printf'
command.  Use "%d" for integers, "%l" for long integers, "%f" for type
float, and "%lf" for double precision numbers.  
One must use field length specifers, e.g. "%f7.4" or "%d2" as oppossed to 
plain "%f" "%d".  One may also have more than one per line (if appropiate) 
and include non varibale data, "nx = %d3, ny = %f7.5 \n".

.  flen - is the size in bytes of output generate by fmat,
above.  Example if one used unformatted data then flen would
"sizeof(datatype)", e.x. sizeof(int).  If one is reading in ascii data
that was written with a fmat of "%f7.2 ", a floating point number with
seven characters plus one space at the end, would have a flen of 8. 

. zz - This array specifies how the global and local arrays are set up and 
which region to write.  It has 7 fields for dimension:
$ slice_start - The first element in the dimension that will be written
$ slice_end   - The last element in the dimension that will be written
$ ghost_start - The very first index of the local processor's array (the 
index of the very first ghost point).  If the array has no ghost points the 
ghost_start will be the same as live_start, below
$ ghost_end   - The very last index of the local processor's array (the index 
of the very last ghost point). If the array has no ghost points, then 
ghost_end will be the same as live_end below.
$ live_start  - The first working index of actual data (non-ghost or living) 
in the local processor's array.
$ live_end    - The last working index of actual data (non-ghost or living) 
in the local processor's array.
$ offset      - The "origin" of the dimension, i.e. the first (global) index 
of living data.  This is the live_start value for the first node (node 0).  
Example: if one had an array dimension as [0:4, 2:10, 3:20] then the offset 
values would be 0, 2, 3 assuming no ghost points.  Again, if each processor 
had one ghost point on each side, the offset would 1,3, and 4.
 
. nd  - Equal to the number of the dimensions of the array.  If one is
using complex data, add 1 to your normal dimension ( a 3-d complex
array would have a nd value of 4)

. datatype - use MSG_INT for "int" data, use MSG_FLT for "float" data,
use MSG_DBL for "double" data, use MSG_OTHER for character or any
other data you do not want formatted (typically non-numeric data).

@
*/
void PIWritePart(fp, fmat, flen, zz, nd, v, datatype)
PIFILE *fp;
char   *fmat;
void   *v;
PIPart *zz;
int    *flen, *nd, *datatype;
{
 PIArrayPart *sz;
 int i;
 
 printf("Hello World!");
 for (i=0; i <= *nd - 1; i++) {
 
/* first compute dimension of file */
    sz[i].mdim = zz[i].slice_start - zz[i].slice_end + 1;

/* Next compute total length of processor's array (includes ghosts) */
    sz[i].ndim = zz[i].ghost_start - zz[i].ghost_end + 1;

/* Compute starting offset in processor's dimension & global file*/

/* is the start of the slice before the first live element? */
    if (zz[i].slice_start <= zz[i].live_start) {
    
/*     yes, but is the end slice before it too? */
       if (zz[i].slice_end >= zz[i].live_start) {
/*        no, we have data to write */         
          sz[i].start = zz[i].live_start - zz[i].ghost_start;
          sz[i].gstart = zz[i].live_start - zz[i].slice_start 
                         + 1 - zz[i].offset;
	}
/*        yes, we don't have any data to write */
       else { 
          sz[i].start = -1;
          sz[i].gstart = -1;
	}
     }
  
/* starting slice is after first live element */
    else {

/*     is the slice after last live element? */
       if (zz[i].slice_start  <= zz[i].live_end) {

/*        no, slice_start is in my domain */
          sz[i].start = zz[i].slice_start - zz[i].ghost_start;
          sz[i].gstart = 0;
	  }
/*        yes, outside of domain, no data to write */
       else {
          sz[i].start = -1;
          sz[i].gstart = -1;
	}
  }

/* Compute ending positions */

/* Is end slice before last live element? */
    if (zz[i].slice_end <= zz[i].live_end) { /* slice_end <= live_end */

/*     And is end slice before first live element? */ 
       if (zz[i].slice_end < zz[i].live_start) {
/*        Yes, we have no data to write (slice_end < live_start <= live_end) */
          sz[i].end = 0;
          sz[i].gend = 0;
	}
/*        No, we have data  (live_start <= slice_end <= live_end */
       else {
          sz[i].end =  zz[i].slice_end - zz[i].ghost_start;  
          sz[i].gend = zz[i].slice_end - zz[i].slice_start
                       + 1 - zz[i].offset;
	}
     
     }
/*  End slice is after first live element   live_end < slice_end */
    else { /* live_end < slice_end */

/*  Is starting slice is after last live element, too? */
    if (zz[i].slice_start > zz[i].live_end) {
/*     Yes, no data to write.  live_end < slice_start */ 
       sz[i].end = 0;
       sz[i].gend = 0;
     }

/*     No, starting slice before last live element, ok */
     else {   /* slice_start <= live_end < slice_end */
       sz[i].end = zz[i].live_end - zz[i].ghost_start + 1;
       sz[i].gend = zz[i].slice_end - zz[i].slice_start
                    + 1 - zz[i].offset;
     }
   }
}
/* Whew! */
 printf("Goodbye World!");
 PIFPrintArraySpec(sz, nd);
 PIWriteDistributedArray(fp, fmat, flen, sz, nd, v, datatype);
}







