#ifndef lint
static char SCCSid[] = "@(#) ./comm/global/gcol.c 07/23/93";
#endif

#include "comm/comm.h"
#include "comm/global/global.h"
#include <stdio.h>

void gcolsetT( lbuf, lsize, gbuf, gsiz, glen, procset, datatype )
char    *lbuf, *gbuf;
int     lsize, gsiz, *glen, datatype;
ProcSet *procset;
{
char *p   = gbuf;
int  size = gsiz, ln, gsize;
int  l_child, r_child, parent;
int msgup, msgdn, lphase;

/* printf( "[%d] doing gcol\n", MYPROCID );  */
/* copy lbuf to gbuf */
MEMCPY(gbuf,lbuf,lsize);
p     += lsize;
gsize  = lsize;
size  -= lsize;

LOGPUSHATOMIC;

/* Receive values from my children and accumulate */
if (!procset) {
    if (_PIPARENT < -1)
	PISetupCollectiveTree( );
    l_child = _PILCHILD;
    r_child = _PIRCHILD;
    parent  = _PIPARENT;
    _PIPHASE= _PIPHASE ? 0 : 1;
    lphase  = _PIPHASE;
    }
else {
    l_child = procset->l_child;
    r_child = procset->r_child;
    parent  = procset->parent;
    GMSGPHASE(procset,lphase);
    }
msgup = GMSGTYPE(procset,MSG_UP|lphase);
msgdn = GMSGTYPE(procset,MSG_DN|lphase);
if (l_child >= 0) {
    RECVSYNCNOMEM(msgup,p,size,datatype);
    ln    = RECVLEN();
    gsize += ln;
    size  -= ln;
    p     += ln;
    }
if (r_child >= 0) {
    RECVSYNCNOMEM(msgup,p,size,datatype);
    ln    = RECVLEN();
    gsize += ln;
    size  -= ln;
    p     += ln;
    }

/* Send to parent */
if (parent >= 0) {
    SENDSYNCNOMEM(msgup,gbuf,gsize,parent,datatype);
    RECVSYNCNOMEM(msgdn,gbuf,gsiz,datatype);
    gsize = RECVLEN();
    }
if (gsize > gsiz) 
    fprintf( stderr, "gcol overran buffer\n" );
*glen = gsize;
/* Distribute final value back down */
if (l_child >= 0)
    SENDSYNCNOMEM(msgdn,gbuf,gsize,l_child,datatype);
if (r_child >= 0)
    SENDSYNCNOMEM(msgdn,gbuf,gsize,r_child,datatype);
/* printf( "Done with gcol[%d]\n", myid ); */
LOGPOPATOMIC;
}




