/*
    These are the definitions particular to the pvm implementation.
 */

#ifndef __commpvm
#define __commpvm

#ifndef __commh
#include "comm/comm.h"
#endif

extern int __PVMFROM, __PVMLEN, __PVMTYPE, __PVMGLOBALTYPE;
extern char *__PVMCOMPONENT;

#define MSG_INT   0
#define MSG_LNG   1
#define MSG_FLT   2
#define MSG_DBL   3
#define MSG_OTHER 4
#define MSG_SHRT  5

#define NO_ASYNC_SEND
#define NO_ASYNC_RECV
#define NO_FORCE
#define NO_NATIVE_GLOBAL

#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	pvm_send(type,to,(int*)(buffer),length,datatype);LOGSENDEND(type);}
#define RECVSYNC(type,buffer,length,datatype) { \
        __PVMFROM = -1;__PVMTYPE = type; __PVMLEN = length;LOGRECVSTART(type);\
        pvm_recv(&__PVMTYPE,&__PVMFROM,(int*)(buffer),&__PVMLEN,datatype); \
        LOGRECVEND(type,__PVMLEN,__PVMFROM);}
#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)
/* Note: if the buffer was smaller than the received message, we should
   generate an error */
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        RECVSYNC(type,buffer,length,datatype)
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
      	__PVMFROM = -1;__PVMTYPE = type; __PVMLEN = size; LOGRECVSTART(type);\
       pvm_recv_unsz(&__PVMTYPE,&__PVMFROM,(int**)&(bufp),&__PVMLEN,datatype);\
        LOGRECVEND(type,size,__PVMFROM);}

#define SYNCPROBE(type) {while(probe(type)==-1);\
	 rcvinfo( &__PVMLEN, &__PVMTYPE, &__PVMCOMPONENT, &__PVMFROM );}
extern int PIpvmIprobe();
#define ASYNCPROBE(type) PIpvmIprobe(type)

/* I'm not sure that this is correct */
#define RECVPROBED(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)

#define RECVLEN()  __PVMLEN
#define RECVFROM() __PVMFROM
#define RECVTYPE() __PVMTYPE

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)

#define NUMNODES __NUMNODES
#define MYPROCID __MYPROCID

/* The max value below is approximate */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=10000000;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGSIZES(min,max)      {*min=0;*max=(16384*8096);}
#define MSGDIAMETER            (NUMNODES-1)

#endif

