/*
    These are the definitions particular to the p4 implementation.
 */

#ifndef __commp4
#define __commp4

#ifndef __commh
#include "comm/comm.h"
#endif

/* p4.h makes assumptions about the definition */
#if defined(sun3) || defined(sun4)
#define SUN
#endif

#if defined(intelnx)
#define IPSC860
#define IPSC860_NODE
#endif

/* Patch for bug in p4 definitions */
#ifdef _USC_DEFS_
#undef _USC_DEFS_
#endif

/* 
   P4 allows message buffers to be pre-allocated.  However, this can cause
   a storage leak in some situations.  Define COMM_P4_NOPREALLOC to 
   avoid this problem 
 */
#define COMM_P4_NOPREALLOC

/* Include my own copy since I don't need all of those awful definitions */
#include "comm/p4.h"
extern int __P4FROM, __P4LEN, __P4TYPE, __P4GLOBALTYPE;
extern int __P4SpinWait;
extern int __P4NoPrealloc;
extern int __P4MYTID, __P4NUMTIDS;

/* Convert generic datatype to p4 version */
#define MSG_INT   P4INT
#define MSG_LNG   P4LNG
#define MSG_FLT   P4FLT
#define MSG_DBL   P4DBL
#define MSG_OTHER P4NOX
#define MSG_SHRT  P4INT

#define NO_ASYNC_SEND
#define NO_ASYNC_RECV
#define NO_FORCE

/* I don't really want to do this because SYNCPROBE is a busy loop */
#if defined(LOGCOMMEVENTS) 
#define LOGRECVQ(type) \
if(__P4SpinWait){LOGRECVWAIT(type);SYNCPROBE(type);LOGRECVREADY(type);}
#else
#define LOGRECVQ(type) 
#endif

/* This should optionally use p4_sendx for xdr version */
/* Also, use p4_sendb and p4_msg_alloc for non-NOMEM version */
#define SENDSYNC(type,buffer,length,to,datatype) \
        {LOGSENDSTART(length,type,to);\
	     p4_sendx(type,to,(char*)(buffer),length,datatype);\
         LOGSENDEND(type);}

#if !defined(COMM_P4_NOPREALLOC)
#define RECVSYNC(type,buffer,length,datatype) {\
        __P4LEN  = length; __P4FROM = -1; /* From Any */ __P4TYPE = type;\
        LOGRECVQ(type);\
	LOGRECVSTART(type);\
        p4_recv(&__P4TYPE,&__P4FROM,(char**)&(buffer),&__P4LEN);\
        LOGRECVEND(type,__P4LEN,__P4FROM);}
/* Note: if the buffer was smaller than the received message, we should
   generate an error */
#define RECVSYNCNOMEM(type,buffer,length,datatype)  \
        { char *__p4lbuffer=0;                      \
        RECVSYNC(type,__p4lbuffer,length,datatype); \
        if (__P4LEN > (length)) {char _lbuf[100];\
    sprintf( _lbuf, "Truncated message from %d to %d bytes (from %d, tag=%d)",\
              __P4LEN,length__P4FROM,__P4TYPE);\
	SETERRC(1,_lbuf); __P4LEN = length;} \
        MEMCPY(buffer,__p4lbuffer,__P4LEN);            \
	p4_msg_free(__p4lbuffer);}
#else
/* This should be a routine call */
#define RECVSYNC(type,buffer,length,datatype) \
        { char *__p4lbuffer=0;                      \
        __P4LEN  = length; __P4FROM = -1; /* From Any */ __P4TYPE = type;\
        LOGRECVQ(type);\
	LOGRECVSTART(type);\
        p4_recv(&__P4TYPE,&__P4FROM,(char**)&(__p4lbuffer),&__P4LEN);\
        LOGRECVEND(type,__P4LEN,__P4FROM);\
        if (__P4LEN > (length)) {char _lbuf[100];\
    sprintf( _lbuf, "Truncated message from %d to %d bytes (from %d, tag=%d)",\
	    __P4LEN,length,__P4FROM,__P4TYPE);\
	SETERRC(1,_lbuf);__P4LEN = length;} \
        MEMCPY(buffer,__p4lbuffer,__P4LEN);            \
	p4_msg_free(__p4lbuffer);}
#define RECVSYNCNOMEM(type,buffer,length,datatype) \
        RECVSYNC(type,buffer,length,datatype)
#endif

#define SENDSYNCNOMEM(type,buffer,length,to,datatype) \
        SENDSYNC(type,buffer,length,to,datatype)

#if !defined(COMM_P4_NOPREALLOC)
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
	bufp=0;__P4FROM= -1;__P4TYPE=type;LOGRECVSTART(type);\
        p4_recv(&__P4TYPE,&__P4FROM,(char**)&(bufp),&(size));\
	LOGRECVEND(type,size,__P4FROM);}
#else
#define RECVSYNCUNSZ(type,bufp,size,datatype) {\
	bufp=0;__P4FROM= -1;__P4TYPE=type;LOGRECVSTART(type);\
        p4_recv(&__P4TYPE,&__P4FROM,(char**)&(bufp),&(size));\
	LOGRECVEND(type,size,__P4FROM);\
        {char *_bufp=MALLOC(size);CHKPTR(_bufp);MEMCPY(_bufp,bufp,size);\
        p4_msg_free(bufp);bufp=_bufp;}}
#endif

#define SYNCPROBE(type) {\
	__P4TYPE = type; __P4FROM= -1;\
	while(!p4_messages_available(&__P4TYPE,&__P4FROM));}
#define ASYNCPROBE(type) (__P4TYPE=type,__P4FROM= -1,\
        p4_messages_available(&__P4TYPE,&__P4FROM))

/* This is just RECVSYNCNOMEM, but without resetting __P4FROM */
/* ??? is this correct if buffer preallocated ? */
#define RECVPROBED(type,buffer,length,datatype) {\
        __P4LEN  = length; __P4TYPE = type;\
        LOGRECVSTART(type);buffer=0;\
	p4_recv(&__P4TYPE,&__P4FROM,(char**)&(buffer),&__P4LEN);\
        LOGRECVEND(type,__P4LEN,__P4FROM);}

#define RECVLEN()  __P4LEN
#define RECVFROM() __P4FROM
#define RECVTYPE() __P4TYPE

/* Define "p4_has_global" for versions of p4 that have the global operations */
/* Note that these need to have the logging routines wrapped around them */
#ifdef p4_has_global
#define GISUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_sum_op);else\
                                   gisumset(val,n,work,procset);
#define GDSUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_sum_op);else\
                                   gdsumset(val,n,work,procset);
#define GFSUM(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(float),p4_flt_sum_op);else\
                                   gfsumset(val,n,work,procset);
#define GIMAX(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_max_op);else\
				   gihighset(val,n,work,procset);
#define GIMIN(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(int),p4_int_min_op);else\
                                   gilowset(val,n,work,procset);
#define GDMAX(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_max_op);else\
				   gdhighset(val,n,work,procset);
#define GDMIN(val,n,work,procset)  if(!procset) \
         p4_global_op(__P4GLOBALTYPE,val,n,sizeof(double),p4_dbl_min_op);else\
                                   gdlowset(val,n,work,procset);
#define GIOR(val,n,work,procset)   \
    giorset( val, n, work, procset )
#define GSYNC(procset)             gsyncset(procset)
#define GCOL(lbuf,lsize,gbuf,gsiz,glen,procset,datatype) \
        gcolset(lbuf,lsize,gbuf,gsiz,glen,procset,datatype)
#define GCOLX(lbuf,gsizes,gbuf,procset,datatype) \
        gcolxset(lbuf,gsizes,gbuf,procset,datatype)
#define GTOKEN(procset,i) gtokenset(procset,i)
#define GSCATTER(buf,siz,issrc,procset,datatype) {LOGOPSTART(LOG_SCATS);\
        gscatterset(buf,siz,issrc,procset,datatype);LOGOPEND(LOG_SCATE);}
#define GSCATTERSRC(buf,siz,src,procset,datatype) {LOGOPSTART(LOG_GSCATS);\
         gscattersetsrc(buf,siz,src,procset,datatype);LOGOPEND(LOG_GSCATE);}
#else
#define NO_NATIVE_GLOBAL
#endif

#define MSGALLOCSEND(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREESEND(msg)               FREE(msg)
#if defined(COMM_P4_NOPREALLOC)
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)MALLOC(maxmsg)
#define MSGFREERECV(msg)               FREE(msg)
#else
#define MSGALLOCRECV(msg,maxmsg,type)  msg = (type *)p4_msg_alloc(maxmsg)
#define MSGFREERECV(msg)               p4_msg_free((char*)(msg))
#endif

#define NUMNODES (p4_num_total_slaves()+1)
#define MYPROCID p4_get_my_id()
/* The max value below is approximate */
#define MSGTYPERANGE(low,high) {*(low)=0;*(high)=1000000000;}
#define MSGDISTANCE(from,to)   gdistdf(from,to)
#define MSGSIZES(min,max)      {*min=0;*max=(16384*8096);}
#define MSGDIAMETER            (NUMNODES-1)
#endif
