#ifndef lint
static char SCCSid[] = "@(#) ./blog/blogat.c 07/23/93";
#endif

#define DBUG(a)
/* #define DBUG(a) {printf("%s",a);fflush(stdout);} */

/*
   This file contains the routines to adjust logfiles before they
   are actually FILES.

   The timer model used here is

       global_time = local_time * skew + local_offset

   The local times are computed as a delta from time when the logging
   is initialized (see xx_BLOG_tinit and SYuscDiff).

   Because all of these corrections are approximate, they can be selectively
   disabled.
 */

#include "tools.h"
#include <stdio.h>
#if !defined(solaris)
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include "comm/comm.h"
#include "blog/blog.h"
#include "system/system.h"
typedef struct _blog { struct _blog *next; int size; } BLOG_BLOCK;
extern BLOG_BLOCK *xx_BLOG_get_blog_ptr();
static SYusc_time_t xx_BLOG_tinit;

static int          disableAll     = 0,
		    disableSkew    = 0,
                    disableOffsets = 1,   /* not working yet */
		    printOffsets   = 0;

/*@C
  BLOGClockControl - Gives command line control over the clock handling by
                     the event log generator

  Input Parmeters:
. argc - pointer to argument count
. argv - argument vector

  Description:
  This routine looks for arguments of the form -blogclock [skew | offsets |
  print | all | noskew | nooffsets | noprint | none ].

  This routine is called by PIinitlog, which is in turn called by PICall.
  Users normally need not use this routine.
@*/
void BLOGClockControl( argc, argv )
int  *argc;
char **argv;
{
int idx;
char *p;
while ((idx = SYArgFindName( *argc, argv, "-blogclock" )) >= 0) {
    if (idx >= *argc) return;
    p = argv[idx+1];
    if (strcmp(p, "skew") == 0)           disableSkew    = 0;
    else if (strcmp(p, "noskew") == 0)    disableSkew    = 1;
    else if (strcmp(p, "offsets") == 0)   disableOffsets = 0;
    else if (strcmp(p, "nooffsets") == 0) disableOffsets = 1;
    else if (strcmp(p, "print") == 0)     printOffsets   = 1;
    else if (strcmp(p, "noprint") == 0)   printOffsets   = 0;
    else if (strcmp(p, "all") == 0) { disableSkew = 0; disableOffsets = 0;
				     disableAll  = 0; }
    else if (strcmp(p,"none") == 0)       disableAll     = 1;
    else {
	SETERRC(1,"Unknown argument to blogclock" );
	SETERRC(1,p);
	}
    argv[idx] = 0;
    argv[idx+1] = 0;
    SYArgSqueeze( argc, argv );
    }
}

/* This routine is called by the BLOG initialization routine to
   set the 0-point for the clocks */		    
xx_BLOG_init_clock()
{
SYusc_clock( &xx_BLOG_tinit );
}

/* Convert the time "cookies" to usecs.  This is done carefully to 
   preserve precision.  HOWEVER, this may perturb the data on 
   machines that have synchronous clocks. NOTE that the time is
   stored as DOUBLES after this routine is called. */
void xx_BLOG_adjtime1()
{
int               xx_i, procid, *bp, n;
SYusc_time_t      *t;
double            dif;
BLOG_BLOCK        *bl;
BLOG_HEADER       *ap;

bl         = xx_BLOG_get_blog_ptr();
while (bl) {
    n      = bl->size;
    bp     = (int *)(bl + 1);
    xx_i   = 0;
    while (xx_i < n) {
	ap    = (BLOG_HEADER *)bp;
	t     = &ap->time;
	if (t->s1[0] != 0 || t->s1[1] != 0) {
	    dif   = SYuscDiff( &xx_BLOG_tinit, t );
	    ap->time.s2 = dif;
	    }
	xx_i += ap->len;
	bp   += ap->len;
	}
    bl = bl->next;
    }
}

/*
   Find skew and a basic offset based on the global sync events in the
   log.  Returns 1 if values found, 0 otherwise.
 */
int xx_BLOG_FindSkew( ps, Skew, Goff )
ProcSet *ps;
double  *Skew, *Goff;
{
int               xx_i, procid, *bp, n;
SYusc_time_t      *t;
double            sync_start, sync_end, tim, v0[2], sk, goff, time, gt;
int               found_first = 0, nsync = 0;
int               xx_save;
BLOG_BLOCK        *bl;
BLOG_HEADER       *ap;

/* printf( "[%d] starting adj 2\n", MYPROCID ); */
bl         = xx_BLOG_get_blog_ptr();
while (bl) {
    n      = bl->size;
    bp     = (int *)(bl + 1);
    xx_i   = 0;
    while (xx_i < n) {
	ap   = (BLOG_HEADER *)bp;
	if (ap->event == BLOG_EVENT_SYNC) {
	    tim   = ap->time.s2;
	    if (found_first) 
		sync_end   = tim;
	    else {
		sync_start  = tim;
		found_first = 1;
		}
	    nsync ++;
	    }
	xx_i += ap->len;
	bp   += ap->len;
	}
    bl = bl->next;
    }

/* Trade the information (for more complete adjustments, everyone needs
   the skews and global offsets) */
v0[0] = sync_start;
v0[1] = sync_end;
/* Don't add yet more events! */
#undef LOGOPSTART
#undef LOGOPEND
#define LOGOPSTART(n)
#define LOGOPEND(n)
DBUG("About to do a scatter\n" );
GSCATTER( v0, 2*sizeof(double), MYPROCID == 0, ps, MSG_DBL );

/* Don't do anything if there aren't enough values */
if (nsync < 2) {
    xx_BLOG_status = xx_save;
    return 0;
    }

/* printf( "[%d] scaling times \n", MYPROCID ); */
*Skew = (v0[1] - v0[0]) / (sync_end - sync_start);
*Goff = v0[0] - sync_start;
return 1;
}

/*
   Find offsets from the offset events, given a skew.
   Return 1 on success, 0 on failure.
 */
int xx_BLOG_FindLocalOffset( ps, sk, Goff )
ProcSet *ps;
double  sk, *Goff;
{
int               xx_i, procid, *bp, n;
SYusc_time_t      *t;
double            tim, goff, time, gt;
int               xx_save;
BLOG_BLOCK        *bl;
BLOG_HEADER       *ap;

/* This code looks for offset events and tries to correct the local clocks
   (GSYNC isn't very accurate for the offsets, though it is better than
   nothing) */
if (PIComputeOffsets( )) {
    double *skew, *w;
    int    i;
    
    /* Get the skews for all of the clocks */
    skew = (double *)MALLOC( NUMNODES * sizeof(double) );   CHKPTR(skew);
    w    = skew + NUMNODES;
    for (i=0; i<NUMNODES; i++) skew[i] = 1.0;  /* for now, could use
						gcolx */
    /* printf( "[%d] skew = %f offset = %f\n", MYPROCID, sk, goff ); */
    /* All nodes must use the same goff */
    goff = *Goff;
    GDMIN( &goff, 1, &time, ps );
    PIComputeTimeOffsets( NUMNODES, skew, &goff );
    FREE( skew );
    /* printf( "[%d] skew = %f offset = %f loffset = %f\n", 
	     MYPROCID, sk, goff, sync_start ); */
    }
else 
    goff = *Goff;

/* goff should really be the adjusted by subtracting off the minimum of all
   of the goff's */
gt   = goff;
GDMIN( &gt, 1, &time, ps );
goff -= gt;

*Goff = goff;
return 1;
}

void xx_BLOG_ApplyTimeCorrection( ps, sk, goff )
ProcSet *ps;
double  sk, goff;
{
int               xx_i, procid, *bp, n;
SYusc_time_t      *t;
double            tim, time, gt;
int               xx_save;
BLOG_BLOCK        *bl;
BLOG_HEADER       *ap;

bl = xx_BLOG_get_blog_ptr();
while (bl) {
    n      = bl->size;
    bp     = (int *)(bl + 1);
    xx_i   = 0;
    while (xx_i < n) {
	ap    = (BLOG_HEADER *)bp;
	t     = (SYusc_time_t *)(&ap->time);
	if (t->s1[0] != 0 || t->s1[1] != 0) {
	    time  = ap->time.s2;
	    gt    = time * sk + goff;
	    /* The following is a hack! */
	    /* printf( "[%d] o = %f n = %f\n", MYPROCID, time, gt ); */
	    if (gt < 0.0) gt = 0.0;
	    /* End of hack */
	    /* This should really be
	       if (gt > maxunsignedlong) ap[2] = gt / maxunsignedlong;
	       else
	     */  
	    ap->time.s1[0] = 0;
	    ap->time.s1[1] = (unsigned long)(gt * 1.0e6);
	    }
	xx_i += ap->len;
	bp   += ap->len;
	}
    bl = bl->next;
    }
}

/*
   Find offsets for a procset.
 */
void xx_BLOG_adjtime2( ps )
ProcSet *ps;
{
int     i;	
double  sk, goff;

/* printf( "[%d] starting adj 2\n", MYPROCID ); */
/* Set the defaults, just in case */
sk   = 1.0;
goff = 0.0;
if (!disableSkew && !xx_BLOG_FindSkew( ps, &sk, &goff )) return;

if (!disableOffsets && !xx_BLOG_FindLocalOffset( ps, sk, &goff )) return;

if (printOffsets) {
    for (i=0; i<=NUMNODES; i++) {
    	if (GTOKEN(ps,i)) {
    	    fprintf( stdout, "[%d] local * %f + %f\n", MYPROCID, sk, goff );
    	    }
        }
    }
xx_BLOG_ApplyTimeCorrection( ps, sk, goff );
/* printf( "[%d] Done adjusting times\n", MYPROCID ); */
}


static int AdjustedTimes = 0;
xx_BLOG_adjusttimes()
{
int xx_save;

if (AdjustedTimes) return;

DBUG("About to convert cookies to times\n");
xx_BLOG_adjtime1();  /* Time is now in double format */

if (disableAll) {
    /* Convert times back to integer format */
    xx_BLOG_ApplyTimeCorrection( ALLPROCS, 1.0, 0.0 );
    return;
    }

DBUG("Did 1, about to do 2\n" );
xx_save = xx_BLOG_status;
xx_BLOG_status = 0;
xx_BLOG_adjtime2((ProcSet*)0);
xx_BLOG_status = xx_save;
AdjustedTimes = 1;
/* printf( "Adjusted times\n" ); fflush(stdout); */
BLOG_DISABLE;
}

/* This is the routine that adds the clock offset events */
/* global.h is needed to get a valid system message type */
#include "comm/global/global.h"
BLOGAddClockEvents()
{
GSYNC( ALLPROCS );
LOGEVENT(EVENT_SYNC);
/* Eventually, this should be user-configurable. */
if (NUMNODES <= 16) 
    PIAddOffsetPair0( MSG_GLOBAL, &xx_BLOG_tinit );
else
    PIAddOffsetPair1( MSG_GLOBAL, &xx_BLOG_tinit );
}
