

/* 
   This file contains a test program for the routines that generate
   BC programs for global arrays with a variety of decompositions 
 */

#include "tools.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include "comm/comm.h"
#include <stdio.h>

int main( argc, argv )
int  argc;
char **argv;
{
int main2();
PICall( main2, argc, argv );
return 0;
}

/*ARGSUSED*/
int main2( argc, argv )
int  argc;
char **argv;
{
int         i, nd, myid, nproc, step;
BCArrayPart sz[8];
BCPGM       *pgm;
double      *a;
int         mx, my;         /* Global sizes */
int         nx, ny;         /* Local sizes */

mx = 10;
my = 6;
/* Define the array */
nd = 2;
sz[0].mdim        = mx;
sz[0].is_parallel = 1;
sz[0].ndim        = -1;
sz[1].mdim        = my;
sz[1].is_parallel = 1;
sz[1].ndim        = -1;

/* Setup the ghost points from the stencil */
BCFindGhostFromStencil( nd, sz, 0, (int *)0, 11 );
nproc = NUMNODES;
myid  = MYPROCID;
BCGlobalToLocalArray( nd, sz, nproc, myid );
if (mx < 10 && my < 10) {
    for (i=0; i<=NUMNODES; i++) {
	if (GTOKEN(0,i)) {
	    printf( "P%d\n", i );
	    BCPrintArrayPart( stdout, nd, sz );
	    fflush( stdout );
	    }
	}
    }
pgm = BCBuildArrayPGM( nd, sz, nproc, myid, sizeof(double) );
BCUseSyncSend( pgm );
BCArrayCompile( pgm, 0 );

/* Now, allocate the appropriate array */
a    = (double *)MALLOC( BCArrayPartSize( nd, sz ) * sizeof(double) );
/* initialize a */
InitDomain( nd, sz, a );
for (step=0; step<10; step++) {
    BCexec( pgm, (void *)a, (void *)a );
    }

if (mx < 10 && my < 10) {
    nx = sz[0].end - sz[0].start + 1 + sz[0].eg + sz[0].sg;
    ny = sz[1].end - sz[1].start + 1 + sz[1].eg + sz[1].sg;
    for (i=0; i<=NUMNODES; i++) {
	if (GTOKEN(0,i)) {
	    printf( "P%d\n", i );
	    PrintDomain( nx, ny, mx, my, a );
	    fflush( stdout );
	    }
	}
    }
BCfree( pgm );
return 0;
}


/*ARGSUSED*/
PrintDomain( nx, ny, mx, my, p )
int    nx, ny, mx, my;
double *p;
{
int    i, j;
double *p1;

/* Start from top down so that the vertical ordering is the same as
   the users' */
for (j=ny-1; j>=0; j--) {
    p1 = p + j * nx;
    i  = nx;
    while (i--)
        printf( "%f ", *p1++ );
    printf( "\n" );
    }
}

InitDomain( nd, sz, a )
int         nd;
BCArrayPart sz[];
double      *a;
{
int    i, n, base;
double bval;

base = 1;
for (i=0; i<nd; i++) {
    if (i > 0) base *= sz[i-1].ndim;
    base += sz[i].loc;
    }
n = BCArrayPartSize( nd, sz );
bval = base;
while (n--) 
    *a++ = bval++;
}

