#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/exec/rwait.c 07/23/93";
#endif

/* #define DEBUG */
#include "tools.h"
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>

#ifdef intelnx
/*
   This routine processes all of the recv's from pgm_save to pgm-1.
   Return the value of pgm_save on exit.  This version polls the
   possible messages.
 */
BCentry *BCdo_recvPoll( pgm, pgm_save, in, phase )
BCentry *pgm, *pgm_save;
int        (*in)(), phase;
{
int notdone = 0, firstpass = 1;
BCentry *pgmstart = pgm_save;
do {
    pgm_save = pgmstart;
    while (pgm_save < pgm) {
	if (pgm_save->phase >= phase) return pgm_save;
	if (IS_DEST(pgm_save)) {
	    if ((pgm_save->type & BLOCK_COMM_BUFFER) && pgm_save->rc > 0) {
#ifdef DEBUG
		printf( "Waiting (recv) type %d from %d on %d in do_recv processing\n",
		       pgm_save->mtype, pgm_save->processor, MYPROCID );
#endif
		/* use msgdone on intelnx here */
		if (msgdone(pgm_save->rc)) {	
		    RECVWAITNOMEM(pgm_save->mtype,pgm_save->buffer,pgm_save->act_len,
				  MSG_DBL,pgm_save->rc);
			  
#ifdef DEBUG
		    printf( "Received type %d from %d on %d (%d bytes)in do_recv processing\n",
			   pgm_save->mtype, pgm_save->processor, MYPROCID, RECVLEN );
#endif
		    pgm_save->rc = 0;
		    if (!firstpass) notdone--;
		    if (!pgm_save->inplace)
			(*in)( pgm_save->buffer, &pgm_save->src );
		    }
		else {
		    if (firstpass) notdone++;
		    }
		}
	    }
	NEXTLINE(pgm_save);
	}
    } while (notdone);
return pgm_save;
}
#endif
