/*--------------------------------------------------------------------------
 Routines to read and write file headers.
--------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "hdr.h"

static char sccsid[] = "@(#)hdr.c	1.1 7/15/91";

void
hdr_read(fp, hdr, msg)
    FILE *fp;
    hdr_t *hdr;
    char *msg;
{
    /* Read header */
    if (fread(hdr, sizeof(hdr_t), 1, fp) != 1) {
	perror(msg);
	exit(1);
    }
    /* Skip to data, if needed */
    if (hdr->hdrlen > sizeof(hdr_t))
	fseek(fp, hdr->hdrlen-sizeof(hdr_t), 1);
}

void
hdr_write(fp, nrec, reclen, kind)
    FILE *fp;
    int   nrec;			/* number of records in file */
    int   reclen;		/* number of elements in record */
    int   kind;			/* description of element type */
{
    hdr_t hdr;

    /* Fill header */
    hdr.magic = hdr_MAGIC;
    hdr.hdrlen = sizeof(hdr_t);
    hdr.nrec = nrec;
    hdr.reclen = reclen;
    hdr.kind = kind;

    /* Write header */
    if (fwrite(hdr, sizeof(hdr_t), 1, fp) != 1) {
	perror("hdr_write");
	exit(1);
    }
}

void
hdr_kind2a(kind, buf)
    int kind;
    char *buf;
{
    sprintf(buf, "0x%x = %d bytes/scalar", kind, kind & hdr_KIND_BYTES);
    if (!(kind & (hdr_KIND_FLOAT | hdr_KIND_BFP)))
	sprintf(buf+strlen(buf), ", integer");
    if (kind & hdr_KIND_FLOAT)
	sprintf(buf+strlen(buf), ", floating point");
    if (kind & hdr_KIND_BFP)
	sprintf(buf+strlen(buf), ", block floating point");
    if (kind & hdr_KIND_COMPLEX)
	sprintf(buf+strlen(buf), ", complex");
}

