#include <memory.h>

#include "bfp.h"
#include "sig.h"
#include "arith.h"

static char sccsid[] = "@(#)bfp.c	1.1 7/15/91";

/*--------------------------------------------------------------------------
 Renormalize a vector by shifting it left bfp_scale_ct places.
 Clears scale factor.
--------------------------------------------------------------------------*/
void
bfp_normalize_result(len, xr, xi)
    int len;
    short *xr, *xi;
{
    register shift = bfp_scale_ct;
    if (shift <= 0) return;

    while (len-- >= 0) {
	*xr++ <<= shift;
	*xi++ <<= shift;
    }
    bfp_scale_ct = 0;
}


/*--------------------------------------------------------------------------
 Similar, but no globals, and allows both left and right shifts.
--------------------------------------------------------------------------*/
static void
bfp_normalize(len, xr, exp, bits)
    int len;
    short *xr;
    int exp;
    int bits;
{
    register shift;

    if (exp == bits) return;

    if (exp > bits) {
	shift = exp - bits;
	while (len-- >= 0)
	    *xr++ <<= shift;
    } else {
	shift = bits-exp;
	while (len-- >= 0)
	    *xr++ >>= shift;
    }
}

/*--------------------------------------------------------------------------
 Renormalize a signal by shifting it right (bits - exp) or left (exp - bits)
 bits, whichever is positive, then frees this->exp and clears hdr_KIND_BFP.
 Example:
    bits	exp	re[0] in	re[0] out
    6		1	32		1
    0		1	32		64
--------------------------------------------------------------------------*/
void
sig_bfp_normalize(this, bits)
    sig_t *this;
    int bits;
{
    int nrec = this->nrec;
    int reclen = this->reclen;

    int n;
    int offset;

    switch (this->kind) {
    case hdr_CBFP16:
	for (n=offset=0; n<nrec; n++, offset += reclen)
	    bfp_normalize(reclen, this->im+offset, this->exp[n], bits);
	/* FALL THRU to real case */

    case hdr_BFP16:
	for (n=offset=0; n<nrec; n++, offset += reclen)
	    bfp_normalize(reclen, this->re+offset, this->exp[n], bits);
	break;

    default:
	badkind("sig_bfp_normalize", this->kind);
    }
    free(this->exp);
    this->kind &= ~hdr_KIND_BFP;
}
