/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/error_msg.c,v $
 *
 *
 *  MODULE NAME:    error_msg.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

#include <stdio.h>
#include "cdc.h"
#include "cdc_db.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "spxapi_defs.h"

Sphinx_error_message(code, errmsg)
int code;
char  *errmsg;
{
  switch(code) {
    case SPX_S_UNABLE_TO_ACCESS_CLAIM_CRED :
      strcpy(errmsg, "SPX : unable to access claimant's credential file (issue spxinit)");
      break;
    case SPX_S_UNABLE_TO_ACCESS_VERIF_CRED :
      strcpy(errmsg, "SPX : unable to access verifier's credential file (issue install_server)");
      break;
    case SPX_S_CLAIM_CRED_CORRUPT :
      strcpy(errmsg, "SPX : claimant's credentials corrupt");
      break;
    case SPX_S_VERIF_CRED_CORRUPT :
      strcpy(errmsg, "SPX : verifier's credentials corrupt");
      break;
    case SPX_S_CLAIM_CRED_EXPIRED :
      strcpy(errmsg, "SPX : claimant's credentials expired (reissue spxinit)");
      break;
    case SPX_S_VERIF_CRED_EXPIRED :
      strcpy(errmsg, "SPX : verifier's credentials expired (reissue install_server)");
      break;
    case SPX_S_CLAIM_CRED_NOT_VALID_YET :
      strcpy(errmsg, "SPX : claimant's credentials not valid yet");
      break;
    case SPX_S_VERIF_CRED_NOT_VALID_YET :
      strcpy(errmsg, "SPX : verifier's credentials not valid yet");
      break;
    case SPX_S_NOT_PROPER_CRED :
      strcpy(errmsg, "SPX : do not have proper credentials to authenticate");
      break;
    case SPX_S_TICKET_EXPIRED :
      strcpy(errmsg, "SPX : login ticket expired");
      break;
    case SPX_S_TICKET_NOT_VALID_YET :
      strcpy(errmsg, "SPX : login ticket not valid yet");
      break;
    case SPX_S_CLAIM_UNABLE_TO_ACCESS_CDC :
      strcpy(errmsg, "SPX : on claimant side, CDC unavailable");
      break;
    case SPX_S_CLAIM_VERIFY_PUBKEY_FAILED :
      strcpy(errmsg, "SPX : verifing verifier pubkey failed");
      break;
    case SPX_S_CLAIM_CANT_FIND_CERTIF_PATH :
      strcpy(errmsg, "SPX : can't find certification path to verifier");
      break;
    case SPX_S_RSA_SIGN_ERROR :
      strcpy(errmsg, "SPX : RSA sign error");
      break;
    case SPX_S_CANT_ESTAB_CLAIMANT_CRED :
      strcpy(errmsg, "SPX : can't establish claimant context credentials");
      break;
    case SPX_S_MUTUAL_RESPONSE_BAD :
      strcpy(errmsg, "SPX : bad mutual response (possibly claimant used incorrect verifier pubkey)");
      break;
    case SPX_S_BAD_TOKEN_FORMAT :
      strcpy(errmsg, "SPX : illegal authentication token format");
      break;
    case SPX_S_UNSUPPORTED_TOKEN :
      strcpy(errmsg, "SPX : unsupported token");
      break;
    case SPX_S_NO_NAME_IN_TOKEN :
      strcpy(errmsg, "SPX : no user name in token");
      break;
    case SPX_S_VERIF_UNABLE_TO_ACCESS_CDC :
      strcpy(errmsg, "SPX : on verifier side, CDC unavailable");
      break;
    case SPX_S_VERIF_VERIFY_PUBKEY_FAILED :
      strcpy(errmsg, "SPX : verifing the claimant's pubkey failed");
      break;
    case SPX_S_VERIF_CANT_FIND_CERTIF_PATH :
      strcpy(errmsg, "SPX : can't find certification path to claimant");
      break;
    case SPX_S_WRONG_EVID_IN_TOKEN :
      strcpy(errmsg, "SPX : wrong evidence in token");
      break;
    case SPX_S_ERROR_EXTRACTING_DESKEY :
      strcpy(errmsg, "SPX : error extracting deskey");
      break;
    case SPX_S_DESKEY_EXPIRED :
      strcpy(errmsg, "SPX : deskey expired");
      break;
    case SPX_S_INVALID_AUTHENTICATOR :
      strcpy(errmsg, "SPX : invalid authenticator (check channel bindings)");
      break;
    case SPX_S_ILLEGAL_TICKET :
      strcpy(errmsg, "SPX : illegal login ticket");
      break;
    case SPX_S_DELEGATOR_EVID_FAILED :
      strcpy(errmsg, "SPX : checking delegator evidence failed");
      break;
    case SPX_S_VERIFY_TICKET_FAILED :
      strcpy(errmsg, "SPX : verify login ticket failed");
      break;
    case SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED :
      strcpy(errmsg, "SPX : can't establish delegated claim credentials");
      break;
    case SPX_S_AUTHENTICATOR_ASKEW :
      strcpy(errmsg, "SPX : authenticator (clocks out of sync), need mutual auth");
      break;
    case SPX_S_ILLEGAL_PASSWORD :
      strcpy(errmsg, "SPX : illegal password");
      break;
    case SPX_S_ERROR_SIGNING_MUTUAL :
      strcpy(errmsg, "SPX : signing challenge for root access fails");
      break;
    case SPX_S_ERROR_VERIFY_MUTUAL :
      strcpy(errmsg, "SPX : verifying challenge for root access fails");
      break;

    case SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_UP :
      strcpy(errmsg, "SPX : can't find certif path to verifier (going up)");
      break;
    case SPX_S_CLAIM_CANT_FIND_CERTIF_PATH_GOING_DN :
      strcpy(errmsg, "SPX : can't find certif path to verifier (going down)");
      break;
    case SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_UP :
      strcpy(errmsg, "SPX : can't find certif path to claimant (going up)");
      break;
    case SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_DN :
      strcpy(errmsg, "SPX : can't find certif path to claimant (going down)");
      break;
    case SPX_S_CLAIM_TARGET_IN_UNKNOWN_DOMAIN :
      strcpy(errmsg, "SPX : claimant read pubkey for unknown target");
      break;
    case SPX_S_CLAIM_READ_PUB_KEY_ERROR :
      strcpy(errmsg, "SPX : claimant read pubkey returns unknown error");
      break;
    case SPX_S_VERIF_TARGET_IN_UNKNOWN_DOMAIN :
      strcpy(errmsg, "SPX : verifier read pubkey for unknown target");
      break;
    case SPX_S_VERIF_READ_PUB_KEY_ERROR :
      strcpy(errmsg, "SPX : verifier read pubkey returns unknown error");
      break;
    case SPX_S_CLAIM_CERTIFS_DONT_EXIST_IN_CDC :
      strcpy(errmsg, "SPX : verifier certificates don't exist in CDC");
      break;
    case SPX_S_VERIF_CERTIFS_DONT_EXIST_IN_CDC :
      strcpy(errmsg, "SPX : claimant certificates don't exist in CDC");
      break;
    case SPX_S_FWD_CLAIM_UNABLE_TO_ACCESS_CDC :
      strcpy(errmsg, "SPX : on claimant side, fowarded CDC unavailable");
      break;
    case SPX_S_FWD_VERIF_UNABLE_TO_ACCESS_CDC :
      strcpy(errmsg, "SPX : on verifier side, fowarded CDC unavailable");
      break;
    case SPX_S_ACCEPT_WITH_CHALLENGE :
      strcpy(errmsg, "SPX : clocks out of sync, try challenge/response");
      break;
    case SPX_S_FAILURE_WITH_CHALLENGE :
      strcpy(errmsg, "SPX : clocks out of sync, challenge/response failed");
      break;

    default :
      sprintf(errmsg, "SPX : accept context return unknown (%d)", code);
      break;
    }
}
