/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/accept_context.c,v $
 *
 *
 *  MODULE NAME:    accept_context.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

 
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include <pwd.h>
#include <errno.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "random.h"
#include "objid.h"
#include "spxapi_defs.h"

#define CLOCK_SKEW 5*60         /*  5 minutes  */
#define CTX_TIMEOUT (60*60*3)   /*  3 hours    */

extern api_hexdump();
struct type_SPHINX_AuthenticatorInfo *encode_SPHINX_AuthenticatorInfo();
struct type_SPHINX_TicketInfo *encode_SPHINX_TicketInfo();
struct type_SPHINX_LoginTicket *encode_SPHINX_LoginTicket();
struct type_SPHINX_Evidence *encode_SPHINX_Evidence();
struct type_SPHINX_EncryptedKey *encode_SPHINX_EncryptedKey();
struct type_SPHINX_LongPosixTime *encode_SPHINX_LongPosixTime();

int Sphinx_Accept_sec_context(context_handle, verifier_cred,
        ta_verifier_cred, input_token, input_tokenlen,
	chanbinding, chanbinding_len, delegated_cred_handle,
	ret_flags, debugflag)
ContextHandle **context_handle;
VerifierCred  *verifier_cred;
TrustedCred   *ta_verifier_cred;
char          *input_token;
int           input_tokenlen;
char          *chanbinding;
int           chanbinding_len;
ClaimantCred  **delegated_cred_handle;
int           *ret_flags;
int           debugflag;
{
  struct passwd  *pwd;
  TrustedCred    empty_verifier_cred;
  int            asn1len, result, i, j, mutual_flag=0, status, auth_signed_on;
  int            statuscode = SPX_S_ACCEPT_SUCCESS, ret_flags_actual = 0;
  char           ver_ctx_filename[FULLNAME_SZ];
  char           time_string[16], claimant_file[80];
  char           cdc_server[2*ANAME_SZ];
  int            found_in_cache = 0, deleg_flag = 0, encrypted_deskey_len;
  char           *encrypted_deskey, *asn1_buf, tmp_encrypkey_buf[128];
  unsigned char  mac[16];
  DESblock       deskey;
  time_t         when_deskey_expires=0;
  PE             token_pe;
  char  authenticator_type, *authenticator_type_p;
  ClaimantCred    *issu_cred;
  Verifier_ContextCache    verifierctx_cache;
  ContextHandle   *ctx_handle;
  RSAKeyStorage   issuRSAKey;

  struct type_SPHINX_AuthenticationToken    *authtoken;
  struct type_SPHINX_AuthenticatorInfo      *authinfo;
  struct type_SPHINX_Authenticator          *authenticator;


  time_t          time_now = time(0);

  issu_cred = (ClaimantCred *) malloc(sizeof(ClaimantCred));

  bzero(issu_cred,sizeof(ClaimantCred));

  /*  
   * Decode authentication token.
   */

  if (!(token_pe = ssdu2pe(input_token, input_tokenlen, 0, &result))) {
    statuscode = SPX_S_BAD_TOKEN_FORMAT;
    goto finishup;
  }
  if (decode_SPHINX_AuthenticationToken(token_pe,1,NULLIP,NULLVP,&authtoken)==NOTOK) {
    statuscode = SPX_S_BAD_TOKEN_FORMAT;
    goto finishup;
  }

  /*
   * Must be base version, have consistent evidence and a claimant name must be
   * supplied somehow.
   */

  if (authtoken->version) {
    /*
     * Check that token version is 0.0.0
     */
    bzero(mac, sizeof(mac));
    strcpy(mac, qb2str(authtoken->version));
    if ((mac[0] != 0) || (mac[1] != 0) || (mac[2] != 0)) {
      statuscode = SPX_S_UNSUPPORTED_TOKEN; 
      goto finishup;
    }
  }

  if ((!authtoken->userclaimant) || (!authtoken->encryptedkey)) {
    statuscode = SPX_S_UNSUPPORTED_TOKEN;
    goto finishup;
  }

  if(authtoken->userclaimant->userName) {
    strcpy(issu_cred->fullname, rdn_to_str(authtoken->userclaimant->userName));
    pwd = getpwuid(geteuid());
    strcpy(issu_cred->name, pwd->pw_name);
  } else {
    statuscode = SPX_S_NO_NAME_IN_TOKEN;
    goto finishup;
  }

  authenticator_type_p = bitstr2strb(authtoken->authenticator->authenticatorInfo->type, &j);

  authenticator_type = *authenticator_type_p;
  if ((authenticator_type & 0x01) == 0) {
    deleg_flag = 0;
  } else {
    deleg_flag = 1;
    ret_flags_actual = ret_flags_actual | 1;
  }

  if ((authenticator_type & 0x02) == 0)
    mutual_flag = 0;
  else {
    mutual_flag = 1;
    ret_flags_actual = ret_flags_actual | 2;
  }

  *ret_flags = ret_flags_actual;

  if (deleg_flag) { 
    if ((authtoken->userclaimant->evidence->offset != type_SPHINX_Evidence_delegator)&& (authtoken->userclaimant->evidence->un.delegator)) {
      statuscode = SPX_S_WRONG_EVID_IN_TOKEN;
      goto finishup;
    }
  }

  asn1_buf = prim2str(authtoken->encryptedkey->encryptedAuthKey, &asn1len);
  if (!asn1_buf) {
    statuscode = SPX_S_MALLOC_ERROR;
    goto finishup;
  }

  encrypted_deskey = asn1_buf+1;      /* encrypted deskey bits from token */
  encrypted_deskey_len = asn1len-1;

  if (debugflag >= 2) {
    printf("encrypted_deskey from token (len is %d) :\n", encrypted_deskey_len);
    api_hexdump(encrypted_deskey, encrypted_deskey_len);
  }

  /*  read verifier cache for claimant  */

  strcpy(ver_ctx_filename,
	 ver_ctx_string(verifier_cred->name,issu_cred->name,issu_cred->fullname));

  if (ver_ctx_init(ver_ctx_filename, W_TKT_FIL) == ASUCCESS) {
    if (ver_ctx_get_context(issu_cred->fullname,&verifierctx_cache) == ASUCCESS)
      found_in_cache = 1;
  }
  ver_ctx_close();

  /*  if cache exists, check if it is valid  */

  if (found_in_cache) {
    if (encrypted_deskey_len == verifierctx_cache.encryptedkey_len) {
      if (bcmp(&verifierctx_cache.charbuf[verifierctx_cache.claimant_fn_len], encrypted_deskey, encrypted_deskey_len) != 0)
	found_in_cache = 0;
    } else found_in_cache = 0;

    if (found_in_cache) {
      if (verifierctx_cache.after < time_now-CLOCK_SKEW)
	found_in_cache = 0;
      if (verifierctx_cache.before > time_now+CLOCK_SKEW)
	found_in_cache = 0;
      if (verifierctx_cache.deleg_flag != deleg_flag)
	found_in_cache = 0;
      bcopy(verifierctx_cache.deskey.bytes, deskey.bytes, DESKEY_SZ);
    }
  }
  if (!found_in_cache) {
    verifierctx_cache.before = time_now;
    verifierctx_cache.after = time_now + CTX_TIMEOUT;
    verifierctx_cache.deleg_flag = deleg_flag;
    verifierctx_cache.claimant_fn_len = strlen(issu_cred->fullname);
    verifierctx_cache.encryptedkey_len = encrypted_deskey_len;
    strcpy(verifierctx_cache.charbuf, issu_cred->fullname);
    bcopy(encrypted_deskey, &verifierctx_cache.charbuf[verifierctx_cache.claimant_fn_len], encrypted_deskey_len);
  }

  if (!found_in_cache) {

    status = AcceptAuthenticationKey(verifier_cred->privRSAKey, &deskey, 
                        encrypted_deskey, encrypted_deskey_len, &when_deskey_expires);

    if (status <= 0) {
      free(asn1_buf);
      if (status != -2) {
	syslog(LOG_INFO, "DES key encrypted with wrong verifier pubkey (%d)", status);
	statuscode = SPX_S_ERROR_EXTRACTING_DESKEY;
	goto finishup; 
      } else {
	syslog(LOG_INFO, "authenticator is askew somehow ... proceed for now");
	statuscode = SPX_S_AUTHENTICATOR_ASKEW;
      }
    }
    if (when_deskey_expires < time_now-CLOCK_SKEW) {
        syslog(LOG_INFO, "when_deskey_expires is %d, time_now is %d, clock_skew is %d", when_deskey_expires, time_now, CLOCK_SKEW);
        free(asn1_buf);
        statuscode = SPX_S_DESKEY_EXPIRED;
	goto finishup;
    }
  }
     
  /*
   * Have what we think is the DES authenticating key.
   * Now check if it computed the MAC on the authenticator.
   */

  authenticator_type_p = (char *)
    bitstr2strb(authtoken->authenticator->authenticatorInfo->type, &j);

  authenticator_type = *authenticator_type_p;
  if ((authenticator_type & 0x01) == 0)  deleg_flag = 0;
  else deleg_flag = 1;
  if ((authenticator_type & 0x02) == 0)  mutual_flag = 0;
  else mutual_flag = 1;

  if ((authinfo = (struct type_SPHINX_AuthenticatorInfo *)
       malloc(sizeof(struct type_SPHINX_AuthenticatorInfo))) == NULL) {
    statuscode = SPX_S_MALLOC_ERROR;
    goto finishup;
  }
  authinfo->type = strb2bitstr(authenticator_type_p, 8, PE_CLASS_UNIV, PE_PRIM_BITS);
  if ((authinfo->whenSigned = (struct type_SPHINX_LongPosixTime *)
       malloc(sizeof(struct type_SPHINX_LongPosixTime))) == NULL) {
    statuscode = SPX_S_MALLOC_ERROR;
    goto finishup;
  }
  auth_signed_on = authtoken->authenticator->authenticatorInfo->whenSigned->seconds;
  authinfo->whenSigned->seconds = auth_signed_on;

  if (auth_signed_on > time_now + CLOCK_SKEW) {
    syslog(LOG_INFO, "authenticator is too old ... proceed for now");
    statuscode = SPX_S_AUTHENTICATOR_ASKEW;
  }

  if (auth_signed_on < time_now - CLOCK_SKEW) {
    syslog(LOG_INFO, "authenticator is too early ... proceed for now");
    statuscode = SPX_S_AUTHENTICATOR_ASKEW;
  }

  authinfo->whenSigned->nanoseconds =
    authtoken->authenticator->authenticatorInfo->whenSigned->nanoseconds;
  authinfo->channelId = str2qb(chanbinding, chanbinding_len, 1);

  desmac_sign_aux(authinfo, encode_SPHINX_AuthenticatorInfo,
		  &deskey, &authenticator);

  bcopy(bitstr2strb(authenticator->signature, &j), mac, 8);
   
  status = 0;
  if (bcmp(bitstr2strb(authtoken->authenticator->signature, &j), mac, 8) == 0)
    status = 1;

  if (status == 0) {
    free(asn1_buf);
    statuscode = SPX_S_INVALID_AUTHENTICATOR;
    goto finishup;
  }

  /*
   * Check that this isn't a duplicate authenticator.
   */
   
  issu_cred->before =
    authtoken->userclaimant->userTicket->tktinfo->validity->notBefore->parm;
  issu_cred->after =
    authtoken->userclaimant->userTicket->tktinfo->validity->notAfter->parm;
  if (issu_cred->after < time_now-CLOCK_SKEW)  {
    statuscode = SPX_S_TICKET_EXPIRED;
    goto finishup;
  }
  if (issu_cred->before > time_now+CLOCK_SKEW) {
    statuscode = SPX_S_TICKET_NOT_VALID_YET;
    goto finishup;
  }
  /*
   * Before making any remote accesses, check that the delegating public key
   * in the ticket verifiess the evidence.
   */

  issu_cred->s_privRSAKey =
    (RSAKeyStorage *) calloc(sizeof(RSAKeyStorage), 1);
  status = data_from_ticket(authtoken->userclaimant->userTicket->tktinfo,
	         issu_cred->s_privRSAKey, issu_cred->uuid, &issu_cred->uidlen);
  if(!status) {
    statuscode = SPX_S_ILLEGAL_TICKET;
    goto finishup;
  }
  issu_cred->bitlen = ((issu_cred->s_privRSAKey->nl - 1) * 2) * 8;

  if (deleg_flag) {
    asn1_buf = 
      prim2str(authtoken->userclaimant->evidence->un.delegator->encryptedPrivKey,
	       &asn1len);
    if (!status) {
      statuscode = SPX_S_MALLOC_ERROR;
      goto finishup;
    }
    bcopy(asn1_buf+1, tmp_encrypkey_buf, asn1len-1);
    status = recover_privateP(&deskey, tmp_encrypkey_buf, asn1len-1, issu_cred->s_privRSAKey);
    free(asn1_buf);
    if (!status) {
      statuscode = SPX_S_DELEGATOR_EVID_FAILED;
      goto finishup;
    }
  } else {
    if (!found_in_cache) {
      status = rsamd2_verify_signature (authtoken->encryptedkey, 
	        authtoken->userclaimant->evidence->un.sharedKeyTicketSignature,
		encode_SPHINX_EncryptedKey, issu_cred->s_privRSAKey);
      if (!status) {
	statuscode = SPX_S_DELEGATOR_EVID_FAILED;
	goto finishup;
      }
    }
  }
  if (!found_in_cache) {
    /*
     * Now verify the ticket.
     */
    /*  
     * Get the claimant public key from the CDC
     */
    if ((i = read_pub_key(issu_cred->fullname, &issuRSAKey, 
			  ta_verifier_cred, cdc_server, 0)) <= 0) {
      switch(i) {
        case -1 :
                  statuscode = SPX_S_VERIF_UNABLE_TO_ACCESS_CDC;
                  break;
        case -2 :
                  statuscode = SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_DN;
                  break;
        case -3 :
                  statuscode = SPX_S_VERIF_CANT_FIND_CERTIF_PATH_GOING_UP;
                  break;
        case -4 :
                  statuscode = SPX_S_VERIF_TARGET_IN_UNKNOWN_DOMAIN;
                  break;
        case -5 :
                  statuscode = SPX_S_VERIF_CERTIFS_DONT_EXIST_IN_CDC;
                  break;
        default :
                  statuscode = SPX_S_VERIF_READ_PUB_KEY_ERROR;
                  break;
      }
      goto finishup;
    }
    /*  
     * Verify signature on ticket
     */
    status = rsamd2_verify_aux(authtoken->userclaimant->userTicket,
			       encode_SPHINX_TicketInfo, &issuRSAKey);
    if (status == 0) {
      /*
       * We want to log this.
       */
      statuscode = SPX_S_VERIFY_TICKET_FAILED;
      goto finishup;
    }

    /*
     * All good.  Build new conterxt and credentials.
     */
  } else {
    /*
     * Update authenticator cache
     */
/*
    free(asn1_buf);
*/
  }

  /*  
   * Save context info in local cache  
   */
  
  if (!found_in_cache) {
    if (ver_ctx_init(ver_ctx_filename, W_TKT_FIL) != ASUCCESS) {
      if ((i = in_ver_ctx(ver_ctx_filename)) != ASUCCESS) {
	syslog(LOG_INFO, "can't establish verifier context cache - in_ver_ctx");
	statuscode = SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED;
	goto finishup;
      }
      if (ver_ctx_init(ver_ctx_filename, W_TKT_FIL) != ASUCCESS) {
	syslog(LOG_INFO, "can't establish verifier context cache - ver_ctx_init");
	statuscode = SPX_S_CANT_ESTAB_DELEGATED_CLAIM_CRED;
	goto finishup;
      }
    }
    bcopy(deskey.bytes, verifierctx_cache.deskey.bytes, DESKEY_SZ);

    ver_ctx_add_context(&verifierctx_cache, issu_cred->fullname);
    ver_ctx_close();
  }

  /*  save delegating credential handle and deleg claimant filename  */

  *delegated_cred_handle = issu_cred;

  bzero(claimant_file, sizeof(claimant_file));
  sprintf(time_string, "%d-%x", getpid(), (time_now & 0x7fff));
  strcpy(claimant_file, "_");
  strcat(claimant_file, time_string);

  status = ber_encode(authtoken->userclaimant->userTicket,
		      encode_SPHINX_LoginTicket,
		      PS_LEN_LONG, &asn1_buf, &asn1len);
  if (status == NOTOK) {
    statuscode = SPX_S_MALLOC_ERROR;
    goto finishup;
  }
  bcopy(asn1_buf, issu_cred->userticket, asn1len);
  free(asn1_buf);
  issu_cred->userticket_len = asn1len;
  issu_cred->deleg_flag = deleg_flag;

finishup:
  /*  create context handle with deskey and mutual response  */

  ctx_handle = (ContextHandle *) malloc(sizeof(ContextHandle));
  *context_handle = ctx_handle;
  bcopy(deskey.bytes, (char *) ctx_handle->deskey.bytes, sizeof(deskey.bytes));
  strcpy(ctx_handle->issuer_ln, issu_cred->name);
  strcpy(ctx_handle->issuer_fn, issu_cred->fullname);
  strcpy(ctx_handle->claimant_file, claimant_file);
  ctx_handle->deleg_flag = issu_cred->deleg_flag;
  if (mutual_flag) {
    DESblock mac;
    struct type_SPHINX_LongPosixTime *mutual_time;
    
    mutual_time = authtoken->authenticator->authenticatorInfo->whenSigned ;
    mutual_time->seconds += 1;
    mutual_time->nanoseconds = 0;
    status = ber_encode(mutual_time, encode_SPHINX_LongPosixTime, PS_LEN_LONG,
                                        &asn1_buf, &asn1len);
    ctx_handle->mutual_resp[0] = 0x80 ; /* context 0 */
    ctx_handle->mutual_resp[1] = 6;
    DES_X9_MAC(&deskey, asn1_buf, asn1len, &mac);
    bcopy(&mac, &ctx_handle->mutual_resp[2], 6);
    ctx_handle->mutual_len = 8;
    if (statuscode == SPX_S_AUTHENTICATOR_ASKEW)
      statuscode = SPX_S_ACCEPT_WITH_CHALLENGE;
  } else {
    ctx_handle->mutual_len = 0;
    bzero(ctx_handle->mutual_resp, MUTUAL_RESP_SZ);
  }
  return(statuscode);
}


api_error(fmt, a1, a2, a3)
        char *fmt;
        int a1, a2, a3;
{
        char buf[BUFSIZ];

        buf[0] = 1;
        (void) sprintf(buf+1, fmt, a1, a2, a3);
        (void) write(2, buf, strlen(buf));
}
