#ifndef lint
static char sccsid[] = "@(#)ctermd_session.c	4.7	3/22/90";
#endif

/*
 * Program dlogind,  Module ctermd_session.c
 *
 * Copyright (C) 1984, 1985, 1986 by 
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice. This software or  any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of  the  software  is  hereby
 * transferred.
 *
 * The information in this software is subject to change without  notice
 * and  should  not be  construed  as  a commitment by Digital Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use or  reliability  of its
 * software on equipment which is not supplied by Digital.
 *
 *
 * MODULE DESCRIPTION:
 *
 * Digital terminal software architecture command terminal mode
 * Session control.
 *
 *
 * Networks & Communications Software Engineering
 *
 * IDENT HISTORY:
 *
 * 1.00 15-Oct-84
 *      DECnet-ULTRIX   V1.0
 * 2.00 15-Oct-86
 *	DECnet-ULTRIX	V2.0
 *
 * Revision 1.17 pnh
 * 	DECnet-Internet gateway.  Addition of code to prompt for login name
 *	or nodename, which causes an execl() of telnet.  Note the use of the
 *	environmental variable USERNAME to pass on the login name entered by
 * 	the user to the login program, and the ".gateway" file in the user's
 *	home directory which forces an explicit login prompt in the event that
 *	the user has a valid proxy login.  This gives the user the chance to
 *	make use of the gateway feature.
 * Revision 1.18 pnh
 *	Use environ instead of arge.
 * Revision 1.20 pnh
 *	Exit on EOF when prompting for login name (or node spec).  Consistent
 *	use of fatalperror().


 * Revision 1.21 pnh
 *	Use check_gateway_access() to verify that gateway is available.
 * Revision 1.22 pnh
 *	Add gateway support for /usr/adm/wtmp.
 * Revision 1.23 pnh
 *	Add syslog before chmod() to trace problem with directory permission
 *	changes.
 * Revision 1.25 pnh
 *	Add TIOCMASTER ioctl to arbitrate between master and slave access of
 *	common terminal structures (particularly sgttyb flags).  Remove 
 * 	syslog()'s for chmod() problem tracing.
 * Revision 1.26 pnh
 * 	Change check_gateway_access() to dnet_gate_access().
 *
 * 3/17/88 Chung Wong
 *	Added codes to handled TIOCSTI.
 */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <signal.h>
#include <syslog.h>
#include <sgtty.h>
#include <pwd.h>
#include <sysexits.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <netdnet/dn.h>
#include <netdnet/dnetdb.h>

#include <netdnet/decnet_types.h>
#include "../common_params.h"
#include "../found_protocol.h"
#include "../cterm_protocol.h"
#include "ctermd_var.h"
#include <utmp.h>

struct	utmp wtmp;
char	wtmpf[]	= "/usr/adm/wtmp";
char	utmpf[] = "/etc/utmp";
#define SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define SCMPN(a, b)	strncmp(a, b, sizeof(a))

extern char **environ;
extern int rsxhack, sock, pty, disconnected, scc, maxmsgsize, maxwrite;
extern int dec,trace,vmshack,opsys,reading,donot_discard;
extern FILE *traces;
extern char revision[], src_host[], src_obj[], *data;
extern caddr_t getbuffer();
extern int errno;
extern struct sgttyb p_sgttyb;
extern struct tchars p_tchars;
extern int msgspeed;

int	child;
int	lcmask;
int	zero;
char	*line;
int	done(), catchild();

/*
 *		 	       e n t e r m o d e
 *
 * Enter a new mode for the controlling terminal.
 *
 * Outputs:		None.
 *
 * Inputs:
 *	mtype		= mode type.
 *	mid		= mode id.
 */
/*ARGSUSED*/
entermode(mtype,mid)
int mtype,mid;
{
    char c, loginbuf[100], *loginname = loginbuf;
    char *login, *ctime(), *getenv(), *index();
    int i, ttyp, on = 1;
    FILE *fopen();
    char buf[100];
    int ty;

    strcpy(src_host, getenv("REMNODE"));
    strcpy(src_obj, getenv("REMUSER"));
    syslog(LOG_INFO, "connect from %s::%s", src_host, src_obj);
    ty = open("/dev/tty",O_RDWR);
    ioctl(ty, TIOCNOTTY, 0);
    close(ty);

    for (c = 'p'; c <= 'z'; c++) 
    {
	struct stat stb;

	line = "/dev/ptyXX";
	line[strlen("/dev/pty")] = c;
	line[strlen("/dev/ptyp")] = '0';
	if (stat(line, &stb) < 0)
	    break;
	for (i = 0; i < 16; i++) 
	{
	    line[strlen("/dev/ptyp")] = "0123456789abcdef"[i];
	    pty = open(line, 2);
	    if (pty> 0)
		goto gotpty;
	}
    }
    fatal(EX_UNAVAILABLE, "All pty's are in use. line:%s", line);
    /*NOTREACHED*/

gotpty:
    line[strlen("/dev/")] = 't';
    ttyp = open(line, 2);
    if (ttyp < 0)
	fatalperror(EX_OSERR, line, errno);
    ioctl(ttyp, TIOCGETP, &p_sgttyb);
    p_sgttyb.sg_flags = CRMOD|ECHO|ANYP|XTABS;
    p_sgttyb.sg_ispeed = p_sgttyb.sg_ospeed = msgspeed;
    ioctl(ttyp, TIOCSETN, &p_sgttyb);
    ioctl(pty, FIONBIO, &on);
    ioctl(pty, TIOCPKT, &on);
    signal(SIGHUP, SIG_IGN);
    signal(SIGTSTP, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGTTOU, SIG_IGN);
    signal(SIGCHLD, catchild);
    signal(SIGPIPE, SIG_IGN);

    if ((child = fork()) < 0)
	fatalperror(EX_OSERR, "", errno);
    if (child) 						/* In parent */
    {			
	runsession();
	done();
    }
    else 
    {							/* In child  */
	int DECnetlogin = 1;
	char *cp, *p;

	close(pty); 
	dup2(ttyp,0);
	dup2(ttyp,1);
	dup2(ttyp,2);
	close(ttyp);

	login = "/usr/bin/dnet_login";
	if (access(login, 1))
	    login = "/bin/login";
	print_init_msg();

	if ( ((cp = getenv("NETWORK")) == 0) || 
	      (strcmp(cp, "DECnet") != 0) )
	    DECnetlogin = 0; 
	if ( ((cp = getenv("ACCESS")) == 0) ||
	      (strcmp(cp,"DEFAULT") == 0) )
	    DECnetlogin = 0;
	if ( (cp = getenv("USER")) == 0)
	    DECnetlogin = 0;

	if ( DECnetlogin )
	{ 
	    struct stat statbuf; 
	    struct passwd *pwd; 
	    char fnbuf[32],*fn=fnbuf;
	    char username[32], *user=username;

	    setpwent();
	    strcpy(user,getenv("USER"));
	    if ((pwd = getpwnam(user)) == NULL)
		goto prompt;
	    strcpy(fn,pwd->pw_dir);
	    strcat(fn,"/.no_proxy_login");
	    /*
	     * This is a successful DECnet proxy login.  We should not do
	     * any further prompting for user name etc. unless users want
	     * us to.  They will have indicated this by touching the .gateway
	     * file in this home directory.  If this file does not exist, 
	     * let's start the login program immediately.  Otherwise, users
	     * want the option of using the node as a gateway.
	     */
	    if (stat(fn,&statbuf) != NULL)
	    {
		execl(login,"login","-h", src_host,0);
		fatalperror(EX_OSERR, "login",errno);
		/*NOTREACHED*/
	    }
	}
prompt:
	*loginname = '\0' ;

	ioctl(0,TIOCLSET,&zero);
	lcmask = (LPRTERA | LCRTBS | LCRTERA);
	ioctl(0,TIOCLSET, &lcmask);
	ioctl(0,FIONBIO,&zero);
	ioctl(0, FIOASYNC, &zero);

	while (strlen(loginname) == 0)
	{   
            printf("login: ");	/* Determine local or remote host */
	    if (gets(loginname) == NULL )   /* On EOF exit	  */
	    {
		ty = open("/dev/tty", O_RDWR);
		ioctl(ty,TIOCNOTTY,0);
		close(ty);
		exit(EX_USAGE);
	    }
	}
	if ( (p=index(loginname,'!')) || (p=index(loginname,':')) ) 
	{
	    int f;
	    int pmrmode;
	    struct stat statbuf;

		ioctl(0, TIOCGETP, &p_sgttyb);
		p_sgttyb.sg_flags &= ~XTABS;
		ioctl(0, TIOCSETN, &p_sgttyb);

	    pmrmode = p[0] == ':'  &&  p[1] == ':';

	    *p = '\0' ;
	    if ( !pmrmode && dnet_gate_access() )
	    {
		syslog(LOG_WARNING, "denied gateway access to %s from %s::%s", loginname, src_host, src_obj);
	   	printf("\ndlogind: Internet Gateway Access not allowed\n");
		ty = open("/dev/tty", O_RDWR);
		ioctl(ty,TIOCNOTTY,0);
		close(ty);
		exit(EX_UNAVAILABLE);
	    }

	    if( pmrmode && stat("/usr/lib/dnet/PMRenabled", &statbuf) < 0 ) {
		printf("\ndlogind: PMR Access not allowed\n");
		ty = open("/dev/tty", O_RDWR);
		ioctl(ty,TIOCNOTTY,0);
		close(ty);
		exit(EX_UNAVAILABLE);
	    }


	    if ( (f = open(wtmpf,O_WRONLY|O_APPEND)) >= 0 )
	    {
		SCPYN(wtmp.ut_line,line + 5);
		if( pmrmode )
		    SCPYN(wtmp.ut_name, "PMRdnet");
		else
		    SCPYN(wtmp.ut_name, "gateway");
		SCPYN(wtmp.ut_host,src_host);
		wtmp.ut_time = time(0);
		(void)write(f, (char *)&wtmp,sizeof(struct utmp));
		(void)close(f);
	    }
	    if( pmrmode ) {
		syslog(LOG_INFO, "connect to node %s via PMR", loginname);
		execl("/usr/ucb/dlogin", "dlogin", loginname, "-e", 0);
	    }
	    else {
		syslog(LOG_INFO, "connect to node %s", loginname);
		execl("/usr/ucb/telnet","telnet",loginname,0);
	    }
	    if (errno == ENOENT)
		fatal(EX_UNAVAILABLE, "gateway access is not available");
	    else
		if( pmrmode )
		    fatalperror(EX_OSERR, "dlogin", errno);
		else
		    fatalperror(EX_OSERR, "telnet", errno);
	}
	else 
	{
	    char *env[20];		/* For new environmental array */
	    char *arg[4];
	    char **p, *malloc();
	    int i = 0;
	
	    for (p = environ;*p;)	/* Copy the existing environment */
	    {
		if (strncmp(*p,"USER=",5) == 0)
		{
		    p++;
		    continue;
		}
		env[i++] = *p++;
	    }

	    if ( (env[i] = malloc(strlen("USERNAME=")+strlen(loginname))) == 0)
	    {
		fatalperror(EX_SOFTWARE, "dlogind", errno);
	    }
	    strcpy(env[i],"USERNAME=");
	    strcat(env[i],loginname);
	    env[++i] = 0;
	    arg[0] = "login";
	    arg[1] = "-h";
	    arg[2] = src_host;
	    arg[3] = 0;

	    /*ckw
            if (traces)
	    {
	        char **ep;

		fprintf(traces,"Environment before login exec:\n");
		ep = env;
		while (*ep)
		    fprintf(traces,"%s\n",*ep++);
	    }
	    ckw */

	    execve(login,arg,env);
	    fatalperror(EX_OSERR, "login",errno);
	    /*NOTREACHED*/
	}
	/*NOTREACHED*/
    }
}

/*
 *			      r u n s e s s i o n
 *
 * Execute the current session until the link is disconnected.
 *
 * Outputs:		None.
 */
runsession()
{
    int cc, pcc, wasecho, pid;
/*  union { 
	u_short flagval; 
	struct cmsg_writeflags msgflags;
    } flags;
 */
    register caddr_t msgptr,initptr;

    pid = getpid();
    
    /* Force VMS to send a ^C as a ^C instead of a ^Y.  For some    */
    /* unknown reason we have to send this at the very beginning of */
    /* session & before every start read in order for it to work.   */
    
    if ((opsys == OS_VMS) && vmshack || opsys == OS_RSX11MP) {
	initptr = msgptr = getbuffer();
	PUT16(msgptr, CMSG_CHRS);
	PUT8(msgptr, CHARACTER_ATTRIBUTES);
	PUT8(msgptr, 2);
	PUT8(msgptr, 003);	/* bind ^C to ^C */
	PUT8(msgptr, 0177);
	PUT8(msgptr, 0011);
	PUT8(msgptr, CHARACTER_ATTRIBUTES);
	PUT8(msgptr, 2);
	PUT8(msgptr, 030);	/* bind ^X to ^X */
	PUT8(msgptr, 0177);	/* change all characteristics */
	PUT8(msgptr, 0043);
	if (opsys == OS_VMS) {
#ifdef REMOTE_CTRLO
	    PUT8(msgptr, CHARACTER_ATTRIBUTES);
	    PUT8(msgptr, 2);
	    PUT8(msgptr, 017);
	    PUT8(msgptr, 0177);
	    PUT8(msgptr, 0003);
#endif
   	    PUT8(msgptr, CHARACTER_ATTRIBUTES);
	    PUT8(msgptr, 2);
	    PUT8(msgptr, 031);	/* bind ^Y to ^Y */
	    PUT8(msgptr, 0177);	/* change all characteristics */
	    PUT8(msgptr, 0003);
	}
	sendmessage(msgptr - initptr, FLUSH);
	}
   
   /*ckw - turn on VMS pasthru mode: if (opsys == OS_VMS) vms_sense();	ckw*/

    while (disconnected == 0) 
    {
	int ibits = (1<<pty), obits = 0;
		
	if (scc)
	    obits |= (1<<pty);
	else
	    ibits |= (1<<sock);


	select(16, &ibits, &obits, 0, 0);

	if (ibits & (1<<sock))
	    rcvmessage();

	if (ibits & (1<<pty)) 
	{
	    msgptr = initptr = getbuffer();
	    PUT8(msgptr, CMSG_WRITE);
/* flags.msgflags.cwf_lock = 2;
 * flags.msgflags.cwf_disc = 1/0; (after out-of-band / otherwise)
 * flags.msgflags.cwf_bom = TRUE;
 * flags.msgflags.cwf_eom = TRUE;
 * flags.msgflags.cwf_trans = TRUE;
 * PUT16(msgptr, flags.flagval);
 */
	    if (rsxhack) 
	    {
		PUT16(msgptr, 0x72);
		PUT8(msgptr, 1);
	    } 
	    else 
	    {
		if (donot_discard) {
		    PUT16(msgptr, 0x83A);
		} else {
		    PUT16(msgptr, 0x832);
		}
		PUT8(msgptr, 0);
	    }
	    pcc = read(pty, msgptr, maxwrite);

	    if (pcc < 0 && errno == EWOULDBLOCK)
		pcc = 0;
	    else 
		if (pcc <= 0)
		    disconnected++;
	    else if (*msgptr == 0)
	    {
		    rsxhack = 0;
		    sendmessage(msgptr - initptr + pcc, FLUSH);
		    donot_discard = 0;
	    }
	    else 
	    {
		pcc = 0;
		if (!reading) check_characteristics();
		ioctl(pty,TIOCGETP,&p_sgttyb);
		ioctl(pty,TIOCGETC,&p_tchars);

	    }
	} /* if ibits */

	if ((obits & (1<<pty)) && scc > 0) 
	{
	    int level;
	    int on = 1, off = 0;
	    
	    level = getpriority(PRIO_PROCESS,pid);
	    setpriority(PRIO_PROCESS, pid, -20);
	    ioctl(pty, TIOCMASTER, &on);
	    
	    ioctl(pty, TIOCGETP, &p_sgttyb);
    	    wasecho = dec ? ( p_sgttyb.sg_flags & ECHO ) : 0 ;

	    /*ckw if (wasecho) */
	    /*ckw: if underflow & echo, let the pty echo in case of TIOCSTI */
	    if (wasecho && (scc!=1 || data[0]!=0x7f))
	    {
		p_sgttyb.sg_flags &= ~ECHO;
		ioctl(pty, TIOCSETN, &p_sgttyb); 
	    }
	    cc = write(pty, data, scc);
	    if (wasecho) 
	    {
		p_sgttyb.sg_flags |= ECHO;
		ioctl(pty, TIOCSETN, &p_sgttyb); 
	    }
    	    ioctl(pty, TIOCMASTER, &off);
	    setpriority(PRIO_PROCESS,pid,level);

	    if (cc > 0) 
	    {
		scc -= cc;
		data += cc;
	    }
	} /* if obits and */
    }
}

done()
{
    /*ckw - reset VMS pasthru mode: if (opsys == OS_VMS) vms_reset();	*/

    disconnected++ ; 
    unbind(FREA_UNBIND); 
    if (trace) 
	fclose(traces); 
    close(sock); 
    close(pty);
    rmut();
    vhangup();
    exit(EX_OK);
    kill(getpid(), SIGKILL);
}

catchild()
{
    union wait status;
    int pid;

again:
    if ( (pid = wait3(&status, WNOHANG, 0)) == 0)
	return;

    /*
     * If the child (reader) dies, just quit 
     */ 
    if (pid < 0 || pid == child && !WIFSTOPPED(status)) 
    {
        if (disconnected) return;
	done();
    }
    goto again;
}

/*VARARGS*/
fatal(status, f, a1, a2, a3)
int status;
char *f;
{
    int ty;

    fprintf(stderr, "dlogind: ");
    fprintf(stderr, f, a1, a2, a3);
    fprintf(stderr, "\n");
    ty = open("/dev/tty",O_RDWR);
    ioctl(ty, TIOCNOTTY, 0);
    close(ty);
    exit(status);
}

fatalperror(status, msg, errno)
int status;
char *msg;
int errno;
{
    char buf[BUFSIZ];
    extern char *sys_errlist[];

    syslog(LOG_INFO, "%s: %m", msg, errno);
/*VARARGS*/
    fatal(status, "%s: %s", msg, sys_errlist[errno]);
}


rmut()
{
    register f;
/*  int found = 0; */
    char buf[100];

    if (line == 0)
	return;
    f = open(utmpf, 2);
    if (f >= 0) 
    {
	while(read(f, (char *)&wtmp, sizeof(wtmp)) == sizeof(wtmp)) 
	{
	    if (SCMPN(wtmp.ut_line, line+5) || wtmp.ut_name[0]==0)
		continue;
	    lseek(f, -(long)sizeof(wtmp), 1);
	    SCPYN(wtmp.ut_name, "");
	    SCPYN(wtmp.ut_host, "");
	    time(&wtmp.ut_time);
	    write(f, (char *)&wtmp, sizeof(wtmp));
	/*  found++; */
	}
	close(f);
    }
    f = open(wtmpf, O_WRONLY | O_APPEND, 0);
    if (f >= 0) 
    {
        SCPYN(wtmp.ut_line, line+5);
	SCPYN(wtmp.ut_name, "");

	SCPYN(wtmp.ut_host, "");
	time(&wtmp.ut_time);
/* 	lseek(f, (long)0, 2); */
	write(f, (char *)&wtmp, sizeof(wtmp));
	close(f);
    }

    syslog(LOG_INFO, "disconnect from %s::%s", src_host, src_obj);
    
    chmod(line, 0666);
    chown(line, 0, 0);
    line[strlen("/dev/")] = 'p';
    chmod(line, 0666);
    chown(line, 0, 0);

}
