/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/admin/RCS/createkey.c,v $
 *
 *
 *  MODULE NAME:    createkey.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <strings.h>
#include "BigNum.h"
#include "BigZ.h"
#include "BigRSA.h"

#include <sys/time.h>
#ifdef VMS
#include  <types.h>
#else
#include <sys/types.h>
#include <sys/timeb.h>
#endif
#include  <ctype.h>

#include "cdc.h"
#include "random.h"
#include "bigkeygen.h"
#include "bigrsacode.h"

#ifndef CLK_TCK
#define CLK_TCK 60
#endif

#define DEFAULT_KEY_BITLEN  512
/*
#define MAX_KEY_BITLEN  MaxModulusBits
*/
#define MAX_KEY_BITLEN  1024
#define MIN_KEY_BITLEN  384

extern int optind, opterr;
extern char *optarg;
extern int bigkeygenPrintStatistics;
char *progname, *rindex();

main(argc,argv)
int     argc;
char    **argv;
{
    static RSAKeyStorage keys;
    time_t mark , tenths;
    struct timeb  start_time, end_time ;
    int i=1 ,j, cakey = 0, uid_len, primeflag = 0, nflag = 0, wflag = 0;
    int sflag = 0;
    int c, bitlen = DEFAULT_KEY_BITLEN, errflg = 0, verbose = 0;
    char usernameBuf[80], privateBuf[80], uidBuf[32], uidArg[50],
            uidPrintBuf[50], fullnameBuf[80], passwordBuf[40];
    char *newuidBuf=NULL, *cp, primesfile[32];

  opterr = 0;
   while ((c=getopt(argc, argv, "vVak:u:p:n:w:s")) != EOF)
    switch(c) {
      case 'w' :
        strcpy(passwordBuf,optarg);
	wflag = 1;
        break;
      case 'n' :
        /*
         * fullname to be used in key file
         */
        strcpy(fullnameBuf,optarg);
	nflag = 1;
        break;
      case 's' :
	/*
	 *  create unencrypted private/public key file
	 */
        sflag = 1;
        break;
      case 'a' :
	/*
	 * certification authority keys
	 */
        cakey = 1;
        break;
      case 'k' :
	/*
	 * bit length (key size)
	 */
        i = atoi(optarg);
        if ((i < MIN_KEY_BITLEN) || (i > MAX_KEY_BITLEN)) {
	  if (i < MIN_KEY_BITLEN)  i = MIN_KEY_BITLEN;
	  if (i > MAX_KEY_BITLEN)  i = MAX_KEY_BITLEN;
	  printf("key size out of range [%d ... %d], set to %d\n", 
                MIN_KEY_BITLEN,MAX_KEY_BITLEN,i);
	}
	bitlen = i;
        break;
      case 'u' :
	/*
	 * uid for principal
	 */
        newuidBuf = optarg;
        break;
      case 'p' :
	/*
	 *  prime file input to key generation
	 */
        strcpy(primesfile,optarg);
	primeflag = 1;
        break;
      case 'v' :
      case 'V' :
	/*
	 * verbose mode
	 */
	verbose = 1;
	break;
      case '?' :
	errflg++;
      default:
        break;
    }
  
  if (argv[optind] == NULL)  errflg++;
  else strcpy(usernameBuf, argv[optind++]);
  if (optind != argc)  errflg++;
  if (errflg) {
    progname = (cp = rindex(argv[0], '/')) ? cp + 1 : argv[0];
    printf("Usage: %s [-avs] [-k key_size] [-u uuid] [-p file] [-n fullname] name\n", progname);
    printf("\t-k       key size (default 512)\n");
    printf("\t-u       uuid (default new uuid is generated)\n");
    printf("\t-n       real name for principal (default prompts for fullname)\n");
    printf("\t-a       principal is a Certification Authority\n");
    printf("\t-p       prime files to be used in key generation\n");
    printf("\t-s       create unencrypted private/public key file\n");
    printf("\t-v       verbose mode\n");
    exit(-1);
  }

  if (newuidBuf == NULL) {
	generate_unique_identifier(uidBuf);
        uid_len = 16;
    } 
    else {
        strcpy(uidArg, newuidBuf);
	for(j=0;j<strlen(uidArg);j++)if(!isxdigit(uidArg[j])) {
	        printf("\nWarning:  uid contains non-hex digit.");
	        break;
                };
        if ((uid_len = sreadhex (uidBuf,uidArg,sizeof(uidBuf))) == sizeof(uidBuf))
                printf("\nWarning: truncation error reading uid.");
        }

  strcpy(privateBuf, usernameBuf);
  strcat(privateBuf, "_privkey");


  if (primeflag) {
        char p[255], q[255];
        int pl, ql;
        FILE *pf;
        bzero(p, sizeof(p));
        bzero(q, sizeof(q));
        if(verbose)
	  printf("\nAttempting to read primes from %s.\n", primesfile);
        if ((pf = fopen(primesfile, "r")) == NULL) {
                printf("\nCan't open %s for reading in primes.\n", primesfile);
                exit(-1);
            }
        pl=freadhex(p,0,pf);
        if (fgetc(pf)==EOF) {
                printf("\nUnexpected end of file reading %s\n", primesfile);
                exit(-1);
        }
        if (verbose) {
                printf("\nprime p read (%d characters):", pl);
                dumphex(p,pl);
        }
        ql=freadhex(q,0,pf);
        if (verbose) {
                printf("\nprime q read (%d characters):", ql);
                dumphex(q,ql);
        }
        if (KeyFromPQ(p,pl,q,ql,&keys)==0) {
                printf("\nError reading prime numbers.\n");
                exit(-1);
        }
  }
  else {
    bitlen = bitlen/2;
  
    if (verbose) {
      printf("Creating (approximately) a %d bit key for '%s'",2*bitlen,usernameBuf);
      if (cakey)  printf(", (certification authority)");
      sdumphex(uidBuf,uid_len,uidPrintBuf);
      printf("\nuid is %s\n",uidPrintBuf);
    }

    initrandom();

    mark = clock();
    ftime (&start_time);

    if (verbose) bigkeygenPrintStatistics = 1;
    if(newRSAKey(bitlen, &keys)) {
      if (verbose) printf("\nKeys successfuly generated.\n");
    }
    else printf("\nKey generation failed.  Try again.\n"), exit(-1);

    mark = clock() - mark ;
    ftime (&end_time);

#ifdef ultrix
#ifndef CLOCKS_PER_SEC
#define CLOCKS_PER_SEC  1000000
#endif
tenths = (100*(mark%CLOCKS_PER_SEC))/CLOCKS_PER_SEC ;
mark /= CLOCKS_PER_SEC ;
#else
tenths = (100*(mark%CLK_TCK))/CLK_TCK ;
mark /= CLK_TCK ;
#endif

    if (verbose) 
        printf ("\n Key generation time: %d.%02d seconds ", mark, tenths );

    if (verbose) {
        long xt = (unsigned long) end_time.millitm - (unsigned long) start_time.millitm ;
        long mark = end_time.time - start_time.time ;
        if (xt<0) { mark--; xt = 1000 - xt;}
        printf ("\n     (%d.%03d elapsed seconds) \n",
	    end_time.time-start_time.time, xt );
        }
    }
    {
        FILE *priv;
	char realname[128];
	int  c, i;
	static unsigned char domain[80], prompt[100];
	DESblock    pwdkey, hashkey;
        unsigned char *encrypted_private;
        int encrypted_private_len;


	if (sflag == 0) {
	  if (cakey) strcpy(domain, "OU=");
	  else strcpy(domain, "CN=");

          if (nflag == 0) {
	    printf("\nEnter real name (default is '%s') : ", usernameBuf);
	    for (i = c = 0 ; ((c=getchar())!=EOF) && (c != '\n') ; i++)
	      realname[i] = c;
	    if (i == 0)
	      strcat(domain,usernameBuf);
	    else strcat(domain, realname);
          } else {
            strcpy(realname, fullnameBuf);
            strcat(domain, realname);
          }
	  printf("\nname : %s \n", domain);
	}


        if ((priv = fopen(privateBuf, "w")) == NULL)
        {
            printf("could not open/create private key file - %s", privateBuf);
            exit(-1);
	}

	if (sflag == 0) {
	  printf("\nReminder: select password carefully (no dictionary words, names, places, etc.)\n");
          if (realname[0] != '\0')
	    sprintf(prompt, "%s's password : ", realname);
          else sprintf(prompt, "%s's password : ", usernameBuf);

	  if (!wflag) {
	    if (DES_read_password_hash(&pwdkey, &hashkey, usernameBuf, prompt, 1) == 0) {
              printf("\nError entering password.  Try again.\n");
              if (DES_read_password_hash(&pwdkey, &hashkey, usernameBuf, prompt, 1) == 0) {
	        printf("\nError entering password. Try regenerating keys.\n");
	        exit(-1);
	      }
	    }
	  } else {
	    H1(usernameBuf, passwordBuf, &hashkey);
	    H2(0, passwordBuf, &pwdkey);
	  }
	}

	if (sflag == 0) {
          if (hide_private(&pwdkey,&encrypted_private,&encrypted_private_len,
		&keys) == 0) {
                printf("\nError encoding private key.\n");
                exit(-1);
          }
        } else {
	  encrypted_private = (unsigned char *) EncodePrivate(&keys);
	  encrypted_private_len = DecodeTotalLength(encrypted_private);
	}

	if (sflag == 0) {
	  fprintf(priv,"%s\n", domain);
	  fdumphex(uidBuf, uid_len, priv);
	  fprintf(priv," ;\n");
	  fdumphex(&hashkey, 8, priv);
	  fprintf(priv," ;\n");
	}

	if (sflag == 0)
	  fdumphex(encrypted_private,encrypted_private_len, priv);
	else
	  fdumpbin(encrypted_private,encrypted_private_len, priv);

	if (sflag == 0) {
	  fprintf(priv," ;\n");
          fclose(priv);
          printf("Writing ... %s_privkey, ",usernameBuf);
	} else {
	  encrypted_private = (unsigned char *) EncodePublic(&keys);
	  encrypted_private_len = DecodeTotalLength(encrypted_private);
	  fdumpbin(encrypted_private,encrypted_private_len, priv);
          fclose(priv);
          printf("Writing ... %s_privkey\n",usernameBuf);
	}

        cfree(encrypted_private);

	if (sflag == 0) {
	  memset((char *)&pwdkey, 0,sizeof(pwdkey));
          write_pubkey(&keys,usernameBuf,domain,uidBuf,uid_len);
          printf("%s_pubkey\n",usernameBuf);
	}
    }
BnnClose();
exit(0);
}

int sreadhex (x,s,maxi)
unsigned char *x, *s;
int maxi;
{
    int i,j;
    int l = strlen(s);
    unsigned z;

    for(i=j=0; (i<maxi)&&(j<l)&&(1==sscanf(s," %02x",&z)); i++,j+=2,s+=2,x++)
      *x=(unsigned char)z;
    return (i);
}



#define CHARS_PER_LINE 20

int sdumphex (x,l,s)
int l;
char *x, *s;
{
    int i;
    for(i=0;i<l;i++) sprintf(&s[3*i]," %02x",(unsigned char)x[i]);
    return(3*i);
}

