/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*                       BASE D'ENTIERS                            */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

# include "genpari.h"
GEN rquot(),ordmax(),rtran(),mtran(),matinv();
void rowred();

GEN base(x,y)

     GEN x,*y;

/*******************************************************************
  Entree:     x polynome unitaire a coefficients dans Z de deg n
	    definissant un corps de nombres K=Q(theta);
	      y pointeur sur un GEN destine a recevoir
	    le discriminant du corps K.
  Sortie:    retourne 1) un vecteur (horizontal) a n composantes, 
            de polynomes a coeff dans Q (de deg 0,1...n-1)
	    constituant une base de l'anneau des entiers de K.
	        2) le discriminant de K (dans *y).
	    Rem: le denominateur commun des coef. est dans da.
*******************************************************************/

{
  GEN p,a,at,bt,b,da,db,q;
  long av,tetpil,n,h,j,je,k,r,s,t,pro,v;

  av=avma;*y=discsr(x);p=auxdecomp(absi(*y),1);
  n=lgef(x)-3;v=varn(x);h=lg(p[1])-1;

  a=idmat(n);da=gun;
  for(je=1;je<=h;je++)
    {
      if(gcmpgs(coeff(p,je,2),1)>0)
	{
	  b=ordmax(x,coeff(p,je,1),coeff(p,je,2),&db);
	  a=gmul(db,a);b=gmul(da,b);
	  da=mulii(db,da);db=da;
	  at=gtrans(a);bt=gtrans(b);
	  for(r=n-1;r>=0;r--)
	    for(s=r;s>=0;s--)
	      while(signe(coef1(bt,s,r)))
		{
		  q=rquot(coef1(at,s,s),coef1(bt,s,r));
		  at[s+1]=(long)rtran(at[s+1],bt[r+1],q);
		  for(t=s-1;t>=0;t--)
		    {
		      q=rquot(coef1(at,t,s),coef1(at,t,t));
		      at[s+1]=(long)rtran(at[s+1],at[t+1],q);
		    }
		  pro=at[s+1];at[s+1]=bt[r+1];bt[r+1]=pro;
		}
	  for(j=n-1;j>=0;j--)
	    {
	      for(k=0;k<j;k++)
		{
		  while(signe(coef1(at,j,k)))
		    {
		      q=rquot(coef1(at,j,j),coef1(at,j,k));
		      at[j+1]=(long)rtran(at[j+1],at[k+1],q);
		      pro=at[j+1];at[j+1]=at[k+1];at[k+1]=pro;
		    }
		}
	      if(signe(coef1(at,j,j))<0)
		for(k=0;k<=j;k++) coef1(at,k,j)=lnegi(coef1(at,k,j));
	      for(k=j+1;k<n;k++)
		{
		  q=rquot(coef1(at,j,k),coef1(at,j,j));
		  at[k+1]=(long)rtran(at[k+1],at[j+1],q);
		}
	    }
	  for(j=1;j<n;j++)
	    if(!cmpii(coef1(at,j,j),coef1(at,j-1,j-1)))
	      {
		coef1(at,0,j)=zero;
		for(k=1;k<=j;k++)
		  coef1(at,k,j)=coef1(at,k-1,j-1);
	      }
	  a=gtrans(at);
	}
    }
  for(j=1;j<=n;j++)
    {
      *y=divii(mulii(coeff(a,j,j),*y),da);
      *y=divii(mulii(coeff(a,j,j),*y),da);
    }
  tetpil=avma;*y=gcopy(*y);at=cgetg(n+1,17);
  for(j=1;j<=n;j++)
    {
      q=cgetg(j+2,10);q[1]=0x1000002+j+(v<<16);at[j]=(long)q;
      for(k=2;k<=j+1;k++) q[k]=ldiv(coeff(a,j,k-1),da);
    }
  pro=lpile(av,tetpil,0)>>2;at+=pro;(*y)+=pro;
  return at;
}

GEN smallbase(x,y)

     GEN x,*y;

{
  GEN p,a,at,bt,b,da,db,q;
  long av,tetpil,n,h,j,je,k,r,s,t,pro,v;

  av=avma;*y=discsr(x);p=auxdecomp(absi(*y),0);
  n=lgef(x)-3;v=varn(x);h= lg(p[1])-1;

  a=idmat(n);da=gun;
  for(je=1;je<=h;je++)
    {
      if(gcmpgs(coeff(p,je,2),1)>0)
	{
	  b=ordmax(x,coeff(p,je,1),coeff(p,je,2),&db);
	  a=gmul(db,a);b=gmul(da,b);
	  da=mulii(db,da);db=da;
	  at=gtrans(a);bt=gtrans(b);
	  for(r=n-1;r>=0;r--)
	    for(s=r;s>=0;s--)
	      while(signe(coef1(bt,s,r)))
		{
		  q=rquot(coef1(at,s,s),coef1(bt,s,r));
		  at[s+1]=(long)rtran(at[s+1],bt[r+1],q);
		  for(t=s-1;t>=0;t--)
		    {
		      q=rquot(coef1(at,t,s),coef1(at,t,t));
		      at[s+1]=(long)rtran(at[s+1],at[t+1],q);
		    }
		  pro=at[s+1];at[s+1]=bt[r+1];bt[r+1]=pro;
		}
	  for(j=n-1;j>=0;j--)
	    {
	      for(k=0;k<j;k++)
		{
		  while(signe(coef1(at,j,k)))
		    {
		      q=rquot(coef1(at,j,j),coef1(at,j,k));
		      at[j+1]=(long)rtran(at[j+1],at[k+1],q);
		      pro=at[j+1];at[j+1]=at[k+1];at[k+1]=pro;
		    }
		}
	      if(signe(coef1(at,j,j))<0)
		for(k=0;k<=j;k++) coef1(at,k,j)=lnegi(coef1(at,k,j));
	      for(k=j+1;k<n;k++)
		{
		  q=rquot(coef1(at,j,k),coef1(at,j,j));
		  at[k+1]=(long)rtran(at[k+1],at[j+1],q);
		}
	    }
	  for(j=1;j<n;j++)
	    if(!cmpii(coef1(at,j,j),coef1(at,j-1,j-1)))
	      {
		coef1(at,0,j)=zero;
		for(k=1;k<=j;k++)
		  coef1(at,k,j)=coef1(at,k-1,j-1);
	      }
	  a=gtrans(at);
	}
    }
  for(j=1;j<=n;j++)
    {
      *y=divii(mulii(coeff(a,j,j),*y),da);
      *y=divii(mulii(coeff(a,j,j),*y),da);
    }
  tetpil=avma;*y=gcopy(*y);at=cgetg(n+1,17);
  for(j=1;j<=n;j++)
    {
      q=cgetg(j+2,10);q[1]=0x1000002+j+(v<<16);at[j]=(long)q;
      for(k=2;k<=j+1;k++) q[k]=ldiv(coeff(a,j,k-1),da);
    }
  pro=lpile(av,tetpil,0)>>2;at+=pro;(*y)+=pro;
  return at;
}


GEN factoredbase(x,p,y)

     GEN x,p,*y;

/*******************************************************************
  Entree:     x polynome unitaire a coefficients dans Z de deg n
	    definissant un corps de nombres K=Q(theta);
	      p matrice de la factorisation du discriminant de x
	      y pointeur sur un GEN destine a recevoir
	    le discriminant du corps K.
  Sortie:    retourne 1) un vecteur (horizontal) a n composantes, 
            de polynomes a coeff dans Q (de deg 0,1...n-1)
	    constituant une base de l'anneau des entiers de K.
	        2) le discriminant de K (dans *y).
	    Rem: le denominateur commun des coef. est dans da.
*******************************************************************/

{
  GEN a,at,bt,b,da,db,q;
  long av,tetpil,n,h,j,je,k,r,s,t,pro,v;

  av=avma;n=lgef(x)-3;*y=discsr(x);v=varn(x);
  if((typ(p)!=19)||(lg(p)!=3)) err(factoreder1);
  h=lg(p[1])-1;
  q=gun;for(je=1;je<=h;je++) q=gmul(q,gpui(coeff(p,je,1),coeff(p,je,2)));
  if(gcmp(q,*y)) err(factoreder2);
  a=idmat(n);da=gun;
  for(je=1;je<=h;je++)
    {
      if(gcmpgs(coeff(p,je,2),1)>0)
	{
	  b=ordmax(x,coeff(p,je,1),coeff(p,je,2),&db);
	  a=gmul(db,a);b=gmul(da,b);
	  da=mulii(db,da);db=da;
	  at=gtrans(a);bt=gtrans(b);
	  for(r=n-1;r>=0;r--)
	    for(s=r;s>=0;s--)
	      while(signe(coef1(bt,s,r)))
		{
		  q=rquot(coef1(at,s,s),coef1(bt,s,r));
		  at[s+1]=(long)rtran(at[s+1],bt[r+1],q);
		  for(t=s-1;t>=0;t--)
		    {
		      q=rquot(coef1(at,t,s),coef1(at,t,t));
		      at[s+1]=(long)rtran(at[s+1],at[t+1],q);
		    }
		  pro=at[s+1];at[s+1]=bt[r+1];bt[r+1]=pro;
		}
	  for(j=n-1;j>=0;j--)
	    {
	      for(k=0;k<j;k++)
		{
		  while(signe(coef1(at,j,k)))
		    {
		      q=rquot(coef1(at,j,j),coef1(at,j,k));
		      at[j+1]=(long)rtran(at[j+1],at[k+1],q);
		      pro=at[j+1];at[j+1]=at[k+1];at[k+1]=pro;
		    }
		}
	      if(signe(coef1(at,j,j))<0)
		for(k=0;k<=j;k++) coef1(at,k,j)=lnegi(coef1(at,k,j));
	      for(k=j+1;k<n;k++)
		{
		  q=rquot(coef1(at,j,k),coef1(at,j,j));
		  at[k+1]=(long)rtran(at[k+1],at[j+1],q);
		}
	    }
	  for(j=1;j<n;j++)
	    if(!cmpii(coef1(at,j,j),coef1(at,j-1,j-1)))
	      {
		coef1(at,0,j)=zero;
		for(k=1;k<=j;k++)
		  coef1(at,k,j)=coef1(at,k-1,j-1);
	      }
	  a=gtrans(at);
	}
    }
  for(j=1;j<=n;j++)
    {
      *y=divii(mulii(coeff(a,j,j),*y),da);
      *y=divii(mulii(coeff(a,j,j),*y),da);
    }
  tetpil=avma;*y=gcopy(*y);at=cgetg(n+1,17);
  for(j=1;j<=n;j++)
    {
      q=cgetg(j+2,10);q[1]=0x1000002+j+(v<<16);at[j]=(long)q;
      for(k=2;k<=j+1;k++) q[k]=ldiv(coeff(a,j,k-1),da);
    }
  pro=lpile(av,tetpil,0)>>2;at+=pro;(*y)+=pro;
  return at;
}

GEN discf(x)
     GEN x;
{
  GEN y;
  long av,tetpil;

  av=avma;base(x,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

GEN smalldiscf(x)
     GEN x;
{
  GEN y;
  long av,tetpil;

  av=avma;smallbase(x,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

GEN factoreddiscf(x,p)
     GEN x,p;
{
  GEN y;
  long av,tetpil;

  av=avma;factoredbase(x,p,&y);tetpil=avma;
  return gerepile(av,tetpil,gcopy(y));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*   Quotient et Reste normalises   ( -1/2 < r = x-q*y <= 1/2 )    */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN rquot(x,y)

     GEN x,y;

{
  GEN u,v,w,p;
  long av,av1;

  av=avma;
  u=absi(y);v=shifti(x,1);w=shifti(y,1);
  if ( cmpii(u,v)>0) p=subii(v,u);
  else p=addsi(-1,addii(u,v));
  av1=avma;
  return(gerepile(av,av1,divii(p,w)));
}
 
GEN rrmdr(x,y)

     GEN x,y;

{
  GEN p;
  long av,av1;

  av=avma;
  p=mulii(rquot(x,y),y);
  av1=avma;
  return(gerepile(av,av1,subii(x,p)));
}

GEN rinv(x,y)

     GEN x,y;

{
  GEN a,c,q,r,t;
  long av,av1;

  av=avma;
  a=gun;c=gzero;
  while( signe(y))
	{
	  q=rquot(x,y);
	  r=subii(a,mulii(q,c));a=c;c=r;
	  t=subii(x,mulii(q,y));x=y;y=t;
	}
  av1=avma;
  if (signe(x)<0) a=negi(a);
  if (signe(c)) { av1=avma; a=rrmdr(a,c); }
  return( gerepile(av,av1,a));
}

GEN rgcd(x,y)

     GEN x,y;

{
  GEN z;
  long av,av1;

  av=avma;
  while(signe(y))
    {
      z=rrmdr(x,y);x=y;y=z;
    }
  av1=avma;
  return(gerepile(av,av1,absi(x)));
}
    

GEN rlcm(x,y)

     GEN x,y;

{
  GEN d,z;
  long av,av1;

  av=avma;
  z=mulii(x,y);d=rgcd(x,y);
  av1=avma;
  return(gerepile(av,av1,divii(z,d)));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*                                                                 */
/*           Matrice compagnon du polynome unitaire x              */
/*                                                                 */
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN companion(x)

     GEN     x;

{
  long    i,j,l;
  GEN     y;
  
  l=lgef(x)-2;y=cgetg(l,19);
  for(i=1;i<l;i++) y[i]=lgetg(l,18);
  for(i=0;i<l-2;i++)
    for(j=0;j<l-1;j++) coef1(y,i,j)=((i+1)==j) ? un : zero;
  for(j=0;j<l-1;j++) coef1(y,l-2,j)=lneg(x[j+2]);
  return(y);
}



GEN ordmax(f,p,e,ptdelta)

GEN f,p,e;
GEN *ptdelta;

{
  GEN m,hh,pp,dd,ppdd,index,q,r,s,b,c,t,jp,v,delta;
  GEN cf[20],w[20],a;
  long h,i,j,k,sp,epsilon,n=lgef(f)-3;

  a=cgetg(n*n+1,19);
  for(j=1;j<=n*n;j++)
  {
    a[j]=lgetg(n+1,18);
    for(k=1;k<=n;k++) coeff(a,k,j)=zero;
  }
  v=cgetg(n+1,18);
  cf[0]=idmat(n);
  cf[1]=companion(f);
  for(j=2;j<n;j++) cf[j]=gmul(cf[1],cf[j-1]);
  delta=gun; epsilon=itos(e);
  m=idmat(n);

  do
    {
      pp=mulii(p,p);
      dd=mulii(delta,delta);
      ppdd=mulii(dd,pp);
      b=matinv(m,delta);
      for(i=0;i<n;i++)
	{
	  t=gscalsmat(0,n); /* t <--- matrice nulle d'ordre n */
	  for(h=0;h<n;h++)
	    for(j=0;j<n;j++)
	      for(k=0;k<n;k++)
		coef1(t,j,k)=(long)rrmdr(addii(coef1(t,j,k),mulii(coef1(m,i,h),coef1(cf[h],j,k))),ppdd);
	  c=gmul(t,b);
	  w[i]=gmul(m,c);
	  for(j=0;j<n;j++)
	    for(k=0;k<n;k++)
	      coef1(w[i],j,k)=(long)rrmdr(divii(coef1(w[i],j,k),dd),pp);
	}
      if(cmpis(p,n)>0)
	{
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      {
		coeff(t,i+1,j+1)=zero;
		for(k=0;k<n;k++)
		  for(h=0;h<n;h++)
		    {
		      r=modii(coef1(w[i],k,h),p);
		      s=modii(coef1(w[j],h,k),p);
		      coef1(t,i,j)=lmodii(addii(coef1(t,i,j),mulii(r,s)),p);
		    }
	      }
	}
      else
	{
	  for(j=0;j<n;j++)
	    {
	      for(i=0;i<n;i++)
		coef1(b,i,j)=(i==0)? un:zero;
/* ici la boucle en k calcule la puissance p mod p de w[j] */
	      sp=itos(p);
	      for(k=0;k<sp;k++)
		{
		  for(i=0;i<n;i++)
		    {
		      v[i+1]=zero;
		      for(h=0;h<n;h++)
			v[i+1]=lmodii(addii(v[i+1],mulii(coef1(b,h,j),coef1(w[j],h,i))),p);
		    }
		  for(i=0;i<n;i++) coef1(b,i,j)=v[i+1];
		}
	    }
	  q=p;t=b;
	  while(cmpis(q,n)<0)
	    {
	      q=mulii(q,p);
	      t=gmul(b,t);
	    }
	}
      for(i=0;i<n;i++)
	for(j=0;j<n;j++)
	  {
	    coef1(a,j,i)=(i==j)? (long)p:zero;
	    coef1(a,j,n+i)=lmodii(coef1(t,i,j),p);
	  }
      rowred(a,2*n-1,pp);
      for(i=0;i<n;i++)
	for(j=0;j<n;j++)
	  coef1(b,j,i)=coef1(a,j,i);
      jp=matinv(b,p);
      for(k=0;k<n;k++)
	{
	  t=gmul(jp,w[k]);
	  t=gmul(t,b);
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      coef1(t,i,j)=ldivii(coef1(t,i,j),p);
	  h=0;
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      {
		coef1(a,k,h)=coef1(t,i,j);
		h++;
	      }
	}
      rowred(a,n*n-1,pp);
      index=gun;
      for(i=0;i<n;i++)
	index=mulii(index,coef1(a,i,i));
      if (cmpsi(1,index))
	{
	  delta=mulii(index,delta);
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      coef1(c,i,j)=coef1(a,i,j);
	  b=matinv(c,index);
	  m=gmul(b,m);
	  hh=delta;
	  for(i=0;i<n;i++)
	    for(j=0;j<n;j++)
	      hh=rgcd(coef1(m,i,j),hh);
	  if(cmpis(hh,1)>1)
	    {
	      delta=divii(delta,hh);
	      for(i=0;i<n;i++)
		for(j=0;j<n;j++)
		  coef1(m,i,j)=ldivii(coef1(m,i,j),hh);
	    }
	  q=index;
	  while(!signe(modii(q,p)))
	    {
	      q=divii(q,p);
	      epsilon=epsilon-2;
	    }
	}
    }
  while(!gcmp1(index) && (epsilon>=2));
  *ptdelta=delta;
  return(m);
}

void rowred(a,rlim,rmod)
     GEN a,rmod;
     long rlim;

{
  long j,k,n,pro;
  GEN q;

  n=lg(a[1])-1;
  for(j=0;j<n;j++)
    {
      for(k=j+1;k<=rlim;k++)
	while (signe(coef1(a,j,k)))
	  {
	    q=rquot(coef1(a,j,j),coef1(a,j,k));
	    a[j+1]=(long)mtran(a[j+1],a[k+1],q,rmod);
	    pro=a[j+1];a[j+1]=a[k+1];a[k+1]=pro;
	  }
      if (signe(coef1(a,j,j))<0)
	for(k=j;k<n;k++) coef1(a,k,j)=lnegi(coef1(a,k,j));
      for(k=0;k<j;k++)
	{
	  q=rquot(coef1(a,j,k),coef1(a,j,j));
	  a[k+1]=(long)mtran(a[k+1],a[j+1],q,rmod);
	}
    }
}

GEN rtran(v,w,q)
     GEN v,w,q ;

{
  long av,tetpil;
  GEN p1;

  if (signe(q))
    {
      av=avma;p1=gmul(q,w);tetpil=avma;
      return gerepile(av,tetpil,gsub(v,p1));
    }
  else return v;
}

GEN mtran(v,w,q,m)
     GEN v,w,q,m;

{
  long k;
  
  if (signe(q))
    {
      for(k=0;k<lg(v)-1;k++)
	{
	  v[k+1]=(long)rrmdr(subii(v[k+1],modii(mulii(q,w[k+1]),m)),m);
	}
    }
  return v;
}


GEN matinv(x,d)
     GEN x,d;
/*=======================================================================
    Calcule d/x  ou  d est entier et x matrice triangulaire inferieure
  entiere dont les coeff diagonaux divisent d ( resultat entier).
========================================================================*/
{
  long n,h,i,j,k,av,av1;
  GEN y;

  av=avma;
  y=idmat(n=lg(x)-1);
  for(i=1;i<=n;i++)
    coeff(y,i,i)=ldivii(d,coeff(x,i,i));
  for(i=2;i<=n;i++)
    for(j=i-1;j;j--)
      {
	for(h=zero,k=j+1;k<=i;k++)
	  h=ladd(h,mulii(coeff(y,i,k),coeff(x,k,j)));
	coeff(y,i,j)=ldivii(negi(h),coeff(x,j,j));
      }
  av1=avma;
  return gerepile(av,av1,gcopy(y));
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~									~*/
/*~			HERMITE NORMAL FORM REDUCTION			~*/
/*~									~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN hnfold(x)
     GEN x;
{
  long li,co,av,tetpil,i,j,j1,def,ind,lim;
  GEN p1,p2,y,z,m1;

  if(typ(x)!=19) err(hnfer1);
  lim=(avma+bot)>>1;
  av=avma;co=lg(x);li=lg(x[1]);y=gcopy(x);
  def=co;
  if(li>co) err(hnfer2);
  for(i=li-1;i>=1;i--)
    {
      def--;j=1;while((j<def)&&(!signe(coeff(y,i,j)))) j++;
      while(j<def)
	{
	  m1=absi(coeff(y,i,j));ind=j;
	  for(j1=j+1;j1<def;j1++)
	    {
	      p1=(GEN)coeff(y,i,j1);
	      if(signe(p1)&&(cmpii(absi(p1),m1)<0))
		{
		  m1=p1;ind=j1;
		}
	    }
	  p1=(GEN)coeff(y,i,def);
	  if(!(signe(p1)&&(cmpii(absi(p1),m1)<0)))
	    {
	      p1=(GEN)y[def];y[def]=y[ind];y[ind]=(long)p1;
	    }
	  p1=(GEN)coeff(y,i,def);if(signe(p1)<0) y[def]=lneg(y[def]);
	  p1=(GEN)coeff(y,i,def);
	  for(j=1;j<def;j++)
	    {
	      p2=gdivent(coeff(y,i,j),p1);
	      y[j]=lsub(y[j],gmul(p2,y[def]));
	    }
	  j=1;while((j<def)&&(!signe(coeff(y,i,j)))) j++;
	}
      p1=(GEN)coeff(y,i,def);
      if(signe(p1)<0) {y[def]=lneg(y[def]);p1=(GEN)coeff(y,i,def);}
      if(signe(p1))
	{
	  for(j=def+1;j<co;j++)
	    {
	      p2=gdivent(coeff(y,i,j),p1);
	      y[j]=lsub(y[j],gmul(p2,y[def]));
	    }
	}
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;z=cgetg(li,19);
  for(j=1;j<li;j++)
    {
      z[j]=lcopy(y[j+co-li]);
    }
  for(j=1;j<=co-li;j++) if(!gcmp0(y[j])) err(hnfer3);
  return gerepile(av,tetpil,z);
}


GEN hnf(x)
     GEN x;
{
  long li,co,av,tetpil,i,j,def,lim;
  GEN p1,p2,y,z,u,v,d;

  if(typ(x)!=19) err(hnfer1);
  lim=(avma+bot)>>1;
  av=avma;co=lg(x);li=lg(x[1]);y=gcopy(x);
  def=co;
  if(li>co) err(hnfer2);
  for(i=li-1;i>=1;i--)
    {
      def--;j=def;while(j&&(!signe(coeff(y,i,j)))) j--;
      while(j>1)
	{
	  d=bezout(coeff(y,i,j),coeff(y,i,j-1),&u,&v);
	  p1=gadd(gmul(u,y[j]),gmul(v,y[j-1]));
	  y[j]=lsub(gmul(divii(coeff(y,i,j),d),y[j-1]),gmul(divii(coeff(y,i,j-1),d),y[j]));
	  y[j-1]=(long)p1;
	  j--;while(j&&(!signe(coeff(y,i,j)))) j--;
	}
      if(j==1)
	{
	  d=bezout(coeff(y,i,1),coeff(y,i,def),&u,&v);
	  p1=gadd(gmul(u,y[1]),gmul(v,y[def]));
	  y[1]=lsub(gmul(divii(coeff(y,i,1),d),y[def]),gmul(divii(coeff(y,i,def),d),y[1]));
	  y[def]=(long)p1;
	}
      p1=(GEN)coeff(y,i,def);
      if(signe(p1)<0) {y[def]=lneg(y[def]);p1=(GEN)coeff(y,i,def);}
      if(signe(p1))
	{
	  for(j=def+1;j<co;j++)
	    {
	      p2=gdivent(coeff(y,i,j),p1);
	      y[j]=lsub(y[j],gmul(p2,y[def]));
	    }
	}
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;z=cgetg(li,19);
  for(j=1;j<li;j++)
    {
      z[j]=lcopy(y[j+co-li]);
    }
  for(j=1;j<=co-li;j++) if(!gcmp0(y[j])) err(hnfer3);
  return gerepile(av,tetpil,z);
}


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~									~*/
/*~			SMITH NORMAL FORM REDUCTION			~*/
/*~									~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

GEN smith(x)
     GEN x;
{
  long li,av,tetpil,i,j,k,l,lim,c,fl,n;
  GEN p1,p2,p3,p4,y,z,b,u,v,d;

  if(typ(x)!=19) err(hnfer1);
  lim=(avma+bot)>>1;
  av=avma;n=lg(x)-1;li=lg(x[1])-1;y=gcopy(x);
  if(li!=n) err(hnfer2);
  for(i=n;i>=2;i--)
    {
      do
	{
	  c=0;
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,i,j);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,k,i)),mulii(v,coeff(y,k,j)));
		      coeff(y,k,j)=lsubii(mulii(p3,coeff(y,k,j)),mulii(p4,coeff(y,k,i)));
		      coeff(y,k,i)=(long)b;
		    }
		  c++;
		}
	    }
	  for(j=i-1;j>=1;j--)
	    {
	      p1=(GEN)coeff(y,j,i);
	      if(signe(p1))
		{
		  p2=(GEN)coeff(y,i,i);
		  if(gegal(p1,p2)) {d=p1;u=gun;v=gzero;p3=gun;p4=gun;}
		  else {d=bezout(p2,p1,&u,&v);p3=divii(p2,d);p4=divii(p1,d);}
		  for(k=1;k<=i;k++)
		    {
		      b=addii(mulii(u,coeff(y,i,k)),mulii(v,coeff(y,j,k)));
		      coeff(y,j,k)=lsubii(mulii(p3,coeff(y,j,k)),mulii(p4,coeff(y,i,k)));
		      coeff(y,i,k)=(long)b;
		    }
		}
	    }
	  if(!c)
	    {
	      b=(GEN)coeff(y,i,i);fl=1;
	      for(k=1;(k<i)&&fl;k++)
		for(l=1;(l<i)&&fl;l++)
		  fl= !signe(modii(coeff(y,k,l),b));
	      if(!fl)
		{
		  k--;
		  for(l=1;l<=i;l++)
		    coeff(y,i,l)=laddii(coeff(y,i,l),coeff(y,k,l));
		}
	    }
	}
      while(c||(!fl));
      if(avma<lim) {tetpil=avma;y=gerepile(av,tetpil,gcopy(y));}
    }
  tetpil=avma;z=cgetg(n+1,17);
  for(k=1;k<=n;k++) z[k]=lcopy(coeff(y,k,k));
  return gerepile(av,tetpil,z);
}
	
		
       
		  

