#include <config.h>
#include <site.h>

#include <ctype.h>
#include <setjmp.h>
#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#include <time.h>

#include <sys/file.h>





/** Reaktion auf Eingabe von '^D' bei 'A', 'a', 'N', '?', '~/@', 'C', 'T'  **/
#ifdef ___APOLLO
#define CTRL_D {clearerr(stdin); break;}
#else						  /* else part of #ifdef ___APOLLO */
#define CTRL_D {clearerr(stdin); putchar('\n'); break;}
#endif

#ifdef ___HP
#define ___NO_WINSIZE___
#endif

#define strcat2(s, a, b) (*s = '\0', strcat(strcat(s, a), b))
#define strcat3(s, a, b, c) strcat(strcat2(s, a, b), c)
#define strcat4(s, a, b, c, d) strcat(strcat(strcat2(s, a, b), c), d)
#define strcat5(s, a, b, c, d, e) strcat(strcat(strcat(strcat2(s, a, b), c), d), e)

#define gesetzt(var, name) \
	if (!var[0]) {\
		printf("name undefined\n");\
		break;\
	}

char           *calloc(), *malloc();
char           *strcat();

#ifndef ___NO_WINSIZE___
int             filedes;			  /* Filedescriptor fuer File /dev/tty */
struct winsize  win_groesse;			  /* struct fuer Bildschirmparameter */
#endif

jmp_buf         umgeb;



/******** zeit() ********/

zeit()
{
	long            l, *pl, time();
	struct tm      *ptr, *localtime();
	int             hour, min, sec;

	pl = &l;
	time(pl);
	ptr = localtime(pl);
	hour = ptr->tm_hour;
	min = ptr->tm_min;
	sec = ptr->tm_sec;
	printf("%d:%d%d:%d%d\n\n", hour, min / 10, min % 10, sec / 10, sec % 10);
	/* vorher: char *ctime(); */
	/* pl = &l; time(pl); puts(ctime(pl)); */
}



/******** abfang() ********/

int             abfang()
{
	signal(SIGINT, abfang);
	putchar('\n');
	longjmp(umgeb, 0);
}



/******** getline() ********/

char           *getline(s, n, pf)
	char           *s;
	int             n;
	FILE           *pf;
{
	char           *ss;
	char            ch;

	ss = s;
	while ((n--) > 0 && (ch = getc(pf)) != '\n' && ch != EOF)
		*s++ = ch;
	*s = '\0';
	if (*ss == '\0' && ch == EOF)
		ss = NULL;
	return (ss);
}





char            version_nr[20];
char            befehl[300];
char            modlibs[100][30];
char            LIB[900];
char            backup[400];
char            lib_long[200];

#ifdef ___DEBUGGER
char            lib_longg[200];
#endif

char            zeile[200];
char            helptxt[200];
char            lib[100];
char            name[100];
char            name_P[100], name_c[100], name_o[100];
char            name_S[100], name_i[100], name_x[100];

#ifdef ___DEBUGGER
char            PATH_deb[100];
#endif

char            PATH_header[100], PATH_modlib[100], PATH_dr[100], PATH_pre[100];
char            PATH_header_kant[100], PATH_modlib_kant[100];
char            PATH_preV3_1[100], PATH_CC[100];



char           *DIR[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", LIB, 0};



#ifndef ___DEBUGGER
char           *dir[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_long, 0};
#ifdef I_HAVE_KANT
char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-c", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-c", "-I.", PATH_header, name_c, 0};
#endif

#else						  /* else part of #ifndef ___DEBUGGER */

char           *dir[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_longg, 0};
#ifdef I_HAVE_KANT
char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-c", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *obj[] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-c", "-I.", PATH_header, name_c, 0};
#endif
#endif



#ifdef ___APOLLO
char           *strip[] = {STRIP_COMMAND, "strip", "-Aa", name_x, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *strip[] = {STRIP_COMMAND, "strip", name_x, 0};
#endif



#ifdef ___APOLLO
char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, name_c, 0};

#else						  /* else part of #ifdef ___APOLLO */

#ifdef I_HAVE_KANT
char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, PATH_header_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", name_c, 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *pre[] = {CC_PRE_COMMAND, CC_PRE_SHORT_COMMAND, "-P", "-I.", PATH_header, name_c, 0};
#endif
#endif



char           *r[] = {name_x, name_x, 0};
char           *lsv1[] = {"/bin/ls", "ls", "-l", name_S, 0};
char           *LPR[] = {PATH_dr, "dr", name_S, 0};



#ifdef ___APOLLO
char           *LPR1[] = {VI_COMMAND, VI_SHORT_COMMAND, "ce", name_i, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *LPR1[] = {VI_COMMAND, VI_SHORT_COMMAND, name_i, 0};
#endif



char           *SEL[] = {AR_COMMAND, AR_SHORT_COMMAND, "x", LIB, name_S, 0};
char           *DEL[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", LIB, name_S, 0};
char           *AR[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", LIB, name_S, 0};
char           *ARV1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", LIB, name_S, 0};
char           *del[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", lib_long, name_o, 0};



#ifdef ___DEBUGGER
char           *delg[] = {AR_COMMAND, AR_SHORT_COMMAND, "d", lib_longg, name_o, 0};
#endif



#ifdef ___APOLLO
char           *e[] = {VI_COMMAND, VI_SHORT_COMMAND, "ce", name_S, 0};

#else						  /* else part of #ifdef ___APOLLO */

char           *e[] = {VI_COMMAND, VI_SHORT_COMMAND, name_S, 0};
#endif



char           *E[] = {EMACS_COMMAND, EMACS_SHORT_COMMAND, name_S, 0};
char           *SM_pre[] = {PATH_pre, "preproc.x", name_S, name_P, 0};
char           *SM_preV3_1[] = {PATH_preV3_1, "preV3_1.x", name_P, name_c, 0};
char           *ar[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", lib_long, name_o, 0};



#ifndef ___DEBUGGER
char           *arv1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_long, name_o, 0};

#else						  /* else part of #ifndef ___DEBUGGER */

char           *arg[] = {AR_COMMAND, AR_SHORT_COMMAND, "r", lib_longg, name_o, 0};
char           *arv1[] = {AR_COMMAND, AR_SHORT_COMMAND, "tv", lib_longg, name_o, 0};
#endif



#ifndef ___DEBUGGER
char           *ranlib[] = {RANLIB_COMMAND, "ranlib", lib_long, 0};

#else						  /* else part of #ifndef ___DEBUGGER */

char           *ranlib[] = {RANLIB_COMMAND, "ranlib", lib_longg, 0};
#endif



char           *C[100] = {PATH_CC, "CCC", name, 0};



#ifndef ___DEBUGGER
#ifdef I_HAVE_KANT
char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-I.", PATH_header, PATH_header_kant, PATH_modlib, PATH_modlib_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D___KKK2", "-o", name_x, name_c, 0};
#define anz_args_c 15

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-O", "-I.", PATH_header, PATH_modlib, "-o", name_x, name_c, 0};
#define anz_args_c 9
#endif

#else						  /* else part of #ifndef ___DEBUGGER */

#ifdef I_HAVE_KANT
char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-I.", PATH_header, PATH_header_kant, PATH_deb, PATH_modlib_kant, "-DPOSH", "-DKANT", "-D___KKK1", "-D_KKK2", "-o", name_x, name_c, 0};
#define anz_args_c 15

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *c[200] = {CC_COMMAND, CC_SHORT_COMMAND, "-g", "-I.", PATH_header, PATH_deb, "-o", name_x, name_c, 0};
#define anz_args_c 9
#endif
#endif



#ifdef I_HAVE_KANT
char           *bibliotheken[] = {"-l_kern",
	"-l_ec4", "-l_arith4", "-l_pol4", "-l_matr3",
	"-l_ec3", "-l_arith3", "-l_pol3", "-l_matr2",
	"-l_ec2", "-l_arith2", "-l_pol2", "-l_matr1",
	"-l_pol1", "-l_ec1", "-l_arith1", "-l_list",
"-lKant2", "-lm", "-ltermcap", 0};

#else						  /* else part of #ifdef I_HAVE_KANT */

char           *bibliotheken[] = {"-l_kern",
	"-l_ec4", "-l_arith4", "-l_pol4", "-l_matr3",
	"-l_ec3", "-l_arith3", "-l_pol3", "-l_matr2",
	"-l_ec2", "-l_arith2", "-l_pol2", "-l_matr1",
	"-l_pol1", "-l_ec1", "-l_arith1", "-l_list",
"-lm", "-ltermcap", 0};
#endif



#define DefaultNamesDateiName ".SM.default"



/******** readDefaultNames() ********/

void            readDefaultNames()
{
	FILE           *datei;

	datei = fopen(DefaultNamesDateiName, "r");
	if (datei != NULL) {
		getline(LIB, 100, datei);
		getline(lib, 100, datei);
		getline(name, 100, datei);
	}
	if (*LIB != '\0')
		printf("\n current source library : %s", LIB);
	else
		printf("\n no source library");
	if (*lib != '\0') {
		strcat4(lib_long, SM_HOME, "/modlib/lib", lib, ".a");
#ifndef ___DEBUGGER
		printf("\n current object library : %s", lib_long);
#else
		strcat4(lib_longg, SM_HOME, "/deb/lib", lib, ".a");
		printf("\n current object library : %s", lib_longg);
#endif
	}
	else
		printf("\n no object library");
	if (*name != '\0')
		printf("\n current file name      : %s", name);
	else
		printf("\n no file name");
	printf("\n\n\n");
	mkstring();
}



/******** writeDefaultNames() ********/

void            writeDefaultNames()
{
	FILE           *datei;

	datei = fopen(DefaultNamesDateiName, "w");
	if (datei != NULL) {
		fprintf(datei, "%s\n", LIB);
		fprintf(datei, "%s\n", lib);
		fprintf(datei, "%s\n", name);
		chmod(DefaultNamesDateiName, 00777);
	}
	else
		printf("\nCan't open \"%s\".\n", DefaultNamesDateiName);
}



/******** VersionNumber() ********/

void            VersionNumber()
{
	FILE           *datei;
	char            datname[100];

	strcat2(datname, SM_HOME, "/header/config.h");
	datei = fopen(datname, "r");
	if (datei == NULL) {
		printf("Can't open \"%s\".\n", datname);
		exit();
	}

	do
		fgets(version_nr, 20, datei);
	while (strncmp(version_nr, "SIMATH-Version", 14));
	fscanf(datei, "%s", version_nr);

	fclose(datei);
}


/******** main() ********/

main()
{

	char            hilf[100];
	char           *sp, *getenv(), *terminal;
	char           *eingabe, eingabe_feld[100];

	int             ent, GO = 1, lsschalter, name_c_loeschen, i, j;
	int             prompt = 1;

	signal(SIGINT, abfang);

	VersionNumber();

	kopf();

	readDefaultNames();

	setjmp(umgeb);

	menue();

	while (GO) {

		/*
		 * ioctl liest die aktuellen Bildschirm-Parameter ein. Falls das Maximum (41 Zeilen) fuer die
		 * Funktionen "comment" und "keywords" ueberschritten wird, so wird der Wert explizit auf 41
		 * gesetzt. Der Wert 41 ergibt sich dabei aus der Tatsache, dass die Bildschirmgroesse bei
		 * rlogin einmalig auf 41x90 festgesetzt wird und sich nicht an der tatsaechlichen Groesse
		 * orientiert.
		 */

#ifndef ___NO_WINSIZE___
		ioctl(filedes, TIOCGWINSZ, &win_groesse);
		if (win_groesse.ws_row > 41)
			win_groesse.ws_row = 41;

		terminal = getenv("TERM");

		if (!strcmp("apollo_1280_bw", terminal))
			win_groesse.ws_row -= 3;
		else
			win_groesse.ws_row = 20;
#endif

#ifndef ___NO_WINSIZE___
#define WS_ROW win_groesse.ws_row

#else				/* else part of #ifdef ___NO_WINSIZE___ */

#define WS_ROW 20
#endif


		if (prompt)
			printf(" < ");
		prompt = 1;

		eingabe = eingabe_feld;
		if (gets(eingabe) == NULL) {
			writeDefaultNames();

#ifndef ___APOLLO
			putchar('\n');
#endif
			printf("\n\n                    SM terminated at  ");
			zeit();
			printf("n");
			exit();
		}

		while ((ent = *eingabe++) != '\0') {

			if (isspace(ent))
				continue;

			switch (ent) {

			case 'P':
				gesetzt(name, file name);
				printf(" PRINT \"%s\"\n", name);
				my_system(LPR, 0, 0);
				break;

			case 'R':
				gesetzt(name, file name);
				printf(" RUN \"%s\"\n", name);
				my_system(r, 0, 0);
				break;

			case 'H':
				menue();
				break;

			case 27:
				break;	/* damit z.B. die Tasten MODE, PRINT, HELP und START keine doppelte
					 * Menueausgabe bewirken */

			case 'S':
				lsschalter = 'y';
				gesetzt(name, file name);
				gesetzt(LIB, source library);
				if (!access(name_S, F_OK)) {
					printf("\n \"%s\" already exists!\n\n ", name);
					my_system(lsv1, 0, 0);
					printf("\n overwrite? (y/n) ");
					while (isspace(lsschalter = getchar()));
					while (getchar() != '\n');	/* Eingabepuffer leeren */
					putchar('\n');
				}
				if (lsschalter == 'y')
					if (!my_system(SEL, 0, 0)) {
						printf(" \"%s\" extracted from \"%s\"\n", name, LIB);
						strcat2(hilf, "chmod 644 ", name_S);
						system(hilf);
					}
				break;

			case '_':
				gesetzt(name, file name);
				gesetzt(LIB, source library);
				if (!my_system(DEL, 0, 0))
					printf(" \"%s\" deleted from \"%s\"\n", name, LIB);
				break;

			case '*':
				lsschalter = 'y';
				gesetzt(name, file name);
				gesetzt(LIB, source library);
				if (access(name_S, F_OK)) {
					printf(" no file \"%s\"!\n", name_S);
					lsschalter = 'n';
				}
				if (lsschalter == 'y' && isinarchive(LIB, name_S)) {
					printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, LIB);
					my_system(ARV1, 0, 0);
					printf("\n overwrite? (y/n) ");
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						lsschalter = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(lsschalter = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
				}

				if (lsschalter == 'y') {
					if (my_system(AR, 0, 0));	/* Fehlermeldung erfolgt von `ar'
									 * selbst */
					else {
						printf(" \"ar r %s %s\" done\n", LIB, name_S);
						unlink(name_S);
					}
				}
				break;

			case 'D':
				gesetzt(LIB, source library);
				my_system(DIR, 1, 0);
				break;

			case 'A':
				strcpy(backup, LIB);
				if (LIB[0] != '\0') {
					printf(" current source library : %s  ", LIB);
					printf("\n new source library     : ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}
				else {
					printf(" source library : ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}
				sscanf(zeile, "%s", LIB);
				if (LIB[0] == '\0')
					strcpy(LIB, backup);
				if (LIB[0] == '\'') {
					strcpy(backup, LIB + 1);
					strcat3(LIB, SM_HOME, "/sources/srclib.", backup);
				}
				mkstring();
				break;

			case 'o':
				gesetzt(name, file name);

				if (!access(name_c, F_OK)) {
					loesch_message(name_c);
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						name_c_loeschen = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(name_c_loeschen = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
					if (name_c_loeschen != 'y')
						break;
				}

				printf("\n SM preprocessor started at  ");
				zeit();
				if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
					printf("\n SM preprocessor terminated correctly at  ");
					zeit();
					printf("\n Compiler started at  ");
					zeit();
					if (!my_system(obj, 0, 0))
						printf("\n Compiler terminated correctly at  ");
					else
						printf("\n Compiler terminated incorrectly at  ");
				}
				else
					printf("\n SM preprocessor terminated incorrectly at  ");
				zeit();
#ifndef ___DEBUGGER
				unlink(name_c);
#endif
				unlink(name_P);
				break;

			case 'p':
				gesetzt(name, file name);

				if (!access(name_c, F_OK)) {
					loesch_message(name_c);
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						name_c_loeschen = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(name_c_loeschen = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
					if (name_c_loeschen != 'y')
						break;
				}
				printf("\n SM preprocessor started at  ");
				zeit();
				if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
					printf("\n SM preprocessor terminated correctly at  ");
					zeit();
					printf("\n C preprocessor started at  ");
					zeit();
					if (!my_system(pre, 0, 0)) {
						my_system(LPR1, 0, 0);
						printf("\n C preprocessor terminated correctly at  ");
						zeit();
					}
					else {
						printf("\n C preprocessor terminated incorrectly at  ");
						zeit();
					}
				}
				else {
					printf("\n SM preprocessor terminated incoreectly at  ");
					zeit();
				}
				unlink(name_c);
				unlink(name_P);

				/*
				 * unlink(name_o); 	unlink(name_i);
				 */

				break;

#ifdef ___DEBUGGER
			case '%':
				gesetzt(name, file name);

				if (!access(name_c, F_OK)) {
					loesch_message(name_c);
					while (isspace(ent =
						       *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						name_c_loeschen =
							ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while
							(isspace(name_c_loeschen = getchar()));
						while (getchar() != '\n');

						/*
						 * Eingabepuffer leeren
						 */
						putchar('\n');
					}
					if (name_c_loeschen != 'y')
						break;
				}
				printf("\n SM preprocessor started at  ");
				zeit();
				if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
					printf("\n SM preprocessor terminated correctly at  ");
					zeit();
				}
				else {
					printf("\n SM preprocessor terminated incorrectly at  ");
					zeit();
				}
				unlink(name_P);

				break;
#endif

			case '-':
				gesetzt(name, file name);
				gesetzt(lib, object library);
				if (!my_system(del, 0, 0))
					printf(" \"%s\" deleted from \"%s\"\n", name, lib_long);
#ifdef ___DEBUGGER
				if (!my_system(delg, 0, 0))
					printf(" \"%s\" deleted from \"%s\"\n", name, lib_longg);
#endif
				break;

			case '+':
				lsschalter = 'y';
				gesetzt(name, file name);
				gesetzt(lib, object library);
				if (access(name_o, F_OK)) {
					printf(" no file \"%s\"!\n", name_o);
					lsschalter = 'n';
				}

#ifndef ___DEBUGGER
				if (lsschalter == 'y' && isinarchive(lib_long, name_o)) {
					printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, lib_long);

#else				/* else part of #ifndef ___DEBUGGER */

				if (lsschalter == 'y' && isinarchive(lib_longg, name_o)) {
					printf("\n \"%s\" already exists in \"%s\"!\n\n ", name, lib_longg);
#endif
					my_system(arv1, 0, 0);
					printf("\n overwrite? (y/n) ");
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						lsschalter = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(lsschalter = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
				}

				if (lsschalter == 'y') {
					if (my_system(ar, 0, 0));	/* Fehlermeldung erfolgt von `ar'
									 * selbst */
					else {
						printf(" \"ar r %s %s\" done\n", lib_long, name_o);
#ifndef ___DEBUGGER
						unlink(name_o);
#endif
					}
				}

#ifdef ___DEBUGGER
				if (lsschalter == 'y') {
					if (my_system(arg, 0, 0));	/* Fehlermeldung erfolgt von `ar'
									 * selbst */
					else {
						printf(" \"ar r %s %s\" done\n", lib_longg, name_o);
						unlink(name_o);
					}
				}
#endif

				break;

			case 'a':
				strcpy(backup, lib);
				if (lib[0] != '\0') {
#ifndef ___DEBUGGER
					printf(" current object library : %s  ", lib_long);
					printf("\n new object library     : %s%s*.a ,", SM_HOME, "/modlib/lib");

#else				/* else part of #ifndef ___DEBUGGER */

					printf(" current object library : %s  ", lib_longg);
					printf("\n new object library     : %s%s*.a ,", SM_HOME, "/deb/lib");
#endif
					printf("\n                          * = ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}
				else {
#ifndef ___DEBUGGER
					printf(" object library : %s%s*.a,", SM_HOME, "/modlib/lib");

#else				/* else part of #ifndef ___DEBUGGER */

					printf(" object library : %s%s*.a,", SM_HOME, "/deb/lib");
#endif
					printf("\n                  * = ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}
				sscanf(zeile, "%s", lib);
				if (lib[0] == '.')
					lib[0] = '\0';
				else {
					if (lib[0] == '\0')
						strcpy(lib, backup);
					strcat4(lib_long, SM_HOME, "/modlib/lib", lib, ".a");
#ifdef ___DEBUGGER
					strcat4(lib_longg, SM_HOME, "/deb/lib", lib, ".a");
#endif
				}
				mkstring();
				break;

			case 'd':
				gesetzt(lib, object library);
				my_system(dir, 1, 0);
				break;

			case 'r':
				gesetzt(lib, object library);
				printf(" ranlib %s\n", lib_long);
				my_system(ranlib, 0, 0);
#ifdef ___DEBUGGER
				printf(" ranlib %s\n", lib_longg);
				my_system(ranlibg, 0, 0);
#endif
				break;

			case '!':
				printf(" >>> branching to a subshell\n");
				printf("     Type `CTRL/D' or \"exit\"");
				printf(" in order to return to SM.\n");
				system("$SHELL");
				break;

			case 'Q':
				writeDefaultNames();
				GO = 0;
				*eingabe = '\0';
				printf("\n\n                    SM terminated at  ");
				zeit();
				printf("\n");
				break;

			case 'e':
				gesetzt(name, file name);
				my_system(e, 0, 0);
				break;

			case 'E':
				gesetzt(name, file name);
				my_system(E, 0, 0);
				break;

			case 'c':
				gesetzt(name, file name);

				if (!access(name_c, F_OK)) {
					loesch_message(name_c);
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						name_c_loeschen = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(name_c_loeschen = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
					if (name_c_loeschen != 'y')
						break;
				}

				printf("\n SM preprocessor started at  ");
				zeit();
				if (!my_system(SM_pre, 0, 0) && !my_system(SM_preV3_1, 0, 0)) {
					printf("\n SM preprocessor terminated correctly at  ");
					zeit();
					printf("\n Compiler started at  ");
					zeit();
					if (!my_system(c, 0, 0)) {
#ifndef ___DEBUGGER
						my_system(strip, 0, 0);
#endif
						printf("\n Compiler terminated correctly at  ");
					}
					else
						printf("\n Compiler terminated incorrectly at  ");
				}
				else
					printf("\n SM preprocessor terminated incorrectly at  ");
				zeit();
#ifndef ___DEBUGGER
				unlink(name_c);
#endif
				unlink(name_P);
				break;

			case '?':
				printf(" keyword : ");
				if (gets(zeile) == NULL)
					CTRL_D;
				sscanf(zeile, "%s", helptxt);
				if (helptxt[0] != '\0')
					keywords(helptxt);
				break;

			case '~':
			case '@':
				printf(" documentation of : ");
				if (gets(zeile) == NULL)
					CTRL_D;
				sscanf(zeile, "%s", helptxt);
				if (helptxt[0] != '\0')
					comment(helptxt);
				break;

			case 'C':
				gesetzt(name, file name);

				if (!access(name_c, F_OK)) {
					loesch_message(name_c);
					while (isspace(ent = *eingabe))
						eingabe++;
					if (ent == 'y' || ent == 'n') {
						name_c_loeschen = ent;
						eingabe++;
						putchar('\n');
						putchar('\n');
					}
					else {
						while (isspace(name_c_loeschen = getchar()));
						while (getchar() != '\n');	/* Eingabepuffer leeren */
						putchar('\n');
					}
					if (name_c_loeschen != 'y')
						break;
				}

				printf(" Press `RETURN' or enter additional object libraries ar1 ar2 ... .\n");
				printf(" Linking is done with ar1 as first library.\n : ");
				if (gets(zeile) == NULL)
					CTRL_D;
				getmodlibs(zeile);
				i = 3;
				if (lib[0])
					C[i++] = lib;
				for (j = 0; modlibs[j][0]; j++)
					C[i++] = modlibs[j];
#ifndef ___DEBUGGER
				C[i++] = "___STRIPPEN";

#else				/* else part of #ifndef ___DEBUGGER */

				C[i++] = "___DEBUGGER";
#endif
				C[i] = NULL;
				printf("\n Compiler started in the background at  ");
				zeit();
				my_system(C, 0, 1);
				break;

			case 'N':
				strcpy(backup, name);
				if (name[0] != '\0') {
					printf(" current file name : %s  ", name);
					printf("\n new file name     : ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}
				else {
					printf(" file name : ");
					if (gets(zeile) == NULL)
						CTRL_D;
				}

				sscanf(zeile, "%s", name);
				if (name[0] == '\0')
					strcpy(name, backup);
				mkstring();
				break;

			case '$':
				system(eingabe);
				*eingabe = '\0';
				break;

			default:
				menue();
				break;
			}
		}
	}
	/** Cursor an richtigen Platz setzen **/
	printf(" %c", 8);
	exit();
}



/******** menu() ********/

menue()
{
	printf("   (N)AME :     (e,E)dit     (p)re        (o)bj        (c)omp       (C)comp");
	printf("\n   object :     (a)r name    (d)ir        ar(+)obj     ar(-)obj     (r)anlib");
	printf("\n   SOURCE :     (A)R NAME    (D)IR        Ar(*)SRC     Ar(_)SRC     (S)ELECT");
	printf("\n   (!)   ($)    (?)   (~,@)  (P)RINT      (H)ELP       (R)UN        (Q)UIT   \n");
}



/******** kopf() ********/

kopf()
{
	printf("\n\n\n");

	printf("\n                         **************************           ");
	printf("\n                         *                        *           ");
	printf("\n                         *      S I M A T H       *           ");
	printf("\n                         *                        *           ");
	printf("\n                         **************************           ");
	printf("\n\n\n");

#ifdef ___APOLLO
	printf("\n                    Apollo version %s started at  ", version_nr);
#endif
#ifdef ___SUN
#ifdef ___HP
	printf("\n                    HP version %s started at  ", version_nr);

#else				/* else part of #ifdef ___HP */

	printf("\n                    SUN version %s started at  ", version_nr);
#endif
#endif
	zeit();
	printf("\n");
}



/******** mkstring() ********/

mkstring()
{
	int             i, j;
	static char     llib[100];

	strcat2(name_P, name, ".P");
	strcat2(name_c, name, ".c");
	strcat2(name_o, name, ".o");
	strcat2(name_S, name, ".S");
	strcat2(name_x, name, ".x");
	strcat2(name_c, name, ".c");
	strcat2(name_i, name, ".i");

	strcat3(PATH_header, "-I", SM_HOME, "/header");
	strcat3(PATH_modlib, "-L", SM_HOME, "/modlib");

#ifdef I_HAVE_KANT
	strcat2(PATH_modlib_kant, "-L", KANT_LIB);
	strcat2(PATH_header_kant, "-I", KANT_INCLUDE);
#endif

#ifdef ___DEBUGGER
	strcat3(PATH_deb, "-L", SM_HOME, "/deb");
#endif
	strcat2(PATH_dr, SM_HOME, "/proz/dr");
	strcat2(PATH_pre, SM_HOME, "/proz/preproc.x");
	strcat2(PATH_preV3_1, SM_HOME, "/proz/preV3_1.x");
	strcat2(PATH_CC, SM_HOME, "/proz/CCC");

	strcat2(llib, "-l", lib);
	i = anz_args_c;
	if (lib[0])
		c[i++] = llib;
	for (j = 0; bibliotheken[j]; j++)
		c[i++] = bibliotheken[j];
	c[i] = NULL;
}



 /*
  * Bei den folgenden Funktionen keyword1 und comment1 richtet sich die Anzahl der gleichzeitig ausgegebenen
  * Zeilen beim more - Kommando nach der aktuellen Bildschirmgroesse; bei rlogin ist dies nicht wirksam, da
  * die Bildschirmgroesse in diesem Fall auf 41 Zeilen festgesetzt ist.
  */

FILE           *pfin, *pfout;



/******* keywords() ********/

keywords(txt)
	char           *txt;
{
	extern char    *fgets();
	char            hstr[BUFSIZ], *str, *t, file[300];
	int             j, len = strlen(txt), pos;

	/* str = calloc( BUFSIZ, sizeof(char) ); *//* ??????????? */

	strcat2(file, SM_HOME, "/doku/HKEYWORDS");
	if ((pfin = fopen(file, "r")) == NULL) {
		printf(" Can't open \"%s\".\n", file);
		return (0);
	}

	while ((t = fgets(hstr, BUFSIZ, pfin)) && strncmp(hstr, txt, len));

	if (t) {
		len = strlen(hstr);
		str = hstr;
		for (j = 0; !(isspace(hstr[j])) && hstr[j] != '\0'; j++, str++);
		str += 2;
		hstr[j] = '\0';
		for (j = 0; !(isspace(str[j])) && str[j] != '\0'; j++);
		j--;
		str = str + j;
		len = strlen(str);
		pos = 0;
		while (isspace(*str))
			str++;
		while (*str != '\0') {
			if (isdigit(*str))
				pos = 10 * pos + *str - '0';
			str++;
		}
		keywords1(txt, pos);
	}
	else
		printf("\n*** no keyword \"%s\"", txt);
	printf("\n\n");
	fclose(pfin);
}



FILE           *pf;
static int      zaehl;



/******** keywords1() ********/

keywords1(txt, pos)
	char           *txt;
	int             pos;
{
	extern char    *fgets();
	char            hstr[BUFSIZ], str[37][BUFSIZ], *t, c, file[300];
	int             len = strlen(txt), lauf, strzaehl, spacezaehl, sch;
	zaehl = 0;
	strcat2(file, SM_HOME, "/doku/KEYWORDS");
	if ((pf = fopen(file, "r")) == NULL) {
		printf(" Can't open \"%s\".\n", file);
		return (0);
	}
	fseek(pf, pos, 0);
	while ((t = fgets(hstr, BUFSIZ, pf)) && strncmp(hstr, txt, len));
	if (t) {
		fprintf(stdout, "\n\n");
		strzaehl = spacezaehl = 0;
		sch = 1;
		strcpy(str[0], hstr);
		while (sch) {
			while (isspace(c = getc(pf)) && c != '\n')
				spacezaehl++;
			if (c != '\n') {
				ungetc(c, pf);
				if (fgets(hstr, BUFSIZ, pf) == NULL)
					break;
				if (strncmp(hstr, "- Seite", 7) != NULL &&
				    strncmp(hstr, "KEYWORDS", 8) != NULL &&
				    strncmp(hstr, "__________", 10) != NULL) {
					if (spacezaehl) {
						spacezaehl = 0;
						strzaehl++;
						if (strzaehl >= (WS_ROW - 4)) {
							strzaehl--;
							if (zaehl + strzaehl > (WS_ROW - 4))
								sch = keywords2();
							if (!sch)
								break;
							if (str[0][0] != '\n') {
								fprintf(stdout, "%s", str[0]);
								zaehl++;
							}
							for (lauf = 1; lauf <= strzaehl; lauf++) {
								fprintf(stdout, "\t\t\t%s", str[lauf]);
								zaehl++;
							}
							strzaehl = 1;
							str[0][0] = '\0';
						}
						strcpy(str[strzaehl], hstr);
					}
					else {
						if (zaehl + strzaehl + 1 > (WS_ROW - 4))
							sch = keywords2();
						if (!sch)
							break;
						if (str[0][0] != '\n') {
							fprintf(stdout, "%s", str[0]);
							zaehl++;
						}
						for (lauf = 1; lauf <= strzaehl; lauf++) {
							fprintf(stdout, "\t\t\t%s", str[lauf]);
							zaehl++;
						}
						if (strncmp(hstr, txt, len) == NULL) {
							strcpy(str[0], hstr);
							strzaehl = 0;
						}
						else
							sch = 0;
					}
				}
			}
			else
				spacezaehl = 0;
		}
	}
	fclose(pf);
}



/******** keywords2() ********/

keywords2()
{
	int             c;

	printf("\n\n                                                  continue/quit    1/0 \n");
	c = getchar();
	while (getchar() != '\n');	/* Eingabepuffer leeren */
	zaehl = 0;
	if (c == '0')
		return (0);
	else
		return (1);
}



/******** comment() ********/

comment(txt)
	char           *txt;
{
	extern char    *fgets();
	char            hstr[BUFSIZ], *str, *str1, *t, file[300];
	int             j, len, pos, sl, k;

	/* str = calloc( BUFSIZ, sizeof(char) ); *//* ????????????? */

	strcat2(file, SM_HOME, "/doku/HFUNCTIONS");
	if ((pfin = fopen(file, "r")) == NULL) {
		printf(" Can't open \"%s\".\n", file);
		return (0);
	}

	for (j = 0; (isspace(txt[j]) && txt[j] != '\0') || txt[j] == '?'; j++);
	if (txt[j] == '\0')
		return (0);

	len = strlen(txt);

	while ((t = fgets(hstr, BUFSIZ, pfin)) && strncmp(hstr, txt, len));

	if (t) {
		str = hstr;
		for (j = 0; !(isspace(hstr[j])) && hstr[j] != '\0'; j++, str++);
		str += 2;
		hstr[j] = '\0';
		for (j = 0; !(isspace(str[j])) && str[j] != '\0'; j++);
		j--;
		str = str + j;
		pos = 0;
		while (isspace(*str) && *str != '\0')
			str++;
		str1 = str;
		for (j = 0; !(isspace(str1[j])) && str1[j] != '\0'; j++, str++);
		str += 2;
		str1[j] = '\0';
		while (*str != '\0') {
			if (isdigit(*str))
				pos = 10 * pos + *str - '0';
			str++;
		}
		comment1(txt, str1, pos);
	}
	else
		printf("\n*** no function \"%s\"", txt);
	printf("\n\n");
	fclose(pfin);
}



/******** comment1() ********/

comment1(txt, datei, pos)
	char           *txt, *datei;
	int             pos;
{
	extern char    *fgets();
	char            hstr[BUFSIZ], str[37][BUFSIZ], *t, c;
	char            file[300];
	int             len = strlen(txt), lauf, strzaehl, spacezaehl, sch;
	int             j, k, sl;

	strcat3(file, SM_HOME, "/doku/", datei);

	zaehl = 0;
	if ((pf = fopen(file, "r")) == NULL) {
		printf(" Can't open \"%s\".\n", file);
		return (0);
	}
	fseek(pf, pos, 0);

	while ((t = fgets(hstr, BUFSIZ, pf))) {
		for (j = 0; isspace(hstr[j]) && hstr[j] != '\0'; j++);
		if (j) {
			sl = strlen(hstr) - j + 1;
			for (k = 0; k < sl; k++)
				hstr[k] = hstr[k + j];
			sl--;
		}
		else
			sl = strlen(hstr);
		sl--;
		while (isspace(hstr[sl]))
			sl--;
		hstr[sl + 1] = '\0';
		if (hstr[0] != '\0')
			if (strncmp(hstr, txt, len) == NULL)
				break;
	}

	if (t) {
		fprintf(stdout, "\n\n");
		strzaehl = 0;
		sch = 1;
		strcpy(str[0], hstr);
		fgets(hstr, BUFSIZ, pf);
		strzaehl++;
		strcpy(str[strzaehl], hstr);
		while ((t = fgets(hstr, BUFSIZ, pf))) {
			sl = strlen(hstr);
			sl--;
			while (isspace(hstr[sl]) && sl >= 0)
				sl--;
			hstr[sl + 1] = '\0';
			sch = 1;
			if (hstr[0] == '\0')
				while ((t = fgets(hstr, BUFSIZ, pf))) {
					sl = strlen(hstr);
					sl--;
					while (isspace(hstr[sl]) && sl >= 0)
						sl--;
					hstr[sl + 1] = '\0';
					if (hstr[0] != '\0')
						if (hstr[0] != '-') {
							sch = 0;
							break;
						}
						else {
							for (lauf = 1; lauf <= 11; lauf++) {
								t = fgets(hstr, BUFSIZ, pf);
								if (t == NULL) {
									sch = 0;
									break;
								}
							}
							if (!sch)
								break;
							if (isspace(hstr[0]) && isspace(hstr[1])) {
								sch = 0;
								break;
							}
							sl = strlen(hstr);
							sl--;
							while (isspace(hstr[sl]) && sl >= 0)
								sl--;
							hstr[sl + 1] = '\0';
						}
				}
			if (!sch)
				break;
			strzaehl++;
			if (strzaehl >= (WS_ROW - 4)) {
				if (str[0][0] != '\0')
					fprintf(stdout, "\n\t\t\t%s", str[0]);
				for (lauf = 1; lauf < strzaehl; lauf++)
					fprintf(stdout, "\n%s", str[lauf]);
				str[0][0] = '\0';
				strzaehl = 0;
				if (!comment2())
					break;
				strzaehl = 1;
			}
			strcpy(str[strzaehl], hstr);
		}
		if (str[0][0] != '\0')
			fprintf(stdout, "\n\t\t\t%s", str[0]);
		for (lauf = 1; lauf <= strzaehl; lauf++)
			fprintf(stdout, "\n%s", str[lauf]);
	}
	fprintf(stdout, "\n\n");

	fclose(pf);
}



/******** comment2() ********/

comment2()
{
	int             c;

	printf("\n\n                                                  continue/quit    1/0 \n");
	c = getchar();
	while (getchar() != '\n');	/* Eingabepuffer leeren */
	zaehl = 0;
	return (c != '0');
}



#include <sys/wait.h>



/******** my_system() ********/

int             my_system(command, flag, background)
	char          **command;
	int             flag, background;
{
	int             pid;
	union wait      status;
	int             i;
	int             retValue;

#ifdef TEST
	for (i = 0; command[i]; i++)
		fprintf(stderr, "my_system: %d.Argument: %s\n",
			i, command[i]);
#endif

	switch (pid = fork()) {
	case -1:
		perror("fork");
		retValue = (-1);
		break;
	case 0:
		command++;
		if (flag)
			page(command);
		else {
			/*
			 * Der folgende "Salto" ist noetig, damit beim Compilieren an Apollo-Consolen ('o',
			 * 'c', 't', 'C', 'T') Fehlermeldungen auf dem Bildschirm erscheinen und nicht
			 * verschluckt werden.
			 */
#ifdef ___APOLLO
			int             i;
			for (i = 3; i <= 20; i++)
				close(i);
#endif
			if (execv(command[-1], command)) {
				perror(command[-1]);
				exit(-1);
			}
		}
	default:
		if (background)
			retValue = 0;
		else {
			while (wait(&status) != pid);
			retValue = status.w_retcode;
		}

		break;
	}
	return (retValue);
}



/******** page() ********/

int             page(command)
	char           *command[];

{
	int             p[2];
	int             page_pid;

	if (pipe(p) < 0)
		return (0);
	switch (page_pid = fork()) {
	case 0:
		close(p[0]);
		close(1);
		dup(p[1]);
		close(p[1]);
		if (execv(command[-1], command)) {
			perror(command[-1]);
			return (-1);
		}
	case -1:
		return (-1);
	default:
		close(p[1]);
		close(0);
		dup(p[0]);
		close(p[0]);
		execl(PAGE_COMMAND, PAGE_SHORT_COMMAND, "-d", 0);
		perror("page");
		return (-1);
	}
}



#include <ar.h>

int             af;
char            b2[100];
struct ar_hdr   header;
int             erfolg;



/******** getheader() ********/

long            getheader()
{
	int             n;
	long            size;
	int             i = 15;

	while (b2[i] == ' ')
		i--;
	n = read(af, &header, sizeof(struct ar_hdr));
	if (n != sizeof(struct ar_hdr))
		return (0);
	sscanf(header.ar_size, "%ld", &size);
	if (!strncmp(header.ar_name, b2, i)) {
		erfolg = 1;
		return (0);
	}
	if (size & 1)
		size++;
	return (size);
}



/******** isinarchive() ********/

int             isinarchive(archive, member)
	char           *archive, *member;
{
	char            buf[BUFSIZ];
	long            pos;

	erfolg = 0;
	strcat2(b2, member, "                ");
	b2[16] = '\0';
	if ((af = open(archive, 0, 0)) < 0) {
#ifdef TEST
		perror(archive);
#endif
		return (0);
	}
	if ((read(af, buf, SARMAG) != SARMAG) || (strncmp(buf, ARMAG, 7))) {
		close(af);
		return (0);
	}
	while ((pos = getheader()) > 0) {
		lseek(af, pos, L_INCR);
	}
	close(af);
	return (erfolg);
}



/******** getmodlibs() ********/

int             getmodlibs(zeile)
	char           *zeile;
{
	char           *strtok();
	char           *p;
	static char    *sep = " \t\n";
	int             i;

	i = 0;
	modlibs[0][0] = 0;
	if (p = strtok(zeile, sep)) {
		strcpy(modlibs[i++], p);
		do {
			p = strtok(NULL, sep);
			if (p)
				strcpy(&modlibs[i++][0], p);
			else
				modlibs[i][0] = '\0';
		}
		while (p);
	}
}



/******** loesch_message() ********/

int             loesch_message(loesch_name)
	char            loesch_name[100];

{
	printf("\n File \"%s\" exists.\n", loesch_name);
	printf(" overwrite? (y/n) ");
}



/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char     sccsid[] = "@(#)strtok.c	5.8 (Berkeley) 2/24/91";
#endif						  /* LIBC_SCCS and not lint */

#if 0
#include <stddef.h>
#include <string.h>
#else
#define NULL 0
#endif

char           *
                strtok_spec(s, delim)
	register char  *s;
	register char  *delim;
{
	register char  *spanp;
	register int    c, sc;
	char           *tok;
	static char    *last;


	if (s == NULL && (s = last) == NULL)
		return (NULL);

	/*
	 * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
	 */
cont:
	c = *s++;
	for (spanp = (char *) delim; (sc = *spanp++) != 0;) {
		if (c == sc)
			goto cont;
	}

	if (c == 0) {		/* no non-delimiter characters */
		last = NULL;
		return (NULL);
	}
	tok = s - 1;

	/*
	 * Scan token (scan for delimiters: s += strcspn(s, delim), sort of). Note that delim must have one
	 * NUL; we stop if we see that, too.
	 */
	for (;;) {
		c = *s++;
		spanp = (char *) delim;
		do {
			if ((sc = *spanp++) == c) {
				if (c == 0)
					s = NULL;
				else
					s[-1] = 0;
				last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	/* NOTREACHED */
}
