# 
# -----------------------------------------------------------------------------
# 
# This file is part of the computer algebra system SIMATH.
# 
# SIMATH is a common software product of the SIMATH group in Saarbruecken
# and the Siemens AG. Copyright (C) 1992-1993 by the SIMATH group in
# Saarbruecken and the Siemens AG/Munich.
# 
# The computer algebra system SIMATH is free software for universities
# and scientific research institutions as long as it is used for purely
# scientific purposes only. This software is distributed in the hope that
# it will be useful, but
# 
# 			WITHOUT ANY WARRANTY.
# 
# 
# Permission is hereby granted to copy the system for any 
# 
# 			PURELY SCIENTIFIC
# 
# purposes, provided the above notices are retained on all copies.
# 
# If you intend to use SIMATH for other applications, please contact
# 	
# 	SIEMENS AG
# 	Corporate Research and Development
# 	Dept. ZFE ST SN 3
# 	D-81730 Munich
# 
# Upon reception of this software, please send e-mail messages to
# 
# 	simath@math.uni-sb.de 			and to	
# 	Heribert.Peuckert@zfe.siemens.de
# 
# to inform us that you got a copy of the system. 
# 
# Redistribution of this software - either in source or binary form - is
# not permitted.

# This file defines some macros which are used during the installation
# process and the rules for compiling SIMATH programs, especially for
# compiling the libraries.


# "SM_HOME" is the name of the directory in which SIMATH will be
# installed. Change this according to your needs.

SM_HOME=/usr/local/simath
 

# Where to link the executables.

BINDIR=/usr/local/bin
 

# How to install files and directories. 
# On Sun workstations set "INSTALLDIR=install -d -m 755" and
# "INSTALLFILE=install -m 755" or something like that. On Apollo, HP, and
# SGI workstations use "INSTALLDIR=mkdir" and "INSTALLFILE=cp".

# >> Apollos, HP, SGI
# INSTALLDIR=mkdir
# INSTALLFILE=cp
# >> Sun
INSTALLDIR=install -d -m 755 
INSTALLFILE=install -m 755


# How to make a link.  
# On some machines it is not possible to link across discs.  On other
# machines there are no softlinks.  In such a case, you can use "LN=cp"
# to copy the files.

# >> Apollo, HP, SGI, Sun
LN=ln -s 


# On HP workstations you should use "gcc", because the optimizer of "cc"
# causes problems. If you intend to use Kant and the SIMATH-Kant
# interface, use "CC=gcc" on Suns.

# >> Apollo, SGI, Sun
CC=cc
# >> HP, Sun
# CC=gcc


# If your system usually requires additional flags for the C
# preprocessor, you may add these flags here.

# >> Apollo, HP, SGI, Sun
CPPFLAGS=-I../../header


# If your system usually requires additional flags for the C compiler you
# may add these flags here. On SGI workstations use the -cckr flag to
# compile the libraries. This avoids problems with statically declared
# functions.

# >> Apollo, HP, Sun
CFLAGS=-O
# >> SGI
# CFLAGS=-O -cckr


# If your system usually requires additional flags for the linker, you may
# add these flags here.

# Apollos, HP, Sun
LDFLAGS=

#
#
# Do not change these rules unless you know what you are doing. If you
# know what you are doing and if you find better rules for compiling
# SIMATH programs, please let us know.
#
#

.Suffixes: .s .c .o .P .S .x

.S.o:
	../../proz/preV3_1.x $*.S $*.P; ../../proz/preproc.x $*.P $*.c; rm -f $*.P
	$(CC) $*.c $(CPPFLAGS) $(CFLAGS) -c; rm $*.c

.s.o:
	as $*.s -o $*.o $(CPPFLAGS)



